'use strict';
window.Shortcode = window.Shortcode || {};

(function ($, Shortcode, w) {
    var $window = $(w);
    
    $window.on('elementor/frontend/init', function() {
        var SAEffects = elementorModules.frontend.handlers.Base.extend({
            onInit: function() {
                elementorModules.frontend.handlers.Base.prototype.onInit.apply(this, arguments);
                this.$container = this.$element.find('.elementor-widget-container')[0];
                this.run();
            },

            getDefaultSettings: function() {
                return {
                    targets: this.$container,
                    loop: true,
                    direction: 'alternate',
                    easing: 'easeInOutSine',
                };
            },

            onElementChange: function() {
                this.animation && this.animation.restart();
                this.run();
            },

            getConfig: function(key) {
                return this.getElementSettings('sa_el_floating_fx_' + key);
            },

            run: function() {
                var config = this.getDefaultSettings();

                if (this.getConfig('translate_toggle')) {
                    if (this.getConfig('translate_x.size') || this.getConfig('translate_x.sizes.to')) {
                        config.translateX = {
                            value: [this.getConfig('translate_x.sizes.from') || 0, this.getConfig('translate_x.size') || this.getConfig('translate_x.sizes.to')],
                            duration: this.getConfig('translate_duration.size'),
                            delay: this.getConfig('translate_delay.size') || 0
                        }
                    }
                    if (this.getConfig('translate_y.size') || this.getConfig('translate_y.sizes.to')) {
                        config.translateY = {
                            value: [this.getConfig('translate_y.sizes.from') || 0, this.getConfig('translate_y.size') || this.getConfig('translate_y.sizes.to')],
                            duration: this.getConfig('translate_duration.size'),
                            delay: this.getConfig('translate_delay.size') || 0
                        }
                    }
                }

                if (this.getConfig('rotate_toggle')) {
                    if (this.getConfig('rotate_x.size') || this.getConfig('rotate_x.sizes.to')) {
                        config.rotateX = {
                            value: [this.getConfig('rotate_x.sizes.from') || 0, this.getConfig('rotate_x.size') || this.getConfig('rotate_x.sizes.to')],
                            duration: this.getConfig('rotate_duration.size'),
                            delay: this.getConfig('rotate_delay.size') || 0
                        }
                    }
                    if (this.getConfig('rotate_y.size') || this.getConfig('rotate_y.sizes.to')) {
                        config.rotateY = {
                            value: [this.getConfig('rotate_y.sizes.from') || 0, this.getConfig('rotate_y.size') || this.getConfig('rotate_y.sizes.to')],
                            duration: this.getConfig('rotate_duration.size'),
                            delay: this.getConfig('rotate_delay.size') || 0
                        }
                    }
                    if (this.getConfig('rotate_z.size') || this.getConfig('rotate_z.sizes.to')) {
                        config.rotateZ = {
                            value: [this.getConfig('rotate_z.sizes.from') || 0, this.getConfig('rotate_z.size') || this.getConfig('rotate_z.sizes.to')],
                            duration: this.getConfig('rotate_duration.size'),
                            delay: this.getConfig('rotate_delay.size') || 0
                        }
                    }
                }

                if (this.getConfig('scale_toggle')) {
                    if (this.getConfig('scale_x.size') || this.getConfig('scale_x.sizes.to')) {
                        config.scaleX = {
                            value: [this.getConfig('scale_x.sizes.from') || 0, this.getConfig('scale_x.size') || this.getConfig('scale_x.sizes.to')],
                            duration: this.getConfig('scale_duration.size'),
                            delay: this.getConfig('scale_delay.size') || 0
                        }
                    }
                    if (this.getConfig('scale_y.size') || this.getConfig('scale_y.sizes.to')) {
                        config.scaleY = {
                            value: [this.getConfig('scale_y.sizes.from') || 0, this.getConfig('scale_y.size') || this.getConfig('scale_y.sizes.to')],
                            duration: this.getConfig('scale_duration.size'),
                            delay: this.getConfig('scale_delay.size') || 0
                        }
                    }
                }

                if (this.getConfig('translate_toggle') || this.getConfig('rotate_toggle') || this.getConfig('scale_toggle')) {
                    this.$container.style.setProperty('will-change', 'transform');
                    this.animation = anime(config);
                }
            }
        });

        elementorFrontend.hooks.addAction(
            'frontend/element_ready/widget',
            function($scope) {
                elementorFrontend.elementsHandler.addHandler(SAEffects, {$element: $scope});
            }
        );
    });
    
    
} (jQuery, Shortcode, window));

    