<div class="ekit-admin-card ekit-admin-card-shadow">
	<img src="<?php echo esc_url(self::get_url() . 'assets/images/banner_dashboard.png'); ?>" class="ekit-admin-dashboard-banner" />
</div>

<!-- Documentation -->
<div class="ekit-admin-section ekit-admin-dual-layout ekit-admin-documentation-section">
	<div class="ekit-admin-left-thumb">
		<img src="<?php echo esc_url(self::get_url() . 'assets/images/documentation-thumb.png'); ?>" alt="<?php esc_attr_e( 'Documentation Thumb', 'elementskit-lite' ); ?>">
	</div>
	<div class="ekit-admin-right-content">
		<div class="ekit-admin-right-content--heading">
			<h2><?php esc_html_e( 'Easy Documentation', 'elementskit-lite' ); ?></h2>
			<span class="ekit-admin-right-content--heading__sub-title"><?php esc_html_e( 'Docs', 'elementskit-lite' ); ?></span>
		</div> 
		<p><?php esc_html_e( 'Get started by spending some time with the documentation to get familiar with ElementsKit Lite. Build awesome websites for you or your clients with ease.', 'elementskit-lite' ); ?></p>
		<div class="ekit-admin-right-content--button">
			<a target="_blank" href="https://wpmet.com/doc/elementskit/" class="attr-btn attr-btn-primary ekit-admin-right-content--link"><i class="fa fa-newspaper-o"></i><?php esc_html_e( 'Get started', 'elementskit-lite' ); ?></a>
		</div>
	</div>
</div>

<!-- Video tutorials -->
<div class="ekit-admin-section ekit-admin-faq-section">
	<div class="ekit-admin-right-content attr-text-center">
		<div class="ekit-admin-right-content--heading">
			<h2><?php esc_html_e( 'Video Tutorials', 'elementskit-lite' ); ?></h2>
			<span class="ekit-admin-right-content--heading__sub-title"><?php esc_html_e( 'Tutorials', 'elementskit-lite' ); ?></span>
		</div> 
		<p><?php esc_html_e( 'Get started by spending some time with the documentation to get familiar with ElementsKit Lite.', 'elementskit-lite' ); ?></p>
	</div>

	<div class="ekit-admin-video-tutorial-list">
		<div class="ekit-admin-video-tutorial-item">
			<a target="_blank" href="https://wpmet.com/plugin/elementskit/parallax-landing/">
				<div class="tutorial-thumb">
					<img src="<?php echo esc_url(self::get_url() . 'assets/images/suport-thumb.png'); ?>" alt="<?php esc_attr_e( 'Totorial Thumb', 'elementskit-lite' ); ?>">
				</div>
				<h2><?php esc_html_e( 'Parallax Effects', 'elementskit-lite' ); ?></h2>
			</a>
		</div>
		<div class="ekit-admin-video-tutorial-item">
			<a href="#" data-video_id="oV-7-NNiGZo">
				<div class="tutorial-thumb">
					<img src="<?php echo esc_url(self::get_url() . 'assets/images/subscribed-thumb.png'); ?>" alt="<?php esc_attr_e( 'Totorial Thumb', 'elementskit-lite' ); ?>">
				</div>
				<h2><?php esc_html_e( 'Advanced Accordions', 'elementskit-lite' ); ?></h2>
			</a>
		</div>
		<div class="ekit-admin-video-tutorial-item">
			<a href="#" data-video_id="LfFN08Y9VQE">
				<div class="tutorial-thumb">
					<img src="<?php echo esc_url(self::get_url() . 'assets/images/featured-request-thumb.png'); ?>" alt="<?php esc_attr_e( 'Totorial Thumb', 'elementskit-lite' ); ?>">
				</div>
				<h2><?php esc_html_e( 'Mega Menu Builder', 'elementskit-lite' ); ?></h2>
			</a>
		</div>
	</div>
	<div class="ekti-admin-video-tutorial-popup">
		<div class="ekti-admin-video-tutorial-popup-content">
			<div class="ekti-admin-video-tutorial-iframe"></div>
			<div class="ekti-admin-video-tutorial-close"><i class="fa fa-times"></i></div>
		</div>
	</div>

	
	<div class="ekit-admin-right-content--button attr-text-center">
		<a target="_blank" href="https://www.youtube.com/watch?v=ps7knxZpDFI&list=PL3t2OjZ6gY8MVnyA4OLB6qXb77-roJOuY" class="attr-btn attr-btn-primary ekit-admin-right-content--link"><i class="fa fa-check-circle"></i><?php esc_html_e( 'watch more videos', 'elementskit-lite' ); ?></a>
	</div>
</div>

<!-- FAQ -->
<div class="ekit-admin-section ekit-admin-faq-section" style="display: none">
	<div class="ekit-admin-right-content attr-text-center">
		<div class="ekit-admin-right-content--heading">
			<h2><?php esc_html_e( 'General Knowledge Base', 'elementskit-lite' ); ?></h2>
			<span class="ekit-admin-right-content--heading__sub-title"><?php esc_html_e( 'FAQ', 'elementskit-lite' ); ?></span>
		</div> 
		<p><?php esc_html_e( 'Get started by spending some time with the documentation to get familiar with ElementsKit Lite.', 'elementskit-lite' ); ?></p>
	</div>

	<div class="ekit-admin-accordion">
		<div class="ekit-admin-single-accordion">
			<h2 class="ekit-admin-single-accordion--heading"><?php esc_html_e( '1. How to create a shop page in ElementsKit Lite?', 'elementskit-lite' ); ?></h2>
			<div class="ekit-admin-single-accordion--body">
				<div class="ekit-admin-single-accordion--body__content">
					<p><?php esc_html_e( 'You will get 20+ complete homepages and total 450+ blocks in our layout library and we’re continuously updating the numbers there.', 'elementskit-lite' ); ?></p>
				</div>
			</div>
		</div>
		<div class="ekit-admin-single-accordion">
			<h2 class="ekit-admin-single-accordion--heading"><?php esc_html_e( '2. How to translate theme with WPML?', 'elementskit-lite' ); ?></h2>
			<div class="ekit-admin-single-accordion--body">
				<div class="ekit-admin-single-accordion--body__content">
					<p><?php esc_html_e( 'You will get 20+ complete homepages and total 450+ blocks in our layout library and we’re continuously updating the numbers there.', 'elementskit-lite' ); ?></p>
				</div>
			</div>
		</div>
		<div class="ekit-admin-single-accordion">
			<h2 class="ekit-admin-single-accordion--heading"><?php esc_html_e( '3. How to add custom css in specific section shortcode?', 'elementskit-lite' ); ?></h2>
			<div class="ekit-admin-single-accordion--body">
				<div class="ekit-admin-single-accordion--body__content">
					<p><?php esc_html_e( 'You will get 20+ complete homepages and total 450+ blocks in our layout library and we’re continuously updating the numbers there.', 'elementskit-lite' ); ?></p>
				</div>
			</div>
		</div>
	</div>

	
	<div class="ekit-admin-right-content--button attr-text-center">
		<a target="_blank" href="https://www.youtube.com/channel/UCpsjAqTeTqwFTMV580D3YvQ" class="attr-btn attr-btn-primary ekit-admin-right-content--link"><i class="fa fa-question-circle"></i><?php esc_html_e( 'View all faq’s', 'elementskit-lite' ); ?></a>
	</div>
</div>

<!-- Support -->
<div class="ekit-admin-section ekit-admin-dual-layout ekit-admin-support-section">
<div class="ekit-admin-right-content">
		<div class="ekit-admin-right-content--heading">
			<h2><?php esc_html_e( 'Top-notch Friendly Support', 'elementskit-lite' ); ?></h2>
			<span class="ekit-admin-right-content--heading__sub-title"><?php esc_html_e( 'Support', 'elementskit-lite' ); ?></span>
		</div> 
		<p><?php esc_html_e( 'Get started by spending some time with the documentation to get familiar with ElementsKit Lite. Build awesome websites for you or your clients with ease.', 'elementskit-lite' ); ?></p>
		<div class="ekit-admin-right-content--button">
			<a target="_blank" href="https://wpmet.com/support-ticket-form/" class="attr-btn attr-btn-primary ekit-admin-right-content--link"><i class="fa fa-question-circle"></i><?php esc_html_e( 'Join support forum', 'elementskit-lite' ); ?></a>
		</div>
	</div>
	
	<div class="ekit-admin-left-thumb">
		<img src="<?php echo esc_url(self::get_url() . 'assets/images/suport-thumb.png'); ?>" alt="<?php esc_attr_e( 'Documentation Thumb', 'elementskit-lite' ); ?>">
	</div>
	
</div>

<!-- Feature a Request -->
<div class="ekit-admin-section ekit-admin-dual-layout ekit-admin-feature-request-section ekit-admin-except-title">
	<div class="ekit-admin-left-thumb">
		<img src="<?php echo esc_url(self::get_url() . 'assets/images/featured-request-thumb.png'); ?>" alt="<?php esc_attr_e( 'Feature a Request Thumb', 'elementskit-lite' ); ?>">
	</div>
	<div class="ekit-admin-right-content">

		<p><?php esc_html_e( 'Maybe we’re missing something you can’t live without.', 'elementskit-lite' ); ?></p>
		<div class="ekit-admin-right-content--button">
			<a target="_blank" href="https://wpmet.com/plugin/elementskit/roadmaps/#ideas" class="attr-btn attr-btn-primary ekit-admin-right-content--link"><i class="fa fa-check-circle"></i><?php esc_html_e( 'Feature a request', 'elementskit-lite' ); ?></a>
		</div>
	</div>
</div>

<!-- Rate Now -->
<div class="ekit-admin-section ekit-admin-dual-layout ekit-admin-rate-now-section ekit-admin-except-title">
	
	<div class="ekit-admin-right-content">

		<p><span><?php esc_html_e( 'Satisfied?', 'elementskit-lite' ); ?></span><?php esc_html_e( 'Don’t forget to rate our item.', 'elementskit-lite' ); ?></p>
		<div class="ekit-admin-right-content--button">
			<a target="_blank" href="https://wordpress.org/support/plugin/elementskit-lite/reviews/?rate=5#new-post" class="attr-btn attr-btn-primary ekit-admin-right-content--link"><i class="fa fa-star"></i><?php esc_html_e( 'Rate it now', 'elementskit-lite' ); ?></a>
		</div>
	</div>

	<div class="ekit-admin-left-thumb">
		<img src="<?php echo esc_url(self::get_url() . 'assets/images/rate-now-thumb.png'); ?>" alt="<?php esc_attr_e( 'Rate Now Thumb', 'elementskit-lite' ); ?>">
	</div>
</div>
