/**
 * WordPress dependencies
 */
import { forwardRef } from '@wordpress/element';

/**
 * Internal dependencies
 */
import { Button } from './styles.js';

export const StripeButton = forwardRef( ( props, ref ) => {
	return <Button isPrimary variant="primary" { ...props } ref={ ref } />;
} );

export function StripeLogo() {
	return (
		<svg
			width={ 56 }
			height={ 23 }
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M55.742 11.884c0-3.93-1.92-7.032-5.59-7.032-3.684 0-5.914 3.101-5.914 7.001 0 4.622 2.632 6.955 6.41 6.955 1.843 0 3.236-.414 4.29-.998v-3.07c-1.053.522-2.261.844-3.794.844-1.502 0-2.834-.522-3.004-2.334h7.572c0-.2.03-.998.03-1.366Zm-7.649-1.459c0-1.735 1.069-2.456 2.044-2.456.945 0 1.951.721 1.951 2.456h-3.995Zm-9.832-5.573c-1.517 0-2.493.706-3.035 1.197l-.201-.952h-3.407V23l3.871-.814.016-4.345c.557.4 1.378.967 2.74.967 2.772 0 5.296-2.21 5.296-7.078-.015-4.452-2.57-6.878-5.28-6.878Zm-.929 10.579c-.913 0-1.456-.323-1.827-.722l-.016-5.696c.403-.446.96-.753 1.843-.753 1.41 0 2.385 1.566 2.385 3.578 0 2.057-.96 3.593-2.385 3.593ZM26.292 3.946l3.886-.83V0l-3.886.814v3.132Zm0 1.167h3.886v13.434h-3.886V5.113Zm-4.165 1.136-.248-1.136h-3.345v13.434h3.871V9.443c.914-1.183 2.462-.968 2.942-.799V5.113c-.495-.184-2.307-.522-3.22 1.136Zm-7.742-4.468-3.778.798-.016 12.299c0 2.272 1.719 3.946 4.01 3.946 1.27 0 2.2-.23 2.71-.507V15.2c-.495.2-2.942.906-2.942-1.366v-5.45h2.942V5.112H14.37l.016-3.332ZM3.917 9.013c0-.6.496-.83 1.317-.83 1.176 0 2.663.354 3.84.983V5.558c-1.286-.507-2.555-.706-3.84-.706C2.09 4.852 0 6.479 0 9.197c0 4.238 5.884 3.562 5.884 5.39 0 .705-.62.936-1.487.936-1.285 0-2.926-.522-4.227-1.229v3.655c1.44.614 2.896.875 4.227.875 3.221 0 5.435-1.582 5.435-4.33-.015-4.575-5.915-3.762-5.915-5.481Z"
				fill="#fff"
			/>
		</svg>
	);
}
