(function($) {
  window.SAOffcanvasContent = function($scope) {
    this.node = $scope;
    this.wrap = $scope.find(".sa-el-offcanvas-content-wrap");
    this.content = $scope.find(".sa-el-offcanvas-content");
    this.button = $scope.find(".sa-el-offcanvas-toggle");
    this.settings = this.wrap.data("settings");
    this.id = this.settings.sa_content_id;
    this.transition = this.settings.sa_transition;
    this.esc_close = this.settings.sa_esc_close;
    this.body_click_close = this.settings.sa_body_click_close;
    this.direction = this.settings.sa_direction;
    this.duration = 500;
    this.destroy();
    this.init();
  };

  SAOffcanvasContent.prototype = {
    id: "",
    node: "",
    wrap: "",
    content: "",
    button: "",
    settings: {},
    transition: "",
    duration: 400,
    initialized: false,
    animations: ["slide", "slide-along", "reveal", "push"],

    init: function() {
      if (!this.wrap.length) {
        return;
      }

      $("html").addClass("sa-el-offcanvas-content-widget");

      if ($(".sa-el-offcanvas-container").length === 0) {
        if ("push" === this.transition) {
          $("body").prepend(this.content);
          $("body").wrapInner('<div class="sa-el-offcanvas-container" />');
        } else {
          $("body").wrapInner('<div class="sa-el-offcanvas-container" />');
          this.content.insertBefore(".sa-el-offcanvas-container");
        }
      }

      if (this.wrap.find(".sa-el-offcanvas-content").length > 0) {
        if ("push" === this.transition) {
          if (
            $(
              ".sa-el-offcanvas-container > .sa-el-offcanvas-content-" + this.id
            ).length > 0
          ) {
            $(
              ".sa-el-offcanvas-container > .sa-el-offcanvas-content-" + this.id
            ).remove();
          }
          $(".sa-el-offcanvas-container").prepend(
            this.wrap.find(".sa-el-offcanvas-content")
          );
        } else {
          if (
            $(
              ".sa-el-offcanvas-container > .sa-el-offcanvas-content-" + this.id
            ).length > 0
          ) {
            $(
              ".sa-el-offcanvas-container > .sa-el-offcanvas-content-" + this.id
            ).remove();
          }
          if ($("body > .sa-el-offcanvas-content-" + this.id).length > 0) {
            $("body > .sa-el-offcanvas-content-" + this.id).remove();
          }
          $("body").prepend(this.wrap.find(".sa-el-offcanvas-content"));
        }
      }

      this.bindEvents();
    },

    destroy: function() {
      this.close();

      this.animations.forEach(function(animation) {
        if ($("html").hasClass("sa-el-offcanvas-content-" + animation)) {
          $("html").removeClass("sa-el-offcanvas-content-" + animation);
        }
      });

      if ($("body > .sa-el-offcanvas-content-" + this.id).length > 0) {
          /*
        $('body > .sa-el-offcanvas-content-' + this.id ).remove();*/
      }
    },

    bindEvents: function() {
      this.button.on("click", $.proxy(this.toggleContent, this));

      $("body").delegate(
        ".sa-el-offcanvas-content .sa-el-offcanvas-close",
        "click",
        $.proxy(this.close, this)
      );

      if (this.esc_close === "yes") {
        this.closeESC();
      }
      if (this.body_click_close === "yes") {
        this.closeClick();
      }
    },

    toggleContent: function() {
      if (!$("html").hasClass("sa-el-offcanvas-content-open")) {
        this.show();
      } else {
        this.close();
      }
    },

    show: function() {
      $(".sa-el-offcanvas-content-" + this.id).addClass(
        "sa-el-offcanvas-content-visible"
      );
      $("html").addClass("sa-el-offcanvas-content-" + this.transition);
      $("html").addClass("sa-el-offcanvas-content-" + this.direction);
      $("html").addClass("sa-el-offcanvas-content-open");
      $("html").addClass("sa-el-offcanvas-content-" + this.id + "-open");
      $("html").addClass("sa-el-offcanvas-content-reset");
    },

    close: function() {
      $("html").removeClass("sa-el-offcanvas-content-open");
      $("html").removeClass("sa-el-offcanvas-content-" + this.id + "-open");
      setTimeout(
        $.proxy(function() {
          $("html").removeClass("sa-el-offcanvas-content-reset");
          $("html").removeClass("sa-el-offcanvas-content-" + this.transition);
          $("html").removeClass("sa-el-offcanvas-content-" + this.direction);
          $(".sa-el-offcanvas-content-" + this.id).removeClass(
            "sa-el-offcanvas-content-visible"
          );
        }, this),
        500
      );
    },

    closeESC: function() {
      var self = this;

      if ("" === self.settings.esc_close) {
        return;
      }

      
      $(document).on("keydown", function(e) {
        if (e.keyCode === 27) {
          self.close();
        }
      });
    },

    closeClick: function() {
      var self = this;

      $(document).on("click", function(e) {
        if (
          $(e.target).is(".sa-el-offcanvas-content") ||
          $(e.target).parents(".sa-el-offcanvas-content").length > 0 ||
          $(e.target).is(".sa-el-offcanvas-toggle") ||
          $(e.target).parents(".sa-el-offcanvas-toggle").length > 0
        ) {
          return;
        } else {
          self.close();
        }
      });
    }
  };
})(jQuery);
