/*=================================
 Post Grid
 =================================*/
(function($) {
    "use strict";

    $(document).on("click", ".sa-el-load-more-button", function(e) {
        e.preventDefault();
        e.stopPropagation();
        e.stopImmediatePropagation();
        var $this = $(this),
            $text = $("span", $this).html(),
            $widget_id = $this.data("widget"),
            $scope = $(".elementor-element-" + $widget_id),
            $class = $this.data("class"),
            $function = $this.data("function"),
            $args = $this.data("args"),
            $settings = $this.data("settings"),
            $layout = $this.data("layout"),
            $page = parseInt($this.data("page")) + 1;

        if (typeof $widget_id == 'undefined' || typeof $args == 'undefined') {
            return;
        }

        $this.addClass("button--loading");
        $("span", $this).html("Loading...");

        $.ajax({
            url: sa_el_addons_loader.ajaxurl,
            type: "post",
            data: {
                action: "sa_el_addons_loader",
                _wpnonce: sa_el_addons_loader.nonce,
                class: $class,
                function: $function,
                args: $args,
                settings: $settings,
                optional: $page
            },
            success: function(response) {
                var $content = $(response);
                if ($content.hasClass("no-posts-found") || $content.length == 0) {
                    $this.remove();
                } else {
                    $(".sa-el-post-appender", $scope).append($content);
                    if ($layout == "masonry") {
                        var $isotope = $(".sa-el-post-appender", $scope).isotope();
                        $isotope.isotope("appended", $content).isotope("layout");
                        $isotope.imagesLoaded().progress(function() {
                            $isotope.isotope("layout");
                        });
                    }
                    $this.removeClass("button--loading");
                    $("span", $this).html($text);
                    $this.data("page", $page);
                }
            },
            error: function(response) {
                console.log(response);
            }
        });
    });
})(jQuery);