/*!
 * Chart.js v2.9.4
 * https://www.chartjs.org
 * (c) 2020 Chart.js Contributors
 * Released under the MIT License
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?module.exports=e():"function"==typeof define&&define.amd?define(e):(t=t||self).Chart=e()}(this,function(){"use strict";function Va(){throw new Error("Dynamic requires are not currently supported by rollup-plugin-commonjs")}function t(t,e){return t(e={exports:{}},e.exports),e.exports}var d={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]},u=t(function(t){var u={};for(var e in d)d.hasOwnProperty(e)&&(u[d[e]]=e);var o=t.exports={rgb:{channels:3,labels:"rgb"},hsl:{channels:3,labels:"hsl"},hsv:{channels:3,labels:"hsv"},hwb:{channels:3,labels:"hwb"},cmyk:{channels:4,labels:"cmyk"},xyz:{channels:3,labels:"xyz"},lab:{channels:3,labels:"lab"},lch:{channels:3,labels:"lch"},hex:{channels:1,labels:["hex"]},keyword:{channels:1,labels:["keyword"]},ansi16:{channels:1,labels:["ansi16"]},ansi256:{channels:1,labels:["ansi256"]},hcg:{channels:3,labels:["h","c","g"]},apple:{channels:3,labels:["r16","g16","b16"]},gray:{channels:1,labels:["gray"]}};for(var n in o)if(o.hasOwnProperty(n)){if(!("channels"in o[n]))throw new Error("missing channels property: "+n);if(!("labels"in o[n]))throw new Error("missing channel labels property: "+n);if(o[n].labels.length!==o[n].channels)throw new Error("channel and label counts mismatch: "+n);var i=o[n].channels,r=o[n].labels;delete o[n].channels,delete o[n].labels,Object.defineProperty(o[n],"channels",{value:i}),Object.defineProperty(o[n],"labels",{value:r})}o.rgb.hsl=function(t){var e,n,i=t[0]/255,r=t[1]/255,a=t[2]/255,o=Math.min(i,r,a),s=Math.max(i,r,a),l=s-o;return s===o?e=0:i===s?e=(r-a)/l:r===s?e=2+(a-i)/l:a===s&&(e=4+(i-r)/l),(e=Math.min(60*e,360))<0&&(e+=360),n=(o+s)/2,[e,100*(s===o?0:n<=.5?l/(s+o):l/(2-s-o)),100*n]},o.rgb.hsv=function(t){function e(t){return(d-t)/6/h+.5}var n,i,r,a,o,s=t[0]/255,l=t[1]/255,u=t[2]/255,d=Math.max(s,l,u),h=d-Math.min(s,l,u);return 0==h?a=o=0:(o=h/d,n=e(s),i=e(l),r=e(u),s===d?a=r-i:l===d?a=1/3+n-r:u===d&&(a=2/3+i-n),a<0?a+=1:1<a&&--a),[360*a,100*o,100*d]},o.rgb.hwb=function(t){var e=t[0],n=t[1],i=t[2];return[o.rgb.hsl(t)[0],100*(1/255*Math.min(e,Math.min(n,i))),100*(i=1-1/255*Math.max(e,Math.max(n,i)))]},o.rgb.cmyk=function(t){var e=t[0]/255,n=t[1]/255,i=t[2]/255,r=Math.min(1-e,1-n,1-i);return[100*((1-e-r)/(1-r)||0),100*((1-n-r)/(1-r)||0),100*((1-i-r)/(1-r)||0),100*r]},o.rgb.keyword=function(t){var e=u[t];if(e)return e;var n,i,r,a,o,s=1/0;for(var l in d){d.hasOwnProperty(l)&&(i=d[l],a=t,o=i,(r=Math.pow(a[0]-o[0],2)+Math.pow(a[1]-o[1],2)+Math.pow(a[2]-o[2],2))<s&&(s=r,n=l))}return n},o.keyword.rgb=function(t){return d[t]},o.rgb.xyz=function(t){var e=t[0]/255,n=t[1]/255,i=t[2]/255;return[100*(.4124*(e=.04045<e?Math.pow((e+.055)/1.055,2.4):e/12.92)+.3576*(n=.04045<n?Math.pow((n+.055)/1.055,2.4):n/12.92)+.1805*(i=.04045<i?Math.pow((i+.055)/1.055,2.4):i/12.92)),100*(.2126*e+.7152*n+.0722*i),100*(.0193*e+.1192*n+.9505*i)]},o.rgb.lab=function(t){var e=o.rgb.xyz(t),n=e[0],i=e[1],r=e[2];return i/=100,r/=108.883,n=.008856<(n/=95.047)?Math.pow(n,1/3):7.787*n+16/116,[116*(i=.008856<i?Math.pow(i,1/3):7.787*i+16/116)-16,500*(n-i),200*(i-(r=.008856<r?Math.pow(r,1/3):7.787*r+16/116))]},o.hsl.rgb=function(t){var e,n,i,r,a,o=t[0]/360,s=t[1]/100,l=t[2]/100;if(0==s)return[a=255*l,a,a];e=2*l-(n=l<.5?l*(1+s):l+s-l*s),r=[0,0,0];for(var u=0;u<3;u++)(i=o+1/3*-(u-1))<0&&i++,1<i&&i--,a=6*i<1?e+6*(n-e)*i:2*i<1?n:3*i<2?e+(n-e)*(2/3-i)*6:e,r[u]=255*a;return r},o.hsl.hsv=function(t){var e=t[0],n=t[1]/100,i=t[2]/100,r=n,a=Math.max(i,.01);return n*=(i*=2)<=1?i:2-i,r*=a<=1?a:2-a,[e,100*(0===i?2*r/(a+r):2*n/(i+n)),100*((i+n)/2)]},o.hsv.rgb=function(t){var e=t[0]/60,n=t[1]/100,i=t[2]/100,r=Math.floor(e)%6,a=e-Math.floor(e),o=255*i*(1-n),s=255*i*(1-n*a),l=255*i*(1-n*(1-a));switch(i*=255,r){case 0:return[i,l,o];case 1:return[s,i,o];case 2:return[o,i,l];case 3:return[o,s,i];case 4:return[l,o,i];case 5:return[i,o,s]}},o.hsv.hsl=function(t){var e=t[0],n=t[1]/100,i=t[2]/100,r=Math.max(i,.01),a=(2-n)*i,o=(2-n)*r,s=n*r;return[e,100*(s=(s/=o<=1?o:2-o)||0),100*(a/=2)]},o.hwb.rgb=function(t){var e,n,i,r,a,o,s,l=t[0]/360,u=t[1]/100,d=t[2]/100,h=u+d;switch(1<h&&(u/=h,d/=h),i=6*l-(e=Math.floor(6*l)),0!=(1&e)&&(i=1-i),r=u+i*((n=1-d)-u),e){default:case 6:case 0:a=n,o=r,s=u;break;case 1:a=r,o=n,s=u;break;case 2:a=u,o=n,s=r;break;case 3:a=u,o=r,s=n;break;case 4:a=r,o=u,s=n;break;case 5:a=n,o=u,s=r}return[255*a,255*o,255*s]},o.cmyk.rgb=function(t){var e=t[0]/100,n=t[1]/100,i=t[2]/100,r=t[3]/100;return[255*(1-Math.min(1,e*(1-r)+r)),255*(1-Math.min(1,n*(1-r)+r)),255*(1-Math.min(1,i*(1-r)+r))]},o.xyz.rgb=function(t){var e=t[0]/100,n=t[1]/100,i=t[2]/100,r=3.2406*e+-1.5372*n+-.4986*i,a=-.9689*e+1.8758*n+.0415*i,o=.0557*e+-.204*n+1.057*i;return r=.0031308<r?1.055*Math.pow(r,1/2.4)-.055:12.92*r,a=.0031308<a?1.055*Math.pow(a,1/2.4)-.055:12.92*a,o=.0031308<o?1.055*Math.pow(o,1/2.4)-.055:12.92*o,[255*(r=Math.min(Math.max(0,r),1)),255*(a=Math.min(Math.max(0,a),1)),255*(o=Math.min(Math.max(0,o),1))]},o.xyz.lab=function(t){var e=t[0],n=t[1],i=t[2];return n/=100,i/=108.883,e=.008856<(e/=95.047)?Math.pow(e,1/3):7.787*e+16/116,[116*(n=.008856<n?Math.pow(n,1/3):7.787*n+16/116)-16,500*(e-n),200*(n-(i=.008856<i?Math.pow(i,1/3):7.787*i+16/116))]},o.lab.xyz=function(t){var e=(t[0]+16)/116,n=t[1]/500+e,i=e-t[2]/200,r=Math.pow(e,3),a=Math.pow(n,3),o=Math.pow(i,3);return e=.008856<r?r:(e-16/116)/7.787,n=.008856<a?a:(n-16/116)/7.787,i=.008856<o?o:(i-16/116)/7.787,[n*=95.047,e*=100,i*=108.883]},o.lab.lch=function(t){var e=t[0],n=t[1],i=t[2],r=360*Math.atan2(i,n)/2/Math.PI;return r<0&&(r+=360),[e,Math.sqrt(n*n+i*i),r]},o.lch.lab=function(t){var e=t[0],n=t[1],i=t[2]/360*2*Math.PI;return[e,n*Math.cos(i),n*Math.sin(i)]},o.rgb.ansi16=function(t){var e=t[0],n=t[1],i=t[2],r=1 in arguments?arguments[1]:o.rgb.hsv(t)[2];if(0===(r=Math.round(r/50)))return 30;var a=30+(Math.round(i/255)<<2|Math.round(n/255)<<1|Math.round(e/255));return 2===r&&(a+=60),a},o.hsv.ansi16=function(t){return o.rgb.ansi16(o.hsv.rgb(t),t[2])},o.rgb.ansi256=function(t){var e=t[0],n=t[1],i=t[2];return e===n&&n===i?e<8?16:248<e?231:Math.round((e-8)/247*24)+232:16+36*Math.round(e/255*5)+6*Math.round(n/255*5)+Math.round(i/255*5)},o.ansi16.rgb=function(t){var e=t%10;if(0===e||7===e)return 50<t&&(e+=3.5),[e=e/10.5*255,e,e];var n=.5*(1+~~(50<t));return[(1&e)*n*255,(e>>1&1)*n*255,(e>>2&1)*n*255]},o.ansi256.rgb=function(t){if(232<=t){var e=10*(t-232)+8;return[e,e,e]}var n;return t-=16,[Math.floor(t/36)/5*255,Math.floor((n=t%36)/6)/5*255,n%6/5*255]},o.rgb.hex=function(t){var e=(((255&Math.round(t[0]))<<16)+((255&Math.round(t[1]))<<8)+(255&Math.round(t[2]))).toString(16).toUpperCase();return"000000".substring(e.length)+e},o.hex.rgb=function(t){var e=t.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);if(!e)return[0,0,0];var n=e[0];3===e[0].length&&(n=n.split("").map(function(t){return t+t}).join(""));var i=parseInt(n,16);return[i>>16&255,i>>8&255,255&i]},o.rgb.hcg=function(t){var e=t[0]/255,n=t[1]/255,i=t[2]/255,r=Math.max(Math.max(e,n),i),a=Math.min(Math.min(e,n),i),o=r-a,s=o<1?a/(1-o):0,l=o<=0?0:r===e?(n-i)/o%6:r===n?2+(i-e)/o:4+(e-n)/o+4;return l/=6,[360*(l%=1),100*o,100*s]},o.hsl.hcg=function(t){var e=t[1]/100,n=t[2]/100,i=1,r=0;return(i=n<.5?2*e*n:2*e*(1-n))<1&&(r=(n-.5*i)/(1-i)),[t[0],100*i,100*r]},o.hsv.hcg=function(t){var e=t[1]/100,n=t[2]/100,i=e*n,r=i<1?(n-i)/(1-i):0;return[t[0],100*i,100*r]},o.hcg.rgb=function(t){var e=t[0]/360,n=t[1]/100,i=t[2]/100;if(0==n)return[255*i,255*i,255*i];var r,a=[0,0,0],o=e%1*6,s=o%1,l=1-s;switch(Math.floor(o)){case 0:a[0]=1,a[1]=s,a[2]=0;break;case 1:a[0]=l,a[1]=1,a[2]=0;break;case 2:a[0]=0,a[1]=1,a[2]=s;break;case 3:a[0]=0,a[1]=l,a[2]=1;break;case 4:a[0]=s,a[1]=0,a[2]=1;break;default:a[0]=1,a[1]=0,a[2]=l}return r=(1-n)*i,[255*(n*a[0]+r),255*(n*a[1]+r),255*(n*a[2]+r)]},o.hcg.hsv=function(t){var e=t[1]/100,n=e+t[2]/100*(1-e),i=0<n?e/n:0;return[t[0],100*i,100*n]},o.hcg.hsl=function(t){var e=t[1]/100,n=t[2]/100*(1-e)+.5*e,i=0;return 0<n&&n<.5?i=e/(2*n):.5<=n&&n<1&&(i=e/(2*(1-n))),[t[0],100*i,100*n]},o.hcg.hwb=function(t){var e=t[1]/100,n=e+t[2]/100*(1-e);return[t[0],100*(n-e),100*(1-n)]},o.hwb.hcg=function(t){var e=t[1]/100,n=1-t[2]/100,i=n-e,r=i<1?(n-i)/(1-i):0;return[t[0],100*i,100*r]},o.apple.rgb=function(t){return[t[0]/65535*255,t[1]/65535*255,t[2]/65535*255]},o.rgb.apple=function(t){return[t[0]/255*65535,t[1]/255*65535,t[2]/255*65535]},o.gray.rgb=function(t){return[t[0]/100*255,t[0]/100*255,t[0]/100*255]},o.gray.hsl=o.gray.hsv=function(t){return[0,0,t[0]]},o.gray.hwb=function(t){return[0,100,t[0]]},o.gray.cmyk=function(t){return[0,0,0,t[0]]},o.gray.lab=function(t){return[t[0],0,0]},o.gray.hex=function(t){var e=255&Math.round(t[0]/100*255),n=((e<<16)+(e<<8)+e).toString(16).toUpperCase();return"000000".substring(n.length)+n},o.rgb.gray=function(t){return[(t[0]+t[1]+t[2])/3/255*100]}});u.rgb,u.hsl,u.hsv,u.hwb,u.cmyk,u.xyz,u.lab,u.lch,u.hex,u.keyword,u.ansi16,u.ansi256,u.hcg,u.apple,u.gray;function s(t){var e=function(){for(var t={},e=Object.keys(u),n=e.length,i=0;i<n;i++)t[e[i]]={distance:-1,parent:null};return t}(),n=[t];for(e[t].distance=0;n.length;)for(var i=n.pop(),r=Object.keys(u[i]),a=r.length,o=0;o<a;o++){var s=r[o],l=e[s];-1===l.distance&&(l.distance=e[i].distance+1,l.parent=i,n.unshift(s))}return e}function l(t,e){for(var n=[e[t].parent,t],i=u[e[t].parent][t],r=e[t].parent;e[r].parent;)n.unshift(e[r].parent),i=function(e,n){return function(t){return n(e(t))}}(u[e[r].parent][r],i),r=e[r].parent;return i.conversion=n,i}var r={};function a(e){function t(t){return null==t?t:(1<arguments.length&&(t=Array.prototype.slice.call(arguments)),e(t))}return"conversion"in e&&(t.conversion=e.conversion),t}function o(r){function t(t){if(null==t)return t;1<arguments.length&&(t=Array.prototype.slice.call(arguments));var e=r(t);if("object"==typeof e)for(var n=e.length,i=0;i<n;i++)e[i]=Math.round(e[i]);return e}return"conversion"in r&&(t.conversion=r.conversion),t}Object.keys(u).forEach(function(n){r[n]={},Object.defineProperty(r[n],"channels",{value:u[n].channels}),Object.defineProperty(r[n],"labels",{value:u[n].labels});var i=function(t){for(var e=s(t),n={},i=Object.keys(e),r=i.length,a=0;a<r;a++){var o=i[a];null!==e[o].parent&&(n[o]=l(o,e))}return n}(n);Object.keys(i).forEach(function(t){var e=i[t];r[n][t]=o(e),r[n][t].raw=a(e)})});var h=r,c={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]},n={getRgba:i,getHsla:f,getRgb:function(t){var e=i(t);return e&&e.slice(0,3)},getHsl:function(t){var e=f(t);return e&&e.slice(0,3)},getHwb:g,getAlpha:function(t){var e=i(t);{if(e)return e[3];if(e=f(t))return e[3];if(e=g(t))return e[3]}},hexString:function(t,e){e=void 0!==e&&3===t.length?e:t[3];return"#"+b(t[0])+b(t[1])+b(t[2])+(0<=e&&e<1?b(Math.round(255*e)):"")},rgbString:function(t,e){if(e<1||t[3]&&t[3]<1)return m(t,e);return"rgb("+t[0]+", "+t[1]+", "+t[2]+")"},rgbaString:m,percentString:function(t,e){if(e<1||t[3]&&t[3]<1)return p(t,e);var n=Math.round(t[0]/255*100),i=Math.round(t[1]/255*100),r=Math.round(t[2]/255*100);return"rgb("+n+"%, "+i+"%, "+r+"%)"},percentaString:p,hslString:function(t,e){if(e<1||t[3]&&t[3]<1)return v(t,e);return"hsl("+t[0]+", "+t[1]+"%, "+t[2]+"%)"},hslaString:v,hwbString:function(t,e){void 0===e&&(e=void 0!==t[3]?t[3]:1);return"hwb("+t[0]+", "+t[1]+"%, "+t[2]+"%"+(void 0!==e&&1!==e?", "+e:"")+")"},keyword:function(t){return e[t.slice(0,3)]}};function i(t){if(t){var e=[0,0,0],n=1,i=t.match(/^#([a-fA-F0-9]{3,4})$/i),r="";if(i){r=(i=i[1])[3];for(var a=0;a<e.length;a++)e[a]=parseInt(i[a]+i[a],16);r&&(n=Math.round(parseInt(r+r,16)/255*100)/100)}else if(i=t.match(/^#([a-fA-F0-9]{6}([a-fA-F0-9]{2})?)$/i)){r=i[2],i=i[1];for(a=0;a<e.length;a++)e[a]=parseInt(i.slice(2*a,2*a+2),16);r&&(n=Math.round(parseInt(r,16)/255*100)/100)}else if(i=t.match(/^rgba?\(\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/i)){for(a=0;a<e.length;a++)e[a]=parseInt(i[a+1]);n=parseFloat(i[4])}else if(i=t.match(/^rgba?\(\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/i)){for(a=0;a<e.length;a++)e[a]=Math.round(2.55*parseFloat(i[a+1]));n=parseFloat(i[4])}else if(i=t.match(/(\w+)/)){if("transparent"==i[1])return[0,0,0,0];if(!(e=c[i[1]]))return}for(a=0;a<e.length;a++)e[a]=y(e[a],0,255);return n=n||0==n?y(n,0,1):1,e[3]=n,e}}function f(t){if(t){var e=t.match(/^hsla?\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/);if(e){var n=parseFloat(e[4]);return[y(parseInt(e[1]),0,360),y(parseFloat(e[2]),0,100),y(parseFloat(e[3]),0,100),y(isNaN(n)?1:n,0,1)]}}}function g(t){if(t){var e=t.match(/^hwb\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/);if(e){var n=parseFloat(e[4]);return[y(parseInt(e[1]),0,360),y(parseFloat(e[2]),0,100),y(parseFloat(e[3]),0,100),y(isNaN(n)?1:n,0,1)]}}}function m(t,e){return void 0===e&&(e=void 0!==t[3]?t[3]:1),"rgba("+t[0]+", "+t[1]+", "+t[2]+", "+e+")"}function p(t,e){return"rgba("+Math.round(t[0]/255*100)+"%, "+Math.round(t[1]/255*100)+"%, "+Math.round(t[2]/255*100)+"%, "+(e||t[3]||1)+")"}function v(t,e){return void 0===e&&(e=void 0!==t[3]?t[3]:1),"hsla("+t[0]+", "+t[1]+"%, "+t[2]+"%, "+e+")"}function y(t,e,n){return Math.min(Math.max(e,t),n)}function b(t){var e=t.toString(16).toUpperCase();return e.length<2?"0"+e:e}var e={};for(var x in c)e[c[x]]=x;var _=function(t){return t instanceof _?t:this instanceof _?(this.valid=!1,this.values={rgb:[0,0,0],hsl:[0,0,0],hsv:[0,0,0],hwb:[0,0,0],cmyk:[0,0,0,0],alpha:1},void("string"==typeof t?(e=n.getRgba(t))?this.setValues("rgb",e):(e=n.getHsla(t))?this.setValues("hsl",e):(e=n.getHwb(t))&&this.setValues("hwb",e):"object"==typeof t&&(void 0!==(e=t).r||void 0!==e.red?this.setValues("rgb",e):void 0!==e.l||void 0!==e.lightness?this.setValues("hsl",e):void 0!==e.v||void 0!==e.value?this.setValues("hsv",e):void 0!==e.w||void 0!==e.whiteness?this.setValues("hwb",e):void 0===e.c&&void 0===e.cyan||this.setValues("cmyk",e)))):new _(t);var e};_.prototype={isValid:function(){return this.valid},rgb:function(){return this.setSpace("rgb",arguments)},hsl:function(){return this.setSpace("hsl",arguments)},hsv:function(){return this.setSpace("hsv",arguments)},hwb:function(){return this.setSpace("hwb",arguments)},cmyk:function(){return this.setSpace("cmyk",arguments)},rgbArray:function(){return this.values.rgb},hslArray:function(){return this.values.hsl},hsvArray:function(){return this.values.hsv},hwbArray:function(){var t=this.values;return 1!==t.alpha?t.hwb.concat([t.alpha]):t.hwb},cmykArray:function(){return this.values.cmyk},rgbaArray:function(){var t=this.values;return t.rgb.concat([t.alpha])},hslaArray:function(){var t=this.values;return t.hsl.concat([t.alpha])},alpha:function(t){return void 0===t?this.values.alpha:(this.setValues("alpha",t),this)},red:function(t){return this.setChannel("rgb",0,t)},green:function(t){return this.setChannel("rgb",1,t)},blue:function(t){return this.setChannel("rgb",2,t)},hue:function(t){return t=t&&((t%=360)<0?360+t:t),this.setChannel("hsl",0,t)},saturation:function(t){return this.setChannel("hsl",1,t)},lightness:function(t){return this.setChannel("hsl",2,t)},saturationv:function(t){return this.setChannel("hsv",1,t)},whiteness:function(t){return this.setChannel("hwb",1,t)},blackness:function(t){return this.setChannel("hwb",2,t)},value:function(t){return this.setChannel("hsv",2,t)},cyan:function(t){return this.setChannel("cmyk",0,t)},magenta:function(t){return this.setChannel("cmyk",1,t)},yellow:function(t){return this.setChannel("cmyk",2,t)},black:function(t){return this.setChannel("cmyk",3,t)},hexString:function(){return n.hexString(this.values.rgb)},rgbString:function(){return n.rgbString(this.values.rgb,this.values.alpha)},rgbaString:function(){return n.rgbaString(this.values.rgb,this.values.alpha)},percentString:function(){return n.percentString(this.values.rgb,this.values.alpha)},hslString:function(){return n.hslString(this.values.hsl,this.values.alpha)},hslaString:function(){return n.hslaString(this.values.hsl,this.values.alpha)},hwbString:function(){return n.hwbString(this.values.hwb,this.values.alpha)},keyword:function(){return n.keyword(this.values.rgb,this.values.alpha)},rgbNumber:function(){var t=this.values.rgb;return t[0]<<16|t[1]<<8|t[2]},luminosity:function(){for(var t=this.values.rgb,e=[],n=0;n<t.length;n++){var i=t[n]/255;e[n]=i<=.03928?i/12.92:Math.pow((.055+i)/1.055,2.4)}return.2126*e[0]+.7152*e[1]+.0722*e[2]},contrast:function(t){var e=this.luminosity(),n=t.luminosity();return n<e?(e+.05)/(n+.05):(n+.05)/(e+.05)},level:function(t){var e=this.contrast(t);return 7.1<=e?"AAA":4.5<=e?"AA":""},dark:function(){var t=this.values.rgb;return(299*t[0]+587*t[1]+114*t[2])/1e3<128},light:function(){return!this.dark()},negate:function(){for(var t=[],e=0;e<3;e++)t[e]=255-this.values.rgb[e];return this.setValues("rgb",t),this},lighten:function(t){var e=this.values.hsl;return e[2]+=e[2]*t,this.setValues("hsl",e),this},darken:function(t){var e=this.values.hsl;return e[2]-=e[2]*t,this.setValues("hsl",e),this},saturate:function(t){var e=this.values.hsl;return e[1]+=e[1]*t,this.setValues("hsl",e),this},desaturate:function(t){var e=this.values.hsl;return e[1]-=e[1]*t,this.setValues("hsl",e),this},whiten:function(t){var e=this.values.hwb;return e[1]+=e[1]*t,this.setValues("hwb",e),this},blacken:function(t){var e=this.values.hwb;return e[2]+=e[2]*t,this.setValues("hwb",e),this},greyscale:function(){var t=this.values.rgb,e=.3*t[0]+.59*t[1]+.11*t[2];return this.setValues("rgb",[e,e,e]),this},clearer:function(t){var e=this.values.alpha;return this.setValues("alpha",e-e*t),this},opaquer:function(t){var e=this.values.alpha;return this.setValues("alpha",e+e*t),this},rotate:function(t){var e=this.values.hsl,n=(e[0]+t)%360;return e[0]=n<0?360+n:n,this.setValues("hsl",e),this},mix:function(t,e){var n=this,i=t,r=void 0===e?.5:e,a=2*r-1,o=n.alpha()-i.alpha(),s=(1+(a*o==-1?a:(a+o)/(1+a*o)))/2,l=1-s;return this.rgb(s*n.red()+l*i.red(),s*n.green()+l*i.green(),s*n.blue()+l*i.blue()).alpha(n.alpha()*r+i.alpha()*(1-r))},toJSON:function(){return this.rgb()},clone:function(){var t,e,n=new _,i=this.values,r=n.values;for(var a in i)i.hasOwnProperty(a)&&(t=i[a],"[object Array]"===(e={}.toString.call(t))?r[a]=t.slice(0):"[object Number]"===e?r[a]=t:console.error("unexpected color value:",t));return n}},_.prototype.spaces={rgb:["red","green","blue"],hsl:["hue","saturation","lightness"],hsv:["hue","saturation","value"],hwb:["hue","whiteness","blackness"],cmyk:["cyan","magenta","yellow","black"]},_.prototype.maxes={rgb:[255,255,255],hsl:[360,100,100],hsv:[360,100,100],hwb:[360,100,100],cmyk:[100,100,100,100]},_.prototype.getValues=function(t){for(var e=this.values,n={},i=0;i<t.length;i++)n[t.charAt(i)]=e[t][i];return 1!==e.alpha&&(n.a=e.alpha),n},_.prototype.setValues=function(t,e){var n,i=this.values,r=this.spaces,a=this.maxes,o=1;if(this.valid=!0,"alpha"===t)o=e;else if(e.length)i[t]=e.slice(0,t.length),o=e[t.length];else if(void 0!==e[t.charAt(0)]){for(l=0;l<t.length;l++)i[t][l]=e[t.charAt(l)];o=e.a}else if(void 0!==e[r[t][0]]){for(var s=r[t],l=0;l<t.length;l++)i[t][l]=e[s[l]];o=e.alpha}if(i.alpha=Math.max(0,Math.min(1,void 0===o?i.alpha:o)),"alpha"===t)return!1;for(l=0;l<t.length;l++)n=Math.max(0,Math.min(a[t][l],i[t][l])),i[t][l]=Math.round(n);for(var u in r)u!==t&&(i[u]=h[t][u](i[t]));return!0},_.prototype.setSpace=function(t,e){var n=e[0];return void 0===n?this.getValues(t):("number"==typeof n&&(n=Array.prototype.slice.call(e)),this.setValues(t,n),this)},_.prototype.setChannel=function(t,e,n){var i=this.values[t];return void 0===n?i[e]:(n===i[e]||(i[e]=n,this.setValues(t,i)),this)},"undefined"!=typeof window&&(window.Chart=window.Chart||{},window.Chart.Color=_,void 0===window.Color&&(window.Color=_));var w=_;function k(t){return-1===["__proto__","prototype","constructor"].indexOf(t)}var M,S={noop:function(){},uid:(M=0,function(){return M++}),isNullOrUndef:function(t){return null==t},isArray:function(t){if(Array.isArray&&Array.isArray(t))return!0;var e=Object.prototype.toString.call(t);return"[object"===e.substr(0,7)&&"Array]"===e.substr(-6)},isObject:function(t){return null!==t&&"[object Object]"===Object.prototype.toString.call(t)},isFinite:function(t){return("number"==typeof t||t instanceof Number)&&isFinite(t)},valueOrDefault:function(t,e){return void 0===t?e:t},valueAtIndexOrDefault:function(t,e,n){return S.valueOrDefault(S.isArray(t)?t[e]:t,n)},callback:function(t,e,n){if(t&&"function"==typeof t.call)return t.apply(n,e)},each:function(t,e,n,i){var r,a,o;if(S.isArray(t))if(a=t.length,i)for(r=a-1;0<=r;r--)e.call(n,t[r],r);else for(r=0;r<a;r++)e.call(n,t[r],r);else if(S.isObject(t))for(a=(o=Object.keys(t)).length,r=0;r<a;r++)e.call(n,t[o[r]],o[r])},arrayEquals:function(t,e){var n,i,r,a;if(!t||!e||t.length!==e.length)return!1;for(n=0,i=t.length;n<i;++n)if(r=t[n],a=e[n],r instanceof Array&&a instanceof Array){if(!S.arrayEquals(r,a))return!1}else if(r!==a)return!1;return!0},clone:function(t){if(S.isArray(t))return t.map(S.clone);if(S.isObject(t)){for(var e=Object.create(t),n=Object.keys(t),i=n.length,r=0;r<i;++r)e[n[r]]=S.clone(t[n[r]]);return e}return t},_merger:function(t,e,n,i){var r,a;k(t)&&(r=e[t],a=n[t],S.isObject(r)&&S.isObject(a)?S.merge(r,a,i):e[t]=S.clone(a))},_mergerIf:function(t,e,n){var i,r;k(t)&&(i=e[t],r=n[t],S.isObject(i)&&S.isObject(r)?S.mergeIf(i,r):e.hasOwnProperty(t)||(e[t]=S.clone(r)))},merge:function(t,e,n){var i,r,a,o,s,l=S.isArray(e)?e:[e],u=l.length;if(!S.isObject(t))return t;for(i=(n=n||{}).merger||S._merger,r=0;r<u;++r)if(e=l[r],S.isObject(e))for(s=0,o=(a=Object.keys(e)).length;s<o;++s)i(a[s],t,e,n);return t},mergeIf:function(t,e){return S.merge(t,e,{merger:S._mergerIf})},extend:Object.assign||function(t){return S.merge(t,[].slice.call(arguments,1),{merger:function(t,e,n){e[t]=n[t]}})},inherits:function(t){function e(){this.constructor=i}var n=this,i=t&&t.hasOwnProperty("constructor")?t.constructor:function(){return n.apply(this,arguments)};return e.prototype=n.prototype,i.prototype=new e,i.extend=S.inherits,t&&S.extend(i.prototype,t),i.__super__=n.prototype,i},_deprecated:function(t,e,n,i){void 0!==e&&console.warn(t+': "'+n+'" is deprecated. Please use "'+i+'" instead')}},D=S;S.callCallback=S.callback,S.indexOf=function(t,e,n){return Array.prototype.indexOf.call(t,e,n)},S.getValueOrDefault=S.valueOrDefault,S.getValueAtIndexOrDefault=S.valueAtIndexOrDefault;var C={linear:function(t){return t},easeInQuad:function(t){return t*t},easeOutQuad:function(t){return-t*(t-2)},easeInOutQuad:function(t){return(t/=.5)<1?.5*t*t:-.5*(--t*(t-2)-1)},easeInCubic:function(t){return t*t*t},easeOutCubic:function(t){return--t*t*t+1},easeInOutCubic:function(t){return(t/=.5)<1?.5*t*t*t:.5*((t-=2)*t*t+2)},easeInQuart:function(t){return t*t*t*t},easeOutQuart:function(t){return-(--t*t*t*t-1)},easeInOutQuart:function(t){return(t/=.5)<1?.5*t*t*t*t:-.5*((t-=2)*t*t*t-2)},easeInQuint:function(t){return t*t*t*t*t},easeOutQuint:function(t){return--t*t*t*t*t+1},easeInOutQuint:function(t){return(t/=.5)<1?.5*t*t*t*t*t:.5*((t-=2)*t*t*t*t+2)},easeInSine:function(t){return 1-Math.cos(t*(Math.PI/2))},easeOutSine:function(t){return Math.sin(t*(Math.PI/2))},easeInOutSine:function(t){return-.5*(Math.cos(Math.PI*t)-1)},easeInExpo:function(t){return 0===t?0:Math.pow(2,10*(t-1))},easeOutExpo:function(t){return 1===t?1:1-Math.pow(2,-10*t)},easeInOutExpo:function(t){return 0===t?0:1===t?1:(t/=.5)<1?.5*Math.pow(2,10*(t-1)):.5*(2-Math.pow(2,-10*--t))},easeInCirc:function(t){return 1<=t?t:-(Math.sqrt(1-t*t)-1)},easeOutCirc:function(t){return Math.sqrt(1- --t*t)},easeInOutCirc:function(t){return(t/=.5)<1?-.5*(Math.sqrt(1-t*t)-1):.5*(Math.sqrt(1-(t-=2)*t)+1)},easeInElastic:function(t){var e=1.70158,n=0,i=1;return 0===t?0:1===t?1:(n=n||.3,e=i<1?(i=1,n/4):n/(2*Math.PI)*Math.asin(1/i),-(i*Math.pow(2,10*--t)*Math.sin((t-e)*(2*Math.PI)/n)))},easeOutElastic:function(t){var e=1.70158,n=0,i=1;return 0===t?0:1===t?1:(n=n||.3,e=i<1?(i=1,n/4):n/(2*Math.PI)*Math.asin(1/i),i*Math.pow(2,-10*t)*Math.sin((t-e)*(2*Math.PI)/n)+1)},easeInOutElastic:function(t){var e=1.70158,n=0,i=1;return 0===t?0:2==(t/=.5)?1:(n=n||.45,e=i<1?(i=1,n/4):n/(2*Math.PI)*Math.asin(1/i),t<1?i*Math.pow(2,10*--t)*Math.sin((t-e)*(2*Math.PI)/n)*-.5:i*Math.pow(2,-10*--t)*Math.sin((t-e)*(2*Math.PI)/n)*.5+1)},easeInBack:function(t){return t*t*(2.70158*t-1.70158)},easeOutBack:function(t){return--t*t*(2.70158*t+1.70158)+1},easeInOutBack:function(t){var e=1.70158;return(t/=.5)<1?t*t*((1+(e*=1.525))*t-e)*.5:.5*((t-=2)*t*((1+(e*=1.525))*t+e)+2)},easeInBounce:function(t){return 1-C.easeOutBounce(1-t)},easeOutBounce:function(t){return t<1/2.75?7.5625*t*t:t<2/2.75?7.5625*(t-=1.5/2.75)*t+.75:t<2.5/2.75?7.5625*(t-=2.25/2.75)*t+.9375:7.5625*(t-=2.625/2.75)*t+.984375},easeInOutBounce:function(t){return t<.5?.5*C.easeInBounce(2*t):.5*C.easeOutBounce(2*t-1)+.5}},P={effects:C};D.easingEffects=C;var T=Math.PI,O=T/180,A=2*T,F=T/2,I=T/4,L=2*T/3,R={clear:function(t){t.ctx.clearRect(0,0,t.width,t.height)},roundedRect:function(t,e,n,i,r,a){var o,s,l,u,d;a?(s=e+(o=Math.min(a,r/2,i/2)),l=n+o,u=e+i-o,d=n+r-o,t.moveTo(e,l),s<u&&l<d?(t.arc(s,l,o,-T,-F),t.arc(u,l,o,-F,0),t.arc(u,d,o,0,F),t.arc(s,d,o,F,T)):s<u?(t.moveTo(s,n),t.arc(u,l,o,-F,F),t.arc(s,l,o,F,T+F)):l<d?(t.arc(s,l,o,-T,0),t.arc(s,d,o,0,T)):t.arc(s,l,o,-T,T),t.closePath(),t.moveTo(e,n)):t.rect(e,n,i,r)},drawPoint:function(t,e,n,i,r,a){var o,s,l,u,d,h=(a||0)*O;if(e&&"object"==typeof e&&("[object HTMLImageElement]"===(o=e.toString())||"[object HTMLCanvasElement]"===o))return t.save(),t.translate(i,r),t.rotate(h),t.drawImage(e,-e.width/2,-e.height/2,e.width,e.height),void t.restore();if(!(isNaN(n)||n<=0)){switch(t.beginPath(),e){default:t.arc(i,r,n,0,A),t.closePath();break;case"triangle":t.moveTo(i+Math.sin(h)*n,r-Math.cos(h)*n),h+=L,t.lineTo(i+Math.sin(h)*n,r-Math.cos(h)*n),h+=L,t.lineTo(i+Math.sin(h)*n,r-Math.cos(h)*n),t.closePath();break;case"rectRounded":u=n-(d=.516*n),s=Math.cos(h+I)*u,l=Math.sin(h+I)*u,t.arc(i-s,r-l,d,h-T,h-F),t.arc(i+l,r-s,d,h-F,h),t.arc(i+s,r+l,d,h,h+F),t.arc(i-l,r+s,d,h+F,h+T),t.closePath();break;case"rect":if(!a){u=Math.SQRT1_2*n,t.rect(i-u,r-u,2*u,2*u);break}h+=I;case"rectRot":s=Math.cos(h)*n,l=Math.sin(h)*n,t.moveTo(i-s,r-l),t.lineTo(i+l,r-s),t.lineTo(i+s,r+l),t.lineTo(i-l,r+s),t.closePath();break;case"crossRot":h+=I;case"cross":s=Math.cos(h)*n,l=Math.sin(h)*n,t.moveTo(i-s,r-l),t.lineTo(i+s,r+l),t.moveTo(i+l,r-s),t.lineTo(i-l,r+s);break;case"star":s=Math.cos(h)*n,l=Math.sin(h)*n,t.moveTo(i-s,r-l),t.lineTo(i+s,r+l),t.moveTo(i+l,r-s),t.lineTo(i-l,r+s),h+=I,s=Math.cos(h)*n,l=Math.sin(h)*n,t.moveTo(i-s,r-l),t.lineTo(i+s,r+l),t.moveTo(i+l,r-s),t.lineTo(i-l,r+s);break;case"line":s=Math.cos(h)*n,l=Math.sin(h)*n,t.moveTo(i-s,r-l),t.lineTo(i+s,r+l);break;case"dash":t.moveTo(i,r),t.lineTo(i+Math.cos(h)*n,r+Math.sin(h)*n)}t.fill(),t.stroke()}},_isPointInArea:function(t,e){return t.x>e.left-1e-6&&t.x<e.right+1e-6&&t.y>e.top-1e-6&&t.y<e.bottom+1e-6},clipArea:function(t,e){t.save(),t.beginPath(),t.rect(e.left,e.top,e.right-e.left,e.bottom-e.top),t.clip()},unclipArea:function(t){t.restore()},lineTo:function(t,e,n,i){var r,a=n.steppedLine;if(a)return"middle"===a?(r=(e.x+n.x)/2,t.lineTo(r,i?n.y:e.y),t.lineTo(r,i?e.y:n.y)):"after"===a&&!i||"after"!==a&&i?t.lineTo(e.x,n.y):t.lineTo(n.x,e.y),void t.lineTo(n.x,n.y);n.tension?t.bezierCurveTo(i?e.controlPointPreviousX:e.controlPointNextX,i?e.controlPointPreviousY:e.controlPointNextY,i?n.controlPointNextX:n.controlPointPreviousX,i?n.controlPointNextY:n.controlPointPreviousY,n.x,n.y):t.lineTo(n.x,n.y)}},N=R;D.clear=R.clear,D.drawRoundedRectangle=function(t){t.beginPath(),R.roundedRect.apply(R,arguments)};var W={_set:function(t,e){return D.merge(this[t]||(this[t]={}),e)}};W._set("global",{defaultColor:"rgba(0,0,0,0.1)",defaultFontColor:"#666",defaultFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",defaultFontSize:12,defaultFontStyle:"normal",defaultLineHeight:1.2,showLines:!0});var Y=W,z=D.valueOrDefault;var V={toLineHeight:function(t,e){var n=(""+t).match(/^(normal|(\d+(?:\.\d+)?)(px|em|%)?)$/);if(!n||"normal"===n[1])return 1.2*e;switch(t=+n[2],n[3]){case"px":return t;case"%":t/=100}return e*t},toPadding:function(t){var e,n,i,r;return D.isObject(t)?(e=+t.top||0,n=+t.right||0,i=+t.bottom||0,r=+t.left||0):e=n=i=r=+t||0,{top:e,right:n,bottom:i,left:r,height:e+i,width:r+n}},_parseFont:function(t){var e,n=Y.global,i=z(t.fontSize,n.defaultFontSize),r={family:z(t.fontFamily,n.defaultFontFamily),lineHeight:D.options.toLineHeight(z(t.lineHeight,n.defaultLineHeight),i),size:i,style:z(t.fontStyle,n.defaultFontStyle),weight:null,string:""};return r.string=!(e=r)||D.isNullOrUndef(e.size)||D.isNullOrUndef(e.family)?null:(e.style?e.style+" ":"")+(e.weight?e.weight+" ":"")+e.size+"px "+e.family,r},resolve:function(t,e,n,i){for(var r,a=!0,o=0,s=t.length;o<s;++o)if(void 0!==(r=t[o])&&(void 0!==e&&"function"==typeof r&&(r=r(e),a=!1),void 0!==n&&D.isArray(r)&&(r=r[n],a=!1),void 0!==r))return i&&!a&&(i.cacheable=!1),r}},E={_factorize:function(t){for(var e=[],n=Math.sqrt(t),i=1;i<n;i++)t%i==0&&(e.push(i),e.push(t/i));return n===(0|n)&&e.push(n),e.sort(function(t,e){return t-e}).pop(),e},log10:Math.log10||function(t){var e=Math.log(t)*Math.LOG10E,n=Math.round(e);return t===Math.pow(10,n)?n:e}},H=E;D.log10=E.log10;var B=D,j=N,U=V,G=H,q={getRtlAdapter:function(t,e,n){return t?(i=e,r=n,{x:function(t){return i+i+r-t},setWidth:function(t){r=t},textAlign:function(t){return"center"===t?t:"right"===t?"left":"right"},xPlus:function(t,e){return t-e},leftForLtr:function(t,e){return t-e}}):{x:function(t){return t},setWidth:function(t){},textAlign:function(t){return t},xPlus:function(t,e){return t+e},leftForLtr:function(t,e){return t}};var i,r},overrideTextDirection:function(t,e){var n,i;"ltr"!==e&&"rtl"!==e||(i=[(n=t.canvas.style).getPropertyValue("direction"),n.getPropertyPriority("direction")],n.setProperty("direction",e,"important"),t.prevTextDirection=i)},restoreTextDirection:function(t){var e=t.prevTextDirection;void 0!==e&&(delete t.prevTextDirection,t.canvas.style.setProperty("direction",e[0],e[1]))}};B.easing=P,B.canvas=j,B.options=U,B.math=G,B.rtl=q;function Z(t){B.extend(this,t),this.initialize.apply(this,arguments)}B.extend(Z.prototype,{_type:void 0,initialize:function(){this.hidden=!1},pivot:function(){var t=this;return t._view||(t._view=B.extend({},t._model)),t._start={},t},transition:function(t){var e=this,n=e._model,i=e._start,r=e._view;return n&&1!==t?(r=r||(e._view={}),function(t,e,n,i){for(var r,a,o,s,l,u,d,h=Object.keys(n),c=0,f=h.length;c<f;++c)if(s=n[r=h[c]],e.hasOwnProperty(r)||(e[r]=s),(a=e[r])!==s&&"_"!==r[0]){if(t.hasOwnProperty(r)||(t[r]=a),(l=typeof s)==typeof(o=t[r]))if("string"==l){if((u=w(o)).valid&&(d=w(s)).valid){e[r]=d.mix(u,i).rgbString();continue}}else if(B.isFinite(o)&&B.isFinite(s)){e[r]=o+(s-o)*i;continue}e[r]=s}}(i=i||(e._start={}),r,n,t)):(e._view=B.extend({},n),e._start=null),e},tooltipPosition:function(){return{x:this._model.x,y:this._model.y}},hasValue:function(){return B.isNumber(this._model.x)&&B.isNumber(this._model.y)}}),Z.extend=B.inherits;var $=Z,X=$.extend({chart:null,currentStep:0,numSteps:60,easing:"",render:null,onAnimationProgress:null,onAnimationComplete:null}),K=X;Object.defineProperty(X.prototype,"animationObject",{get:function(){return this}}),Object.defineProperty(X.prototype,"chartInstance",{get:function(){return this.chart},set:function(t){this.chart=t}}),Y._set("global",{animation:{duration:1e3,easing:"easeOutQuart",onProgress:B.noop,onComplete:B.noop}});var J={animations:[],request:null,addAnimation:function(t,e,n,i){var r,a,o=this.animations;for(e.chart=t,e.startTime=Date.now(),e.duration=n,i||(t.animating=!0),r=0,a=o.length;r<a;++r)if(o[r].chart===t)return void(o[r]=e);o.push(e),1===o.length&&this.requestAnimationFrame()},cancelAnimation:function(e){var t=B.findIndex(this.animations,function(t){return t.chart===e});-1!==t&&(this.animations.splice(t,1),e.animating=!1)},requestAnimationFrame:function(){var t=this;null===t.request&&(t.request=B.requestAnimFrame.call(window,function(){t.request=null,t.startDigest()}))},startDigest:function(){this.advance(),0<this.animations.length&&this.requestAnimationFrame()},advance:function(){for(var t,e,n,i,r=this.animations,a=0;a<r.length;)e=(t=r[a]).chart,n=t.numSteps,i=Math.floor((Date.now()-t.startTime)/t.duration*n)+1,t.currentStep=Math.min(i,n),B.callback(t.render,[e,t],e),B.callback(t.onAnimationProgress,[t],e),t.currentStep>=n?(B.callback(t.onAnimationComplete,[t],e),e.animating=!1,r.splice(a,1)):++a}},Q=B.options.resolve,tt=["push","pop","shift","splice","unshift"];function et(e,t){var n,i,r=e._chartjs;r&&(-1!==(i=(n=r.listeners).indexOf(t))&&n.splice(i,1),0<n.length||(tt.forEach(function(t){delete e[t]}),delete e._chartjs))}function nt(t,e){this.initialize(t,e)}B.extend(nt.prototype,{datasetElementType:null,dataElementType:null,_datasetElementOptions:["backgroundColor","borderCapStyle","borderColor","borderDash","borderDashOffset","borderJoinStyle","borderWidth"],_dataElementOptions:["backgroundColor","borderColor","borderWidth","pointStyle"],initialize:function(t,e){var n=this;n.chart=t,n.index=e,n.linkScales(),n.addElements(),n._type=n.getMeta().type},updateIndex:function(t){this.index=t},linkScales:function(){var t=this.getMeta(),e=this.chart,n=e.scales,i=this.getDataset(),r=e.options.scales;null!==t.xAxisID&&t.xAxisID in n&&!i.xAxisID||(t.xAxisID=i.xAxisID||r.xAxes[0].id),null!==t.yAxisID&&t.yAxisID in n&&!i.yAxisID||(t.yAxisID=i.yAxisID||r.yAxes[0].id)},getDataset:function(){return this.chart.data.datasets[this.index]},getMeta:function(){return this.chart.getDatasetMeta(this.index)},getScaleForId:function(t){return this.chart.scales[t]},_getValueScaleId:function(){return this.getMeta().yAxisID},_getIndexScaleId:function(){return this.getMeta().xAxisID},_getValueScale:function(){return this.getScaleForId(this._getValueScaleId())},_getIndexScale:function(){return this.getScaleForId(this._getIndexScaleId())},reset:function(){this._update(!0)},destroy:function(){this._data&&et(this._data,this)},createMetaDataset:function(){var t=this.datasetElementType;return t&&new t({_chart:this.chart,_datasetIndex:this.index})},createMetaData:function(t){var e=this.dataElementType;return e&&new e({_chart:this.chart,_datasetIndex:this.index,_index:t})},addElements:function(){for(var t=this.getMeta(),e=this.getDataset().data||[],n=t.data,i=0,r=e.length;i<r;++i)n[i]=n[i]||this.createMetaData(i);t.dataset=t.dataset||this.createMetaDataset()},addElementAndReset:function(t){var e=this.createMetaData(t);this.getMeta().data.splice(t,0,e),this.updateElement(e,t,!0)},buildOrUpdateElements:function(){var r,t,e=this,n=e.getDataset(),i=n.data||(n.data=[]);e._data!==i&&(e._data&&et(e._data,e),i&&Object.isExtensible(i)&&(t=e,(r=i)._chartjs?r._chartjs.listeners.push(t):(Object.defineProperty(r,"_chartjs",{configurable:!0,enumerable:!1,value:{listeners:[t]}}),tt.forEach(function(t){var n="onData"+t.charAt(0).toUpperCase()+t.slice(1),i=r[t];Object.defineProperty(r,t,{configurable:!0,enumerable:!1,value:function(){var e=Array.prototype.slice.call(arguments),t=i.apply(this,e);return B.each(r._chartjs.listeners,function(t){"function"==typeof t[n]&&t[n].apply(t,e)}),t}})}))),e._data=i),e.resyncElements()},_configure:function(){this._config=B.merge(Object.create(null),[this.chart.options.datasets[this._type],this.getDataset()],{merger:function(t,e,n){"_meta"!==t&&"data"!==t&&B._merger(t,e,n)}})},_update:function(t){this._configure(),this._cachedDataOpts=null,this.update(t)},update:B.noop,transition:function(t){for(var e=this.getMeta(),n=e.data||[],i=n.length,r=0;r<i;++r)n[r].transition(t);e.dataset&&e.dataset.transition(t)},draw:function(){var t=this.getMeta(),e=t.data||[],n=e.length,i=0;for(t.dataset&&t.dataset.draw();i<n;++i)e[i].draw()},getStyle:function(t){var e,n=this.getMeta(),i=n.dataset;return this._configure(),!1!==(e=i&&void 0===t?this._resolveDatasetElementOptions(i||{}):(t=t||0,this._resolveDataElementOptions(n.data[t]||{},t))).fill&&null!==e.fill||(e.backgroundColor=e.borderColor),e},_resolveDatasetElementOptions:function(t,e){for(var n,i,r=this,a=r.chart,o=r._config,s=t.custom||{},l=a.options.elements[r.datasetElementType.prototype._type]||{},u=r._datasetElementOptions,d={},h={chart:a,dataset:r.getDataset(),datasetIndex:r.index,hover:e},c=0,f=u.length;c<f;++c)n=u[c],i=e?"hover"+n.charAt(0).toUpperCase()+n.slice(1):n,d[n]=Q([s[i],o[i],l[i]],h);return d},_resolveDataElementOptions:function(t,e){var n=this,i=t&&t.custom,r=n._cachedDataOpts;if(r&&!i)return r;var a,o,s,l,u=n.chart,d=n._config,h=u.options.elements[n.dataElementType.prototype._type]||{},c=n._dataElementOptions,f={},g={chart:u,dataIndex:e,dataset:n.getDataset(),datasetIndex:n.index},m={cacheable:!i},i=i||{};if(B.isArray(c))for(o=0,s=c.length;o<s;++o)f[l=c[o]]=Q([i[l],d[l],h[l]],g,e,m);else for(o=0,s=(a=Object.keys(c)).length;o<s;++o)f[l=a[o]]=Q([i[l],d[c[l]],d[l],h[l]],g,e,m);return m.cacheable&&(n._cachedDataOpts=Object.freeze(f)),f},removeHoverStyle:function(t){B.merge(t._model,t.$previousStyle||{}),delete t.$previousStyle},setHoverStyle:function(t){var e=this.chart.data.datasets[t._datasetIndex],n=t._index,i=t.custom||{},r=t._model,a=B.getHoverColor;t.$previousStyle={backgroundColor:r.backgroundColor,borderColor:r.borderColor,borderWidth:r.borderWidth},r.backgroundColor=Q([i.hoverBackgroundColor,e.hoverBackgroundColor,a(r.backgroundColor)],void 0,n),r.borderColor=Q([i.hoverBorderColor,e.hoverBorderColor,a(r.borderColor)],void 0,n),r.borderWidth=Q([i.hoverBorderWidth,e.hoverBorderWidth,r.borderWidth],void 0,n)},_removeDatasetHoverStyle:function(){var t=this.getMeta().dataset;t&&this.removeHoverStyle(t)},_setDatasetHoverStyle:function(){var t,e,n,i,r,a,o=this.getMeta().dataset,s={};if(o){for(a=o._model,r=this._resolveDatasetElementOptions(o,!0),t=0,e=(i=Object.keys(r)).length;t<e;++t)s[n=i[t]]=a[n],a[n]=r[n];o.$previousStyle=s}},resyncElements:function(){var t=this.getMeta(),e=this.getDataset().data,n=t.data.length,i=e.length;i<n?t.data.splice(i,n-i):n<i&&this.insertElements(n,i-n)},insertElements:function(t,e){for(var n=0;n<e;++n)this.addElementAndReset(t+n)},onDataPush:function(){var t=arguments.length;this.insertElements(this.getDataset().data.length-t,t)},onDataPop:function(){this.getMeta().data.pop()},onDataShift:function(){this.getMeta().data.shift()},onDataSplice:function(t,e){this.getMeta().data.splice(t,e),this.insertElements(t,arguments.length-2)},onDataUnshift:function(){this.insertElements(0,arguments.length)}}),nt.extend=B.inherits;var it=nt,rt=2*Math.PI;function at(t,e){var n=e.startAngle,i=e.endAngle,r=e.pixelMargin,a=r/e.outerRadius,o=e.x,s=e.y;t.beginPath(),t.arc(o,s,e.outerRadius,n-a,i+a),e.innerRadius>r?(a=r/e.innerRadius,t.arc(o,s,e.innerRadius-r,i+a,n-a,!0)):t.arc(o,s,r,i+Math.PI/2,n-Math.PI/2),t.closePath(),t.clip()}function ot(t,e,n){var i="inner"===e.borderAlign;i?(t.lineWidth=2*e.borderWidth,t.lineJoin="round"):(t.lineWidth=e.borderWidth,t.lineJoin="bevel"),n.fullCircles&&function(t,e,n,i){var r,a=n.endAngle;for(i&&(n.endAngle=n.startAngle+rt,at(t,n),n.endAngle=a,n.endAngle===n.startAngle&&n.fullCircles&&(n.endAngle+=rt,n.fullCircles--)),t.beginPath(),t.arc(n.x,n.y,n.innerRadius,n.startAngle+rt,n.startAngle,!0),r=0;r<n.fullCircles;++r)t.stroke();for(t.beginPath(),t.arc(n.x,n.y,e.outerRadius,n.startAngle,n.startAngle+rt),r=0;r<n.fullCircles;++r)t.stroke()}(t,e,n,i),i&&at(t,n),t.beginPath(),t.arc(n.x,n.y,e.outerRadius,n.startAngle,n.endAngle),t.arc(n.x,n.y,n.innerRadius,n.endAngle,n.startAngle,!0),t.closePath(),t.stroke()}Y._set("global",{elements:{arc:{backgroundColor:Y.global.defaultColor,borderColor:"#fff",borderWidth:2,borderAlign:"center"}}});var st=$.extend({_type:"arc",inLabelRange:function(t){var e=this._view;return!!e&&Math.pow(t-e.x,2)<Math.pow(e.radius+e.hoverRadius,2)},inRange:function(t,e){var n=this._view;if(n){for(var i=B.getAngleFromPoint(n,{x:t,y:e}),r=i.angle,a=i.distance,o=n.startAngle,s=n.endAngle;s<o;)s+=rt;for(;s<r;)r-=rt;for(;r<o;)r+=rt;var l=o<=r&&r<=s,u=a>=n.innerRadius&&a<=n.outerRadius;return l&&u}return!1},getCenterPoint:function(){var t=this._view,e=(t.startAngle+t.endAngle)/2,n=(t.innerRadius+t.outerRadius)/2;return{x:t.x+Math.cos(e)*n,y:t.y+Math.sin(e)*n}},getArea:function(){var t=this._view;return Math.PI*((t.endAngle-t.startAngle)/(2*Math.PI))*(Math.pow(t.outerRadius,2)-Math.pow(t.innerRadius,2))},tooltipPosition:function(){var t=this._view,e=t.startAngle+(t.endAngle-t.startAngle)/2,n=(t.outerRadius-t.innerRadius)/2+t.innerRadius;return{x:t.x+Math.cos(e)*n,y:t.y+Math.sin(e)*n}},draw:function(){var t,e=this._chart.ctx,n=this._view,i="inner"===n.borderAlign?.33:0,r={x:n.x,y:n.y,innerRadius:n.innerRadius,outerRadius:Math.max(n.outerRadius-i,0),pixelMargin:i,startAngle:n.startAngle,endAngle:n.endAngle,fullCircles:Math.floor(n.circumference/rt)};if(e.save(),e.fillStyle=n.backgroundColor,e.strokeStyle=n.borderColor,r.fullCircles){for(r.endAngle=r.startAngle+rt,e.beginPath(),e.arc(r.x,r.y,r.outerRadius,r.startAngle,r.endAngle),e.arc(r.x,r.y,r.innerRadius,r.endAngle,r.startAngle,!0),e.closePath(),t=0;t<r.fullCircles;++t)e.fill();r.endAngle=r.startAngle+n.circumference%rt}e.beginPath(),e.arc(r.x,r.y,r.outerRadius,r.startAngle,r.endAngle),e.arc(r.x,r.y,r.innerRadius,r.endAngle,r.startAngle,!0),e.closePath(),e.fill(),n.borderWidth&&ot(e,n,r),e.restore()}}),lt=B.valueOrDefault,ut=Y.global.defaultColor;Y._set("global",{elements:{line:{tension:.4,backgroundColor:ut,borderWidth:3,borderColor:ut,borderCapStyle:"butt",borderDash:[],borderDashOffset:0,borderJoinStyle:"miter",capBezierPoints:!0,fill:!0}}});var dt=$.extend({_type:"line",draw:function(){var t,e,n,i=this,r=i._view,a=i._chart.ctx,o=r.spanGaps,s=i._children.slice(),l=Y.global,u=l.elements.line,d=-1,h=i._loop;if(s.length){if(i._loop){for(t=0;t<s.length;++t)if(e=B.previousItem(s,t),!s[t]._view.skip&&e._view.skip){s=s.slice(t).concat(s.slice(0,t)),h=o;break}h&&s.push(s[0])}for(a.save(),a.lineCap=r.borderCapStyle||u.borderCapStyle,a.setLineDash&&a.setLineDash(r.borderDash||u.borderDash),a.lineDashOffset=lt(r.borderDashOffset,u.borderDashOffset),a.lineJoin=r.borderJoinStyle||u.borderJoinStyle,a.lineWidth=lt(r.borderWidth,u.borderWidth),a.strokeStyle=r.borderColor||l.defaultColor,a.beginPath(),(n=s[0]._view).skip||(a.moveTo(n.x,n.y),d=0),t=1;t<s.length;++t)n=s[t]._view,e=-1===d?B.previousItem(s,t):s[d],n.skip||(d!==t-1&&!o||-1===d?a.moveTo(n.x,n.y):B.canvas.lineTo(a,e._view,n),d=t);h&&a.closePath(),a.stroke(),a.restore()}}}),ht=B.valueOrDefault,ct=Y.global.defaultColor;function ft(t){var e=this._view;return!!e&&Math.abs(t-e.x)<e.radius+e.hitRadius}Y._set("global",{elements:{point:{radius:3,pointStyle:"circle",backgroundColor:ct,borderColor:ct,borderWidth:1,hitRadius:1,hoverRadius:4,hoverBorderWidth:1}}});var gt=$.extend({_type:"point",inRange:function(t,e){var n=this._view;return!!n&&Math.pow(t-n.x,2)+Math.pow(e-n.y,2)<Math.pow(n.hitRadius+n.radius,2)},inLabelRange:ft,inXRange:ft,inYRange:function(t){var e=this._view;return!!e&&Math.abs(t-e.y)<e.radius+e.hitRadius},getCenterPoint:function(){var t=this._view;return{x:t.x,y:t.y}},getArea:function(){return Math.PI*Math.pow(this._view.radius,2)},tooltipPosition:function(){var t=this._view;return{x:t.x,y:t.y,padding:t.radius+t.borderWidth}},draw:function(t){var e=this._view,n=this._chart.ctx,i=e.pointStyle,r=e.rotation,a=e.radius,o=e.x,s=e.y,l=Y.global,u=l.defaultColor;e.skip||void 0!==t&&!B.canvas._isPointInArea(e,t)||(n.strokeStyle=e.borderColor||u,n.lineWidth=ht(e.borderWidth,l.elements.point.borderWidth),n.fillStyle=e.backgroundColor||u,B.canvas.drawPoint(n,i,a,o,s,r))}}),mt=Y.global.defaultColor;function pt(t){return t&&void 0!==t.width}function vt(t){var e,n,i,r,a=pt(t)?(r=t.width/2,e=t.x-r,n=t.x+r,i=Math.min(t.y,t.base),Math.max(t.y,t.base)):(r=t.height/2,e=Math.min(t.x,t.base),n=Math.max(t.x,t.base),i=t.y-r,t.y+r);return{left:e,top:i,right:n,bottom:a}}function yt(t,e,n){return t===e?n:t===n?e:t}function bt(t,e,n){var i,r,a,o,s,l,u,d=t.borderWidth,h=(r=(i=t).borderSkipped,a={},r&&(i.horizontal?i.base>i.x&&(r=yt(r,"left","right")):i.base<i.y&&(r=yt(r,"bottom","top")),a[r]=!0),a);return B.isObject(d)?(o=+d.top||0,s=+d.right||0,l=+d.bottom||0,u=+d.left||0):o=s=l=u=+d||0,{t:h.top||o<0?0:n<o?n:o,r:h.right||s<0?0:e<s?e:s,b:h.bottom||l<0?0:n<l?n:l,l:h.left||u<0?0:e<u?e:u}}function xt(t,e,n){var i=null===e,r=null===n,a=!(!t||i&&r)&&vt(t);return a&&(i||e>=a.left&&e<=a.right)&&(r||n>=a.top&&n<=a.bottom)}Y._set("global",{elements:{rectangle:{backgroundColor:mt,borderColor:mt,borderSkipped:"bottom",borderWidth:0}}});var _t=$.extend({_type:"rectangle",draw:function(){var t,e,n,i,r,a=this._chart.ctx,o=this._view,s=(e=vt(t=o),n=e.right-e.left,i=e.bottom-e.top,r=bt(t,n/2,i/2),{outer:{x:e.left,y:e.top,w:n,h:i},inner:{x:e.left+r.l,y:e.top+r.t,w:n-r.l-r.r,h:i-r.t-r.b}}),l=s.outer,u=s.inner;a.fillStyle=o.backgroundColor,a.fillRect(l.x,l.y,l.w,l.h),l.w===u.w&&l.h===u.h||(a.save(),a.beginPath(),a.rect(l.x,l.y,l.w,l.h),a.clip(),a.fillStyle=o.borderColor,a.rect(u.x,u.y,u.w,u.h),a.fill("evenodd"),a.restore())},height:function(){var t=this._view;return t.base-t.y},inRange:function(t,e){return xt(this._view,t,e)},inLabelRange:function(t,e){var n=this._view;return pt(n)?xt(n,t,null):xt(n,null,e)},inXRange:function(t){return xt(this._view,t,null)},inYRange:function(t){return xt(this._view,null,t)},getCenterPoint:function(){var t,e=this._view,n=pt(e)?(t=e.x,(e.y+e.base)/2):(t=(e.x+e.base)/2,e.y);return{x:t,y:n}},getArea:function(){var t=this._view;return pt(t)?t.width*Math.abs(t.y-t.base):t.height*Math.abs(t.x-t.base)},tooltipPosition:function(){var t=this._view;return{x:t.x,y:t.y}}}),wt={},kt=dt,Mt=gt,St=_t;wt.Arc=st,wt.Line=kt,wt.Point=Mt,wt.Rectangle=St;var Dt=B._deprecated,Ct=B.valueOrDefault;function Pt(t,e,n){var i,r=n.barThickness,a=e.stackCount,o=e.pixels[t],s=B.isNullOrUndef(r)?function(t,e){for(var n,i,r=t._length,a=1,o=e.length;a<o;++a)r=Math.min(r,Math.abs(e[a]-e[a-1]));for(a=0,o=t.getTicks().length;a<o;++a)i=t.getPixelForTick(a),r=0<a?Math.min(r,Math.abs(i-n)):r,n=i;return r}(e.scale,e.pixels):-1,l=B.isNullOrUndef(r)?(i=s*n.categoryPercentage,n.barPercentage):(i=r*a,1);return{chunk:i/a,ratio:l,start:o-i/2}}Y._set("bar",{hover:{mode:"label"},scales:{xAxes:[{type:"category",offset:!0,gridLines:{offsetGridLines:!0}}],yAxes:[{type:"linear"}]}}),Y._set("global",{datasets:{bar:{categoryPercentage:.8,barPercentage:.9}}});var Tt=it.extend({dataElementType:wt.Rectangle,_dataElementOptions:["backgroundColor","borderColor","borderSkipped","borderWidth","barPercentage","barThickness","categoryPercentage","maxBarThickness","minBarLength"],initialize:function(){var t,e,n=this;it.prototype.initialize.apply(n,arguments),(t=n.getMeta()).stack=n.getDataset().stack,t.bar=!0,e=n._getIndexScale().options,Dt("bar chart",e.barPercentage,"scales.[x/y]Axes.barPercentage","dataset.barPercentage"),Dt("bar chart",e.barThickness,"scales.[x/y]Axes.barThickness","dataset.barThickness"),Dt("bar chart",e.categoryPercentage,"scales.[x/y]Axes.categoryPercentage","dataset.categoryPercentage"),Dt("bar chart",n._getValueScale().options.minBarLength,"scales.[x/y]Axes.minBarLength","dataset.minBarLength"),Dt("bar chart",e.maxBarThickness,"scales.[x/y]Axes.maxBarThickness","dataset.maxBarThickness")},update:function(t){var e,n,i=this.getMeta().data;for(this._ruler=this.getRuler(),e=0,n=i.length;e<n;++e)this.updateElement(i[e],e,t)},updateElement:function(t,e,n){var i=this,r=i.getMeta(),a=i.getDataset(),o=i._resolveDataElementOptions(t,e);t._xScale=i.getScaleForId(r.xAxisID),t._yScale=i.getScaleForId(r.yAxisID),t._datasetIndex=i.index,t._index=e,t._model={backgroundColor:o.backgroundColor,borderColor:o.borderColor,borderSkipped:o.borderSkipped,borderWidth:o.borderWidth,datasetLabel:a.label,label:i.chart.data.labels[e]},B.isArray(a.data[e])&&(t._model.borderSkipped=null),i._updateElementGeometry(t,e,n,o),t.pivot()},_updateElementGeometry:function(t,e,n,i){var r=this,a=t._model,o=r._getValueScale(),s=o.getBasePixel(),l=o.isHorizontal(),u=r._ruler||r.getRuler(),d=r.calculateBarValuePixels(r.index,e,i),h=r.calculateBarIndexPixels(r.index,e,u,i);a.horizontal=l,a.base=n?s:d.base,a.x=l?n?s:d.head:h.center,a.y=l?h.center:n?s:d.head,a.height=l?h.size:void 0,a.width=l?void 0:h.size},_getStacks:function(t){for(var e,n=this._getIndexScale(),i=n._getMatchingVisibleMetas(this._type),r=n.options.stacked,a=i.length,o=[],s=0;s<a&&(e=i[s],(!1===r||-1===o.indexOf(e.stack)||void 0===r&&void 0===e.stack)&&o.push(e.stack),e.index!==t);++s);return o},getStackCount:function(){return this._getStacks().length},getStackIndex:function(t,e){var n=this._getStacks(t),i=void 0!==e?n.indexOf(e):-1;return-1===i?n.length-1:i},getRuler:function(){for(var t=this._getIndexScale(),e=[],n=0,i=this.getMeta().data.length;n<i;++n)e.push(t.getPixelForValue(null,n,this.index));return{pixels:e,start:t._startPixel,end:t._endPixel,stackCount:this.getStackCount(),scale:t}},calculateBarValuePixels:function(t,e,n){var i,r,a,o,s,l,u,d=this.chart,h=this._getValueScale(),c=h.isHorizontal(),f=d.data.datasets,g=h._getMatchingVisibleMetas(this._type),m=h._parseValue(f[t].data[e]),p=n.minBarLength,v=h.options.stacked,y=this.getMeta().stack,b=void 0===m.start?0:0<=m.max&&0<=m.min?m.min:m.max,x=void 0===m.start?m.end:0<=m.max&&0<=m.min?m.max-m.min:m.min-m.max,_=g.length;if(v||void 0===v&&void 0!==y)for(i=0;i<_&&(r=g[i]).index!==t;++i)r.stack===y&&(a=void 0===(u=h._parseValue(f[r.index].data[e])).start?u.end:0<=u.min&&0<=u.max?u.max:u.min,(m.min<0&&a<0||0<=m.max&&0<a)&&(b+=a));return o=h.getPixelForValue(b),l=(s=h.getPixelForValue(b+x))-o,void 0!==p&&Math.abs(l)<p&&(l=p,s=0<=x&&!c||x<0&&c?o-p:o+p),{size:l,base:o,head:s,center:s+l/2}},calculateBarIndexPixels:function(t,e,n,i){var r,a,o,s,l,u,d,h,c,f="flex"===i.barThickness?(r=e,o=i,l=(a=n).pixels,u=l[r],d=0<r?l[r-1]:null,h=r<l.length-1?l[r+1]:null,c=o.categoryPercentage,null===d&&(d=u-(null===h?a.end-a.start:h-u)),null===h&&(h=u+u-d),s=u-(u-Math.min(d,h))/2*c,{chunk:Math.abs(h-d)/2*c/a.stackCount,ratio:o.barPercentage,start:s}):Pt(e,n,i),g=this.getStackIndex(t,this.getMeta().stack),m=f.start+f.chunk*g+f.chunk/2,p=Math.min(Ct(i.maxBarThickness,1/0),f.chunk*f.ratio);return{base:m-p/2,head:m+p/2,center:m,size:p}},draw:function(){var t=this.chart,e=this._getValueScale(),n=this.getMeta().data,i=this.getDataset(),r=n.length,a=0;for(B.canvas.clipArea(t.ctx,t.chartArea);a<r;++a){var o=e._parseValue(i.data[a]);isNaN(o.min)||isNaN(o.max)||n[a].draw()}B.canvas.unclipArea(t.ctx)},_resolveDataElementOptions:function(){var t=B.extend({},it.prototype._resolveDataElementOptions.apply(this,arguments)),e=this._getIndexScale().options,n=this._getValueScale().options;return t.barPercentage=Ct(e.barPercentage,t.barPercentage),t.barThickness=Ct(e.barThickness,t.barThickness),t.categoryPercentage=Ct(e.categoryPercentage,t.categoryPercentage),t.maxBarThickness=Ct(e.maxBarThickness,t.maxBarThickness),t.minBarLength=Ct(n.minBarLength,t.minBarLength),t}}),Ot=B.valueOrDefault,At=B.options.resolve;Y._set("bubble",{hover:{mode:"single"},scales:{xAxes:[{type:"linear",position:"bottom",id:"x-axis-0"}],yAxes:[{type:"linear",position:"left",id:"y-axis-0"}]},tooltips:{callbacks:{title:function(){return""},label:function(t,e){var n=e.datasets[t.datasetIndex].label||"",i=e.datasets[t.datasetIndex].data[t.index];return n+": ("+t.xLabel+", "+t.yLabel+", "+i.r+")"}}}});var Ft=it.extend({dataElementType:wt.Point,_dataElementOptions:["backgroundColor","borderColor","borderWidth","hoverBackgroundColor","hoverBorderColor","hoverBorderWidth","hoverRadius","hitRadius","pointStyle","rotation"],update:function(n){var i=this,t=i.getMeta().data;B.each(t,function(t,e){i.updateElement(t,e,n)})},updateElement:function(t,e,n){var i=this,r=i.getMeta(),a=t.custom||{},o=i.getScaleForId(r.xAxisID),s=i.getScaleForId(r.yAxisID),l=i._resolveDataElementOptions(t,e),u=i.getDataset().data[e],d=i.index,h=n?o.getPixelForDecimal(.5):o.getPixelForValue("object"==typeof u?u:NaN,e,d),c=n?s.getBasePixel():s.getPixelForValue(u,e,d);t._xScale=o,t._yScale=s,t._options=l,t._datasetIndex=d,t._index=e,t._model={backgroundColor:l.backgroundColor,borderColor:l.borderColor,borderWidth:l.borderWidth,hitRadius:l.hitRadius,pointStyle:l.pointStyle,rotation:l.rotation,radius:n?0:l.radius,skip:a.skip||isNaN(h)||isNaN(c),x:h,y:c},t.pivot()},setHoverStyle:function(t){var e=t._model,n=t._options,i=B.getHoverColor;t.$previousStyle={backgroundColor:e.backgroundColor,borderColor:e.borderColor,borderWidth:e.borderWidth,radius:e.radius},e.backgroundColor=Ot(n.hoverBackgroundColor,i(n.backgroundColor)),e.borderColor=Ot(n.hoverBorderColor,i(n.borderColor)),e.borderWidth=Ot(n.hoverBorderWidth,n.borderWidth),e.radius=n.radius+n.hoverRadius},_resolveDataElementOptions:function(t,e){var n=this,i=n.chart,r=n.getDataset(),a=t.custom||{},o=r.data[e]||{},s=it.prototype._resolveDataElementOptions.apply(n,arguments),l={chart:i,dataIndex:e,dataset:r,datasetIndex:n.index};return n._cachedDataOpts===s&&(s=B.extend({},s)),s.radius=At([a.radius,o.r,n._config.radius,i.options.elements.point.radius],l,e),s}}),It=B.valueOrDefault,Lt=Math.PI,Rt=2*Lt,Nt=Lt/2;Y._set("doughnut",{animation:{animateRotate:!0,animateScale:!1},hover:{mode:"single"},legendCallback:function(t){var e,n,i,r=document.createElement("ul"),a=t.data,o=a.datasets,s=a.labels;if(r.setAttribute("class",t.id+"-legend"),o.length)for(n=o[e=0].data.length;e<n;++e)(i=r.appendChild(document.createElement("li"))).appendChild(document.createElement("span")).style.backgroundColor=o[0].backgroundColor[e],s[e]&&i.appendChild(document.createTextNode(s[e]));return r.outerHTML},legend:{labels:{generateLabels:function(r){var a=r.data;return a.labels.length&&a.datasets.length?a.labels.map(function(t,e){var n=r.getDatasetMeta(0),i=n.controller.getStyle(e);return{text:t,fillStyle:i.backgroundColor,strokeStyle:i.borderColor,lineWidth:i.borderWidth,hidden:isNaN(a.datasets[0].data[e])||n.data[e].hidden,index:e}}):[]}},onClick:function(t,e){for(var n,i=e.index,r=this.chart,a=0,o=(r.data.datasets||[]).length;a<o;++a)(n=r.getDatasetMeta(a)).data[i]&&(n.data[i].hidden=!n.data[i].hidden);r.update()}},cutoutPercentage:50,rotation:-Nt,circumference:Rt,tooltips:{callbacks:{title:function(){return""},label:function(t,e){var n=e.labels[t.index],i=": "+e.datasets[t.datasetIndex].data[t.index];return B.isArray(n)?(n=n.slice())[0]+=i:n+=i,n}}}});var Wt=it.extend({dataElementType:wt.Arc,linkScales:B.noop,_dataElementOptions:["backgroundColor","borderColor","borderWidth","borderAlign","hoverBackgroundColor","hoverBorderColor","hoverBorderWidth"],getRingIndex:function(t){for(var e=0,n=0;n<t;++n)this.chart.isDatasetVisible(n)&&++e;return e},update:function(t){var e,n,i,r,a,o,s,l,u,d,h,c,f,g,m,p,v,y=this,b=y.chart,x=b.chartArea,_=b.options,w=1,k=1,M=0,S=0,D=y.getMeta(),C=D.data,P=_.cutoutPercentage/100||0,T=_.circumference,O=y._getRingWeight(y.index);for(T<Rt&&(a=_.rotation%Rt,o=(a+=Lt<=a?-Rt:a<-Lt?Rt:0)+T,s=Math.cos(a),l=Math.sin(a),u=Math.cos(o),d=Math.sin(o),h=a<=0&&0<=o||Rt<=o,c=a<=Nt&&Nt<=o||Rt+Nt<=o,f=a<=-Nt&&-Nt<=o||Lt+Nt<=o,g=a===-Lt||Lt<=o?-1:Math.min(s,s*P,u,u*P),m=f?-1:Math.min(l,l*P,d,d*P),w=((p=h?1:Math.max(s,s*P,u,u*P))-g)/2,k=((v=c?1:Math.max(l,l*P,d,d*P))-m)/2,M=-(p+g)/2,S=-(v+m)/2),i=0,r=C.length;i<r;++i)C[i]._options=y._resolveDataElementOptions(C[i],i);for(b.borderWidth=y.getMaxBorderWidth(),e=(x.right-x.left-b.borderWidth)/w,n=(x.bottom-x.top-b.borderWidth)/k,b.outerRadius=Math.max(Math.min(e,n)/2,0),b.innerRadius=Math.max(b.outerRadius*P,0),b.radiusLength=(b.outerRadius-b.innerRadius)/(y._getVisibleDatasetWeightTotal()||1),b.offsetX=M*b.outerRadius,b.offsetY=S*b.outerRadius,D.total=y.calculateTotal(),y.outerRadius=b.outerRadius-b.radiusLength*y._getRingWeightOffset(y.index),y.innerRadius=Math.max(y.outerRadius-b.radiusLength*O,0),i=0,r=C.length;i<r;++i)y.updateElement(C[i],i,t)},updateElement:function(t,e,n){var i=this,r=i.chart,a=r.chartArea,o=r.options,s=o.animation,l=(a.left+a.right)/2,u=(a.top+a.bottom)/2,d=o.rotation,h=o.rotation,c=i.getDataset(),f=n&&s.animateRotate||t.hidden?0:i.calculateCircumference(c.data[e])*(o.circumference/Rt),g=n&&s.animateScale?0:i.innerRadius,m=n&&s.animateScale?0:i.outerRadius,p=t._options||{};B.extend(t,{_datasetIndex:i.index,_index:e,_model:{backgroundColor:p.backgroundColor,borderColor:p.borderColor,borderWidth:p.borderWidth,borderAlign:p.borderAlign,x:l+r.offsetX,y:u+r.offsetY,startAngle:d,endAngle:h,circumference:f,outerRadius:m,innerRadius:g,label:B.valueAtIndexOrDefault(c.label,e,r.data.labels[e])}});var v=t._model;n&&s.animateRotate||(v.startAngle=0===e?o.rotation:i.getMeta().data[e-1]._model.endAngle,v.endAngle=v.startAngle+v.circumference),t.pivot()},calculateTotal:function(){var n,i=this.getDataset(),t=this.getMeta(),r=0;return B.each(t.data,function(t,e){n=i.data[e],isNaN(n)||t.hidden||(r+=Math.abs(n))}),r},calculateCircumference:function(t){var e=this.getMeta().total;return 0<e&&!isNaN(t)?Rt*(Math.abs(t)/e):0},getMaxBorderWidth:function(t){var e,n,i,r,a,o,s,l,u=0,d=this.chart;if(!t)for(e=0,n=d.data.datasets.length;e<n;++e)if(d.isDatasetVisible(e)){t=(i=d.getDatasetMeta(e)).data,e!==this.index&&(a=i.controller);break}if(!t)return 0;for(e=0,n=t.length;e<n;++e)r=t[e],"inner"!==(o=a?(a._configure(),a._resolveDataElementOptions(r,e)):r._options).borderAlign&&(u=(u=u<(s=o.borderWidth)?s:u)<(l=o.hoverBorderWidth)?l:u);return u},setHoverStyle:function(t){var e=t._model,n=t._options,i=B.getHoverColor;t.$previousStyle={backgroundColor:e.backgroundColor,borderColor:e.borderColor,borderWidth:e.borderWidth},e.backgroundColor=It(n.hoverBackgroundColor,i(n.backgroundColor)),e.borderColor=It(n.hoverBorderColor,i(n.borderColor)),e.borderWidth=It(n.hoverBorderWidth,n.borderWidth)},_getRingWeightOffset:function(t){for(var e=0,n=0;n<t;++n)this.chart.isDatasetVisible(n)&&(e+=this._getRingWeight(n));return e},_getRingWeight:function(t){return Math.max(It(this.chart.data.datasets[t].weight,1),0)},_getVisibleDatasetWeightTotal:function(){return this._getRingWeightOffset(this.chart.data.datasets.length)}});Y._set("horizontalBar",{hover:{mode:"index",axis:"y"},scales:{xAxes:[{type:"linear",position:"bottom"}],yAxes:[{type:"category",position:"left",offset:!0,gridLines:{offsetGridLines:!0}}]},elements:{rectangle:{borderSkipped:"left"}},tooltips:{mode:"index",axis:"y"}}),Y._set("global",{datasets:{horizontalBar:{categoryPercentage:.8,barPercentage:.9}}});var Yt=Tt.extend({_getValueScaleId:function(){return this.getMeta().xAxisID},_getIndexScaleId:function(){return this.getMeta().yAxisID}}),zt=B.valueOrDefault,Vt=B.options.resolve,Et=B.canvas._isPointInArea;function Ht(t,e){var n=t&&t.options.ticks||{},i=n.reverse,r=void 0===n.min?e:0,a=void 0===n.max?e:0;return{start:i?a:r,end:i?r:a}}Y._set("line",{showLines:!0,spanGaps:!1,hover:{mode:"label"},scales:{xAxes:[{type:"category",id:"x-axis-0"}],yAxes:[{type:"linear",id:"y-axis-0"}]}});var Bt=it.extend({datasetElementType:wt.Line,dataElementType:wt.Point,_datasetElementOptions:["backgroundColor","borderCapStyle","borderColor","borderDash","borderDashOffset","borderJoinStyle","borderWidth","cubicInterpolationMode","fill"],_dataElementOptions:{backgroundColor:"pointBackgroundColor",borderColor:"pointBorderColor",borderWidth:"pointBorderWidth",hitRadius:"pointHitRadius",hoverBackgroundColor:"pointHoverBackgroundColor",hoverBorderColor:"pointHoverBorderColor",hoverBorderWidth:"pointHoverBorderWidth",hoverRadius:"pointHoverRadius",pointStyle:"pointStyle",radius:"pointRadius",rotation:"pointRotation"},update:function(t){var e,n,i=this,r=i.getMeta(),a=r.dataset,o=r.data||[],s=i.chart.options,l=i._config,u=i._showLine=zt(l.showLine,s.showLines);for(i._xScale=i.getScaleForId(r.xAxisID),i._yScale=i.getScaleForId(r.yAxisID),u&&(void 0!==l.tension&&void 0===l.lineTension&&(l.lineTension=l.tension),a._scale=i._yScale,a._datasetIndex=i.index,a._children=o,a._model=i._resolveDatasetElementOptions(a),a.pivot()),e=0,n=o.length;e<n;++e)i.updateElement(o[e],e,t);for(u&&0!==a._model.tension&&i.updateBezierControlPoints(),e=0,n=o.length;e<n;++e)o[e].pivot()},updateElement:function(t,e,n){var i=this,r=i.getMeta(),a=t.custom||{},o=i.getDataset(),s=i.index,l=o.data[e],u=i._xScale,d=i._yScale,h=r.dataset._model,c=i._resolveDataElementOptions(t,e),f=u.getPixelForValue("object"==typeof l?l:NaN,e,s),g=n?d.getBasePixel():i.calculatePointY(l,e,s);t._xScale=u,t._yScale=d,t._options=c,t._datasetIndex=s,t._index=e,t._model={x:f,y:g,skip:a.skip||isNaN(f)||isNaN(g),radius:c.radius,pointStyle:c.pointStyle,rotation:c.rotation,backgroundColor:c.backgroundColor,borderColor:c.borderColor,borderWidth:c.borderWidth,tension:zt(a.tension,h?h.tension:0),steppedLine:!!h&&h.steppedLine,hitRadius:c.hitRadius}},_resolveDatasetElementOptions:function(t){var e,n,i,r,a,o,s,l,u,d,h,c=this,f=c._config,g=t.custom||{},m=c.chart.options,p=m.elements.line,v=it.prototype._resolveDatasetElementOptions.apply(c,arguments);return v.spanGaps=zt(f.spanGaps,m.spanGaps),v.tension=zt(f.lineTension,p.tension),v.steppedLine=Vt([g.steppedLine,f.steppedLine,p.stepped]),v.clip=(e=zt(f.clip,(o=c._xScale,s=c._yScale,l=v.borderWidth,d=Ht(o,u=l/2),{top:(h=Ht(s,u)).end,right:d.end,bottom:h.start,left:d.start})),B.isObject(e)?(n=e.top,i=e.right,r=e.bottom,a=e.left):n=i=r=a=e,{top:n,right:i,bottom:r,left:a}),v},calculatePointY:function(t,e,n){var i,r,a,o,s,l,u,d=this.chart,h=this._yScale,c=0,f=0;if(h.options.stacked){for(s=+h.getRightValue(t),u=(l=d._getSortedVisibleDatasetMetas()).length,i=0;i<u&&(a=l[i]).index!==n;++i)r=d.data.datasets[a.index],"line"===a.type&&a.yAxisID===h.id&&((o=+h.getRightValue(r.data[e]))<0?f+=o||0:c+=o||0);return s<0?h.getPixelForValue(f+s):h.getPixelForValue(c+s)}return h.getPixelForValue(t)},updateBezierControlPoints:function(){var t,e,n,i,r=this.chart,a=this.getMeta(),o=a.dataset._model,s=r.chartArea,l=a.data||[];function u(t,e,n){return Math.max(Math.min(t,n),e)}if(o.spanGaps&&(l=l.filter(function(t){return!t._model.skip})),"monotone"===o.cubicInterpolationMode)B.splineCurveMonotone(l);else for(t=0,e=l.length;t<e;++t)n=l[t]._model,i=B.splineCurve(B.previousItem(l,t)._model,n,B.nextItem(l,t)._model,o.tension),n.controlPointPreviousX=i.previous.x,n.controlPointPreviousY=i.previous.y,n.controlPointNextX=i.next.x,n.controlPointNextY=i.next.y;if(r.options.elements.line.capBezierPoints)for(t=0,e=l.length;t<e;++t)n=l[t]._model,Et(n,s)&&(0<t&&Et(l[t-1]._model,s)&&(n.controlPointPreviousX=u(n.controlPointPreviousX,s.left,s.right),n.controlPointPreviousY=u(n.controlPointPreviousY,s.top,s.bottom)),t<l.length-1&&Et(l[t+1]._model,s)&&(n.controlPointNextX=u(n.controlPointNextX,s.left,s.right),n.controlPointNextY=u(n.controlPointNextY,s.top,s.bottom)))},draw:function(){var t,e=this.chart,n=this.getMeta(),i=n.data||[],r=e.chartArea,a=e.canvas,o=0,s=i.length;for(this._showLine&&(t=n.dataset._model.clip,B.canvas.clipArea(e.ctx,{left:!1===t.left?0:r.left-t.left,right:!1===t.right?a.width:r.right+t.right,top:!1===t.top?0:r.top-t.top,bottom:!1===t.bottom?a.height:r.bottom+t.bottom}),n.dataset.draw(),B.canvas.unclipArea(e.ctx));o<s;++o)i[o].draw(r)},setHoverStyle:function(t){var e=t._model,n=t._options,i=B.getHoverColor;t.$previousStyle={backgroundColor:e.backgroundColor,borderColor:e.borderColor,borderWidth:e.borderWidth,radius:e.radius},e.backgroundColor=zt(n.hoverBackgroundColor,i(n.backgroundColor)),e.borderColor=zt(n.hoverBorderColor,i(n.borderColor)),e.borderWidth=zt(n.hoverBorderWidth,n.borderWidth),e.radius=zt(n.hoverRadius,n.radius)}}),jt=B.options.resolve;Y._set("polarArea",{scale:{type:"radialLinear",angleLines:{display:!1},gridLines:{circular:!0},pointLabels:{display:!1},ticks:{beginAtZero:!0}},animation:{animateRotate:!0,animateScale:!0},startAngle:-.5*Math.PI,legendCallback:function(t){var e,n,i,r=document.createElement("ul"),a=t.data,o=a.datasets,s=a.labels;if(r.setAttribute("class",t.id+"-legend"),o.length)for(n=o[e=0].data.length;e<n;++e)(i=r.appendChild(document.createElement("li"))).appendChild(document.createElement("span")).style.backgroundColor=o[0].backgroundColor[e],s[e]&&i.appendChild(document.createTextNode(s[e]));return r.outerHTML},legend:{labels:{generateLabels:function(r){var a=r.data;return a.labels.length&&a.datasets.length?a.labels.map(function(t,e){var n=r.getDatasetMeta(0),i=n.controller.getStyle(e);return{text:t,fillStyle:i.backgroundColor,strokeStyle:i.borderColor,lineWidth:i.borderWidth,hidden:isNaN(a.datasets[0].data[e])||n.data[e].hidden,index:e}}):[]}},onClick:function(t,e){for(var n,i=e.index,r=this.chart,a=0,o=(r.data.datasets||[]).length;a<o;++a)(n=r.getDatasetMeta(a)).data[i].hidden=!n.data[i].hidden;r.update()}},tooltips:{callbacks:{title:function(){return""},label:function(t,e){return e.labels[t.index]+": "+t.yLabel}}}});var Ut=it.extend({dataElementType:wt.Arc,linkScales:B.noop,_dataElementOptions:["backgroundColor","borderColor","borderWidth","borderAlign","hoverBackgroundColor","hoverBorderColor","hoverBorderWidth"],_getIndexScaleId:function(){return this.chart.scale.id},_getValueScaleId:function(){return this.chart.scale.id},update:function(t){var e,n,i,r=this,a=r.getDataset(),o=r.getMeta(),s=r.chart.options.startAngle||0,l=r._starts=[],u=r._angles=[],d=o.data;for(r._updateRadius(),o.count=r.countVisibleElements(),e=0,n=a.data.length;e<n;e++)l[e]=s,i=r._computeAngle(e),s+=u[e]=i;for(e=0,n=d.length;e<n;++e)d[e]._options=r._resolveDataElementOptions(d[e],e),r.updateElement(d[e],e,t)},_updateRadius:function(){var t=this,e=t.chart,n=e.chartArea,i=e.options,r=Math.min(n.right-n.left,n.bottom-n.top);e.outerRadius=Math.max(r/2,0),e.innerRadius=Math.max(i.cutoutPercentage?e.outerRadius/100*i.cutoutPercentage:1,0),e.radiusLength=(e.outerRadius-e.innerRadius)/e.getVisibleDatasetCount(),t.outerRadius=e.outerRadius-e.radiusLength*t.index,t.innerRadius=t.outerRadius-e.radiusLength},updateElement:function(t,e,n){var i=this,r=i.chart,a=i.getDataset(),o=r.options,s=o.animation,l=r.scale,u=r.data.labels,d=l.xCenter,h=l.yCenter,c=o.startAngle,f=t.hidden?0:l.getDistanceFromCenterForValue(a.data[e]),g=i._starts[e],m=g+(t.hidden?0:i._angles[e]),p=s.animateScale?0:l.getDistanceFromCenterForValue(a.data[e]),v=t._options||{};B.extend(t,{_datasetIndex:i.index,_index:e,_scale:l,_model:{backgroundColor:v.backgroundColor,borderColor:v.borderColor,borderWidth:v.borderWidth,borderAlign:v.borderAlign,x:d,y:h,innerRadius:0,outerRadius:n?p:f,startAngle:n&&s.animateRotate?c:g,endAngle:n&&s.animateRotate?c:m,label:B.valueAtIndexOrDefault(u,e,u[e])}}),t.pivot()},countVisibleElements:function(){var n=this.getDataset(),t=this.getMeta(),i=0;return B.each(t.data,function(t,e){isNaN(n.data[e])||t.hidden||i++}),i},setHoverStyle:function(t){var e=t._model,n=t._options,i=B.getHoverColor,r=B.valueOrDefault;t.$previousStyle={backgroundColor:e.backgroundColor,borderColor:e.borderColor,borderWidth:e.borderWidth},e.backgroundColor=r(n.hoverBackgroundColor,i(n.backgroundColor)),e.borderColor=r(n.hoverBorderColor,i(n.borderColor)),e.borderWidth=r(n.hoverBorderWidth,n.borderWidth)},_computeAngle:function(t){var e=this,n=this.getMeta().count,i=e.getDataset(),r=e.getMeta();if(isNaN(i.data[t])||r.data[t].hidden)return 0;var a={chart:e.chart,dataIndex:t,dataset:i,datasetIndex:e.index};return jt([e.chart.options.elements.arc.angle,2*Math.PI/n],a,t)}});Y._set("pie",B.clone(Y.doughnut)),Y._set("pie",{cutoutPercentage:0});var Gt=Wt,qt=B.valueOrDefault;Y._set("radar",{spanGaps:!1,scale:{type:"radialLinear"},elements:{line:{fill:"start",tension:0}}});var Zt=it.extend({datasetElementType:wt.Line,dataElementType:wt.Point,linkScales:B.noop,_datasetElementOptions:["backgroundColor","borderWidth","borderColor","borderCapStyle","borderDash","borderDashOffset","borderJoinStyle","fill"],_dataElementOptions:{backgroundColor:"pointBackgroundColor",borderColor:"pointBorderColor",borderWidth:"pointBorderWidth",hitRadius:"pointHitRadius",hoverBackgroundColor:"pointHoverBackgroundColor",hoverBorderColor:"pointHoverBorderColor",hoverBorderWidth:"pointHoverBorderWidth",hoverRadius:"pointHoverRadius",pointStyle:"pointStyle",radius:"pointRadius",rotation:"pointRotation"},_getIndexScaleId:function(){return this.chart.scale.id},_getValueScaleId:function(){return this.chart.scale.id},update:function(t){var e,n,i=this,r=i.getMeta(),a=r.dataset,o=r.data||[],s=i.chart.scale,l=i._config;for(void 0!==l.tension&&void 0===l.lineTension&&(l.lineTension=l.tension),a._scale=s,a._datasetIndex=i.index,a._children=o,a._loop=!0,a._model=i._resolveDatasetElementOptions(a),a.pivot(),e=0,n=o.length;e<n;++e)i.updateElement(o[e],e,t);for(i.updateBezierControlPoints(),e=0,n=o.length;e<n;++e)o[e].pivot()},updateElement:function(t,e,n){var i=this,r=t.custom||{},a=i.getDataset(),o=i.chart.scale,s=o.getPointPositionForValue(e,a.data[e]),l=i._resolveDataElementOptions(t,e),u=i.getMeta().dataset._model,d=n?o.xCenter:s.x,h=n?o.yCenter:s.y;t._scale=o,t._options=l,t._datasetIndex=i.index,t._index=e,t._model={x:d,y:h,skip:r.skip||isNaN(d)||isNaN(h),radius:l.radius,pointStyle:l.pointStyle,rotation:l.rotation,backgroundColor:l.backgroundColor,borderColor:l.borderColor,borderWidth:l.borderWidth,tension:qt(r.tension,u?u.tension:0),hitRadius:l.hitRadius}},_resolveDatasetElementOptions:function(){var t=this._config,e=this.chart.options,n=it.prototype._resolveDatasetElementOptions.apply(this,arguments);return n.spanGaps=qt(t.spanGaps,e.spanGaps),n.tension=qt(t.lineTension,e.elements.line.tension),n},updateBezierControlPoints:function(){var t,e,n,i,r=this.getMeta(),a=this.chart.chartArea,o=r.data||[];function s(t,e,n){return Math.max(Math.min(t,n),e)}for(r.dataset._model.spanGaps&&(o=o.filter(function(t){return!t._model.skip})),t=0,e=o.length;t<e;++t)n=o[t]._model,i=B.splineCurve(B.previousItem(o,t,!0)._model,n,B.nextItem(o,t,!0)._model,n.tension),n.controlPointPreviousX=s(i.previous.x,a.left,a.right),n.controlPointPreviousY=s(i.previous.y,a.top,a.bottom),n.controlPointNextX=s(i.next.x,a.left,a.right),n.controlPointNextY=s(i.next.y,a.top,a.bottom)},setHoverStyle:function(t){var e=t._model,n=t._options,i=B.getHoverColor;t.$previousStyle={backgroundColor:e.backgroundColor,borderColor:e.borderColor,borderWidth:e.borderWidth,radius:e.radius},e.backgroundColor=qt(n.hoverBackgroundColor,i(n.backgroundColor)),e.borderColor=qt(n.hoverBorderColor,i(n.borderColor)),e.borderWidth=qt(n.hoverBorderWidth,n.borderWidth),e.radius=qt(n.hoverRadius,n.radius)}});Y._set("scatter",{hover:{mode:"single"},scales:{xAxes:[{id:"x-axis-1",type:"linear",position:"bottom"}],yAxes:[{id:"y-axis-1",type:"linear",position:"left"}]},tooltips:{callbacks:{title:function(){return""},label:function(t){return"("+t.xLabel+", "+t.yLabel+")"}}}}),Y._set("global",{datasets:{scatter:{showLine:!1}}});var $t={bar:Tt,bubble:Ft,doughnut:Wt,horizontalBar:Yt,line:Bt,polarArea:Ut,pie:Gt,radar:Zt,scatter:Bt};function Xt(t,e){return t.native?{x:t.x,y:t.y}:B.getRelativePosition(t,e)}function Kt(t,e){for(var n,i,r,a,o=t._getSortedVisibleDatasetMetas(),s=0,l=o.length;s<l;++s)for(i=0,r=(n=o[s].data).length;i<r;++i)(a=n[i])._view.skip||e(a)}function Jt(t,e){var n=[];return Kt(t,function(t){t.inRange(e.x,e.y)&&n.push(t)}),n}function Qt(t,i,r,a){var o=Number.POSITIVE_INFINITY,s=[];return Kt(t,function(t){var e,n;r&&!t.inRange(i.x,i.y)||(e=t.getCenterPoint(),(n=a(i,e))<o?(s=[t],o=n):n===o&&s.push(t))}),s}function te(t){var r=-1!==t.indexOf("x"),a=-1!==t.indexOf("y");return function(t,e){var n=r?Math.abs(t.x-e.x):0,i=a?Math.abs(t.y-e.y):0;return Math.sqrt(Math.pow(n,2)+Math.pow(i,2))}}function ee(t,e,n){var i=Xt(e,t);n.axis=n.axis||"x";var r=te(n.axis),a=n.intersect?Jt(t,i):Qt(t,i,!1,r),o=[];return a.length?(t._getSortedVisibleDatasetMetas().forEach(function(t){var e=t.data[a[0]._index];e&&!e._view.skip&&o.push(e)}),o):[]}var ne={modes:{single:function(t,e){var n=Xt(e,t),i=[];return Kt(t,function(t){return t.inRange(n.x,n.y)&&(i.push(t),i)}),i.slice(0,1)},label:ee,index:ee,dataset:function(t,e,n){var i=Xt(e,t);n.axis=n.axis||"xy";var r=te(n.axis),a=n.intersect?Jt(t,i):Qt(t,i,!1,r);return 0<a.length&&(a=t.getDatasetMeta(a[0]._datasetIndex).data),a},"x-axis":function(t,e){return ee(t,e,{intersect:!1})},point:function(t,e){return Jt(t,Xt(e,t))},nearest:function(t,e,n){var i=Xt(e,t);n.axis=n.axis||"xy";var r=te(n.axis);return Qt(t,i,n.intersect,r)},x:function(t,e,n){var i=Xt(e,t),r=[],a=!1;return Kt(t,function(t){t.inXRange(i.x)&&r.push(t),t.inRange(i.x,i.y)&&(a=!0)}),n.intersect&&!a&&(r=[]),r},y:function(t,e,n){var i=Xt(e,t),r=[],a=!1;return Kt(t,function(t){t.inYRange(i.y)&&r.push(t),t.inRange(i.x,i.y)&&(a=!0)}),n.intersect&&!a&&(r=[]),r}}},ie=B.extend;function re(t,e){return B.where(t,function(t){return t.pos===e})}function ae(t,r){return t.sort(function(t,e){var n=r?e:t,i=r?t:e;return n.weight===i.weight?n.index-i.index:n.weight-i.weight})}function oe(t){var e=function(t){for(var e,n=[],i=0,r=(t||[]).length;i<r;++i)e=t[i],n.push({index:i,box:e,pos:e.position,horizontal:e.isHorizontal(),weight:e.weight});return n}(t),n=ae(re(e,"left"),!0),i=ae(re(e,"right")),r=ae(re(e,"top"),!0),a=ae(re(e,"bottom"));return{leftAndTop:n.concat(r),rightAndBottom:i.concat(a),chartArea:re(e,"chartArea"),vertical:n.concat(i),horizontal:r.concat(a)}}function se(t,e,n,i){return Math.max(t[n],e[n])+Math.max(t[i],e[i])}function le(t,e,n){for(var i,r,a,o,s=[],l=0,u=t.length;l<u;++l)(r=(i=t[l]).box).update(i.width||e.w,i.height||e.h,function(t,n){var i=n.maxPadding;function e(t){var e={left:0,top:0,right:0,bottom:0};return t.forEach(function(t){e[t]=Math.max(n[t],i[t])}),e}return e(t?["left","right"]:["top","bottom"])}(i.horizontal,e)),function(t,e,n){var i,r,a,o=n.box,s=t.maxPadding;if(n.size&&(t[n.pos]-=n.size),n.size=n.horizontal?o.height:o.width,t[n.pos]+=n.size,o.getPadding&&(a=o.getPadding(),s.top=Math.max(s.top,a.top),s.left=Math.max(s.left,a.left),s.bottom=Math.max(s.bottom,a.bottom),s.right=Math.max(s.right,a.right)),i=e.outerWidth-se(s,t,"left","right"),r=e.outerHeight-se(s,t,"top","bottom"),i!==t.w||r!==t.h){t.w=i,t.h=r;var l=n.horizontal?[i,t.w]:[r,t.h];return!(l[0]===l[1]||isNaN(l[0])&&isNaN(l[1]))}}(e,n,i)&&(o=!0,s.length&&(a=!0)),r.fullWidth||s.push(i);return a&&le(s,e,n)||o}function ue(t,e,n){for(var i,r,a=n.padding,o=e.x,s=e.y,l=0,u=t.length;l<u;++l)r=(i=t[l]).box,i.horizontal?(r.left=r.fullWidth?a.left:e.left,r.right=r.fullWidth?n.outerWidth-a.right:e.left+e.w,r.top=s,r.bottom=s+r.height,r.width=r.right-r.left,s=r.bottom):(r.left=o,r.right=o+r.width,r.top=e.top,r.bottom=e.top+e.h,r.height=r.bottom-r.top,o=r.right);e.x=o,e.y=s}Y._set("global",{layout:{padding:{top:0,right:0,bottom:0,left:0}}});var de,he={defaults:{},addBox:function(t,e){t.boxes||(t.boxes=[]),e.fullWidth=e.fullWidth||!1,e.position=e.position||"top",e.weight=e.weight||0,e._layers=e._layers||function(){return[{z:0,draw:function(){e.draw.apply(e,arguments)}}]},t.boxes.push(e)},removeBox:function(t,e){var n=t.boxes?t.boxes.indexOf(e):-1;-1!==n&&t.boxes.splice(n,1)},configure:function(t,e,n){for(var i,r=["fullWidth","position","weight"],a=r.length,o=0;o<a;++o)i=r[o],n.hasOwnProperty(i)&&(e[i]=n[i])},update:function(n,t,e){var i,r,a,o,s,l,u,d,h,c,f;function g(t){var e=Math.max(f[t]-c[t],0);return c[t]+=e,e}n&&(i=n.options.layout||{},a=t-(r=B.options.toPadding(i.padding)).width,o=e-r.height,l=(s=oe(n.boxes)).vertical,u=s.horizontal,d=Object.freeze({outerWidth:t,outerHeight:e,padding:r,availableWidth:a,vBoxMaxWidth:a/2/l.length,hBoxMaxHeight:o/2}),h=ie({maxPadding:ie({},r),w:a,h:o,x:r.left,y:r.top},r),function(t,e){for(var n,i=0,r=t.length;i<r;++i)(n=t[i]).width=n.horizontal?n.box.fullWidth&&e.availableWidth:e.vBoxMaxWidth,n.height=n.horizontal&&e.hBoxMaxHeight}(l.concat(u),d),le(l,h,d),le(u,h,d)&&le(l,h,d),f=(c=h).maxPadding,c.y+=g("top"),c.x+=g("left"),g("right"),g("bottom"),ue(s.leftAndTop,h,d),h.x+=h.w,h.y+=h.h,ue(s.rightAndBottom,h,d),n.chartArea={left:h.left,top:h.top,right:h.left+h.w,bottom:h.top+h.h},B.each(s.chartArea,function(t){var e=t.box;ie(e,n.chartArea),e.update(h.w,h.h)}))}},ce=(de=Object.freeze({__proto__:null,default:"/*\r\n * DOM element rendering detection\r\n * https://davidwalsh.name/detect-node-insertion\r\n */\r\n@keyframes chartjs-render-animation {\r\n\tfrom { opacity: 0.99; }\r\n\tto { opacity: 1; }\r\n}\r\n\r\n.chartjs-render-monitor {\r\n\tanimation: chartjs-render-animation 0.001s;\r\n}\r\n\r\n/*\r\n * DOM element resizing detection\r\n * https://github.com/marcj/css-element-queries\r\n */\r\n.chartjs-size-monitor,\r\n.chartjs-size-monitor-expand,\r\n.chartjs-size-monitor-shrink {\r\n\tposition: absolute;\r\n\tdirection: ltr;\r\n\tleft: 0;\r\n\ttop: 0;\r\n\tright: 0;\r\n\tbottom: 0;\r\n\toverflow: hidden;\r\n\tpointer-events: none;\r\n\tvisibility: hidden;\r\n\tz-index: -1;\r\n}\r\n\r\n.chartjs-size-monitor-expand > div {\r\n\tposition: absolute;\r\n\twidth: 1000000px;\r\n\theight: 1000000px;\r\n\tleft: 0;\r\n\ttop: 0;\r\n}\r\n\r\n.chartjs-size-monitor-shrink > div {\r\n\tposition: absolute;\r\n\twidth: 200%;\r\n\theight: 200%;\r\n\tleft: 0;\r\n\ttop: 0;\r\n}\r\n"}))&&de.default||de,fe="$chartjs",ge="chartjs-",me=ge+"size-monitor",pe=ge+"render-monitor",ve=ge+"render-animation",ye=["animationstart","webkitAnimationStart"],be={touchstart:"mousedown",touchmove:"mousemove",touchend:"mouseup",pointerenter:"mouseenter",pointerdown:"mousedown",pointermove:"mousemove",pointerup:"mouseup",pointerleave:"mouseout",pointerout:"mouseout"};function xe(t,e){var n=B.getStyle(t,e),i=n&&n.match(/^(\d+)(\.\d+)?px$/);return i?Number(i[1]):void 0}var _e=!!function(){var t=!1;try{var e=Object.defineProperty({},"passive",{get:function(){t=!0}});window.addEventListener("e",null,e)}catch(t){}return t}()&&{passive:!0};function we(t,e,n){t.addEventListener(e,n,_e)}function ke(t,e,n){t.removeEventListener(e,n,_e)}function Me(t,e,n,i,r){return{type:t,chart:e,native:r||null,x:void 0!==n?n:null,y:void 0!==i?i:null}}function Se(t){var e=document.createElement("div");return e.className=t||"",e}function De(n,i,r){var t,e,a,o,s,l,u,d,h,c,f,g,m=n[fe]||(n[fe]={}),p=m.resizer=(u=!(s=function(){var t,e;m.resizer&&(e=(t=r.options.maintainAspectRatio&&n.parentNode)?t.clientWidth:0,i(Me("resize",r)),t&&t.clientWidth<e&&r.canvas&&i(Me("resize",r)))}),d=[],t=function(){d=Array.prototype.slice.call(arguments),l=l||this,u||(u=!0,B.requestAnimFrame.call(window,function(){u=!1,s.apply(l,d)}))},e=Se(me),a=Se(me+"-expand"),o=Se(me+"-shrink"),a.appendChild(Se()),o.appendChild(Se()),e.appendChild(a),e.appendChild(o),e._reset=function(){a.scrollLeft=1e6,a.scrollTop=1e6,o.scrollLeft=1e6,o.scrollTop=1e6},we(a,"scroll",v.bind(a,"expand")),we(o,"scroll",v.bind(o,"shrink")),e);function v(){e._reset(),t()}c=function(){var t;m.resizer&&((t=n.parentNode)&&t!==p.parentNode&&t.insertBefore(p,t.firstChild),p._reset())},f=(h=n)[fe]||(h[fe]={}),g=f.renderProxy=function(t){t.animationName===ve&&c()},B.each(ye,function(t){we(h,t,g)}),f.reflow=!!h.offsetParent,h.classList.add(pe)}function Ce(t){var e,n,i,r=t[fe]||{},a=r.resizer;delete r.resizer,n=(e=t)[fe]||{},(i=n.renderProxy)&&(B.each(ye,function(t){ke(e,t,i)}),delete n.renderProxy),e.classList.remove(pe),a&&a.parentNode&&a.parentNode.removeChild(a)}var Pe={disableCSSInjection:!1,_enabled:"undefined"!=typeof window&&"undefined"!=typeof document,_ensureLoaded:function(t){var e,n,i,r,a,o;this.disableCSSInjection||(n=(e=t.getRootNode?t.getRootNode():document).host?e:document.head,r=ce,(o=(i=n)[fe]||(i[fe]={})).containsStyles||(o.containsStyles=!0,r="/* Chart.js */\n"+r,(a=document.createElement("style")).setAttribute("type","text/css"),a.appendChild(document.createTextNode(r)),i.appendChild(a)))},acquireContext:function(t,e){"string"==typeof t?t=document.getElementById(t):t.length&&(t=t[0]),t&&t.canvas&&(t=t.canvas);var n,i,r,a,o,s,l,u=t&&t.getContext&&t.getContext("2d");return u&&u.canvas===t?(this._ensureLoaded(t),i=e,o=(n=t).style,s=n.getAttribute("height"),l=n.getAttribute("width"),n[fe]={initial:{height:s,width:l,style:{display:o.display,height:o.height,width:o.width}}},o.display=o.display||"block",null!==l&&""!==l||void 0!==(r=xe(n,"width"))&&(n.width=r),null!==s&&""!==s||(""===n.style.height?n.height=n.width/(i.options.aspectRatio||2):(a=xe(n,"height"),void 0!==r&&(n.height=a))),u):null},releaseContext:function(t){var n,i=t.canvas;i[fe]&&(n=i[fe].initial,["height","width"].forEach(function(t){var e=n[t];B.isNullOrUndef(e)?i.removeAttribute(t):i.setAttribute(t,e)}),B.each(n.style||{},function(t,e){i.style[e]=t}),i.width,delete i[fe])},addEventListener:function(a,t,o){var e,n=a.canvas;"resize"!==t?we(n,t,((e=o[fe]||(o[fe]={})).proxies||(e.proxies={}))[a.id+"_"+t]=function(t){var e,n,i,r;o((n=a,i=be[(e=t).type]||e.type,r=B.getRelativePosition(e,n),Me(i,n,r.x,r.y,e)))}):De(n,o,a)},removeEventListener:function(t,e,n){var i,r=t.canvas;"resize"!==e?(i=((n[fe]||{}).proxies||{})[t.id+"_"+e])&&ke(r,e,i):Ce(r)}};B.addEvent=we,B.removeEvent=ke;var Te=Pe._enabled?Pe:{acquireContext:function(t){return t&&t.canvas&&(t=t.canvas),t&&t.getContext("2d")||null}},Oe=B.extend({initialize:function(){},acquireContext:function(){},releaseContext:function(){},addEventListener:function(){},removeEventListener:function(){}},Te);Y._set("global",{plugins:{}});var Ae={_plugins:[],_cacheId:0,register:function(t){var e=this._plugins;[].concat(t).forEach(function(t){-1===e.indexOf(t)&&e.push(t)}),this._cacheId++},unregister:function(t){var n=this._plugins;[].concat(t).forEach(function(t){var e=n.indexOf(t);-1!==e&&n.splice(e,1)}),this._cacheId++},clear:function(){this._plugins=[],this._cacheId++},count:function(){return this._plugins.length},getAll:function(){return this._plugins},notify:function(t,e,n){for(var i,r,a,o,s=this.descriptors(t),l=s.length,u=0;u<l;++u)if("function"==typeof(o=(r=(i=s[u]).plugin)[e])&&((a=[t].concat(n||[])).push(i.options),!1===o.apply(r,a)))return!1;return!0},descriptors:function(t){var e=t.$plugins||(t.$plugins={});if(e.id===this._cacheId)return e.descriptors;var i=[],r=[],n=t&&t.config||{},a=n.options&&n.options.plugins||{};return this._plugins.concat(n.plugins||[]).forEach(function(t){var e,n;-1===i.indexOf(t)&&(e=t.id,!1!==(n=a[e])&&(!0===n&&(n=B.clone(Y.global.plugins[e])),i.push(t),r.push({plugin:t,options:n||{}})))}),e.descriptors=r,e.id=this._cacheId,r},_invalidate:function(t){delete t.$plugins}},Fe={constructors:{},defaults:{},registerScaleType:function(t,e,n){this.constructors[t]=e,this.defaults[t]=B.clone(n)},getScaleConstructor:function(t){return this.constructors.hasOwnProperty(t)?this.constructors[t]:void 0},getScaleDefaults:function(t){return this.defaults.hasOwnProperty(t)?B.merge(Object.create(null),[Y.scale,this.defaults[t]]):{}},updateScaleDefaults:function(t,e){this.defaults.hasOwnProperty(t)&&(this.defaults[t]=B.extend(this.defaults[t],e))},addScalesToLayout:function(e){B.each(e.scales,function(t){t.fullWidth=t.options.fullWidth,t.position=t.options.position,t.weight=t.options.weight,he.addBox(e,t)})}},Ie=B.valueOrDefault,Le=B.rtl.getRtlAdapter;Y._set("global",{tooltips:{enabled:!0,custom:null,mode:"nearest",position:"average",intersect:!0,backgroundColor:"rgba(0,0,0,0.8)",titleFontStyle:"bold",titleSpacing:2,titleMarginBottom:6,titleFontColor:"#fff",titleAlign:"left",bodySpacing:2,bodyFontColor:"#fff",bodyAlign:"left",footerFontStyle:"bold",footerSpacing:2,footerMarginTop:6,footerFontColor:"#fff",footerAlign:"left",yPadding:6,xPadding:6,caretPadding:2,caretSize:5,cornerRadius:6,multiKeyBackground:"#fff",displayColors:!0,borderColor:"rgba(0,0,0,0)",borderWidth:0,callbacks:{beforeTitle:B.noop,title:function(t,e){var n,i="",r=e.labels,a=r?r.length:0;return 0<t.length&&((n=t[0]).label?i=n.label:n.xLabel?i=n.xLabel:0<a&&n.index<a&&(i=r[n.index])),i},afterTitle:B.noop,beforeBody:B.noop,beforeLabel:B.noop,label:function(t,e){var n=e.datasets[t.datasetIndex].label||"";return n&&(n+=": "),B.isNullOrUndef(t.value)?n+=t.yLabel:n+=t.value,n},labelColor:function(t,e){var n=e.getDatasetMeta(t.datasetIndex).data[t.index]._view;return{borderColor:n.borderColor,backgroundColor:n.backgroundColor}},labelTextColor:function(){return this._options.bodyFontColor},afterLabel:B.noop,afterBody:B.noop,beforeFooter:B.noop,footer:B.noop,afterFooter:B.noop}}});var Re={average:function(t){if(!t.length)return!1;for(var e=0,n=0,i=0,r=0,a=t.length;r<a;++r){var o,s=t[r];s&&s.hasValue()&&(e+=(o=s.tooltipPosition()).x,n+=o.y,++i)}return{x:e/i,y:n/i}},nearest:function(t,e){for(var n,i,r=e.x,a=e.y,o=Number.POSITIVE_INFINITY,s=0,l=t.length;s<l;++s){var u,d,h=t[s];h&&h.hasValue()&&(u=h.getCenterPoint(),(d=B.distanceBetweenPoints(e,u))<o&&(o=d,n=h))}return n&&(r=(i=n.tooltipPosition()).x,a=i.y),{x:r,y:a}}};function Ne(t,e){return e&&(B.isArray(e)?Array.prototype.push.apply(t,e):t.push(e)),t}function We(t){return("string"==typeof t||t instanceof String)&&-1<t.indexOf("\n")?t.split("\n"):t}function Ye(t){var e=Y.global;return{xPadding:t.xPadding,yPadding:t.yPadding,xAlign:t.xAlign,yAlign:t.yAlign,rtl:t.rtl,textDirection:t.textDirection,bodyFontColor:t.bodyFontColor,_bodyFontFamily:Ie(t.bodyFontFamily,e.defaultFontFamily),_bodyFontStyle:Ie(t.bodyFontStyle,e.defaultFontStyle),_bodyAlign:t.bodyAlign,bodyFontSize:Ie(t.bodyFontSize,e.defaultFontSize),bodySpacing:t.bodySpacing,titleFontColor:t.titleFontColor,_titleFontFamily:Ie(t.titleFontFamily,e.defaultFontFamily),_titleFontStyle:Ie(t.titleFontStyle,e.defaultFontStyle),titleFontSize:Ie(t.titleFontSize,e.defaultFontSize),_titleAlign:t.titleAlign,titleSpacing:t.titleSpacing,titleMarginBottom:t.titleMarginBottom,footerFontColor:t.footerFontColor,_footerFontFamily:Ie(t.footerFontFamily,e.defaultFontFamily),_footerFontStyle:Ie(t.footerFontStyle,e.defaultFontStyle),footerFontSize:Ie(t.footerFontSize,e.defaultFontSize),_footerAlign:t.footerAlign,footerSpacing:t.footerSpacing,footerMarginTop:t.footerMarginTop,caretSize:t.caretSize,cornerRadius:t.cornerRadius,backgroundColor:t.backgroundColor,opacity:0,legendColorBackground:t.multiKeyBackground,displayColors:t.displayColors,borderColor:t.borderColor,borderWidth:t.borderWidth}}function ze(t,e){var n=t._chart.ctx,i=2*e.yPadding,r=0,a=e.body,o=a.reduce(function(t,e){return t+e.before.length+e.lines.length+e.after.length},0);o+=e.beforeBody.length+e.afterBody.length;var s=e.title.length,l=e.footer.length,u=e.titleFontSize,d=e.bodyFontSize,h=e.footerFontSize;i+=s*u,i+=s?(s-1)*e.titleSpacing:0,i+=s?e.titleMarginBottom:0,i+=o*d,i+=o?(o-1)*e.bodySpacing:0,i+=l?e.footerMarginTop:0,i+=l*h,i+=l?(l-1)*e.footerSpacing:0;function c(t){r=Math.max(r,n.measureText(t).width+f)}var f=0;return n.font=B.fontString(u,e._titleFontStyle,e._titleFontFamily),B.each(e.title,c),n.font=B.fontString(d,e._bodyFontStyle,e._bodyFontFamily),B.each(e.beforeBody.concat(e.afterBody),c),f=e.displayColors?d+2:0,B.each(a,function(t){B.each(t.before,c),B.each(t.lines,c),B.each(t.after,c)}),f=0,n.font=B.fontString(h,e._footerFontStyle,e._footerFontFamily),B.each(e.footer,c),{width:r+=2*e.xPadding,height:i}}function Ve(t,e){return"center"===e?t.x+t.width/2:"right"===e?t.x+t.width-t.xPadding:t.x+t.xPadding}function Ee(t){return Ne([],We(t))}var He=$.extend({initialize:function(){this._model=Ye(this._options),this._lastActive=[]},getTitle:function(){var t=this._options.callbacks,e=t.beforeTitle.apply(this,arguments),n=t.title.apply(this,arguments),i=t.afterTitle.apply(this,arguments),r=Ne(r=[],We(e));return r=Ne(r,We(n)),r=Ne(r,We(i))},getBeforeBody:function(){return Ee(this._options.callbacks.beforeBody.apply(this,arguments))},getBody:function(t,n){var i=this,r=i._options.callbacks,a=[];return B.each(t,function(t){var e={before:[],lines:[],after:[]};Ne(e.before,We(r.beforeLabel.call(i,t,n))),Ne(e.lines,r.label.call(i,t,n)),Ne(e.after,We(r.afterLabel.call(i,t,n))),a.push(e)}),a},getAfterBody:function(){return Ee(this._options.callbacks.afterBody.apply(this,arguments))},getFooter:function(){var t=this._options.callbacks,e=t.beforeFooter.apply(this,arguments),n=t.footer.apply(this,arguments),i=t.afterFooter.apply(this,arguments),r=Ne(r=[],We(e));return r=Ne(r,We(n)),r=Ne(r,We(i))},update:function(t){var e,n,i,r,a,o,s,l,u,d,h,c,f,g,m,p,v,y,b,x,_,w=this,k=w._options,M=w._model,S=w._model=Ye(k),D=w._active,C=w._data,P={xAlign:M.xAlign,yAlign:M.yAlign},T={x:M.x,y:M.y},O={width:M.width,height:M.height},A={x:M.caretX,y:M.caretY};if(D.length){S.opacity=1;for(var F=[],I=[],A=Re[k.position].call(w,D,w._eventPosition),L=[],R=0,N=D.length;R<N;++R)L.push((g=D[R],_=x=b=p=m=void 0,m=g._xScale,p=g._yScale||g._scale,v=g._index,y=g._datasetIndex,b=g._chart.getDatasetMeta(y).controller,x=b._getIndexScale(),_=b._getValueScale(),{xLabel:m?m.getLabelForIndex(v,y):"",yLabel:p?p.getLabelForIndex(v,y):"",label:x?""+x.getLabelForIndex(v,y):"",value:_?""+_.getLabelForIndex(v,y):"",index:v,datasetIndex:y,x:g._model.x,y:g._model.y}));k.filter&&(L=L.filter(function(t){return k.filter(t,C)})),k.itemSort&&(L=L.sort(function(t,e){return k.itemSort(t,e,C)})),B.each(L,function(t){F.push(k.callbacks.labelColor.call(w,t,w._chart)),I.push(k.callbacks.labelTextColor.call(w,t,w._chart))}),S.title=w.getTitle(L,C),S.beforeBody=w.getBeforeBody(L,C),S.body=w.getBody(L,C),S.afterBody=w.getAfterBody(L,C),S.footer=w.getFooter(L,C),S.x=A.x,S.y=A.y,S.caretPadding=k.caretPadding,S.labelColors=F,S.labelTextColors=I,S.dataPoints=L,P=function(t,e){var n,i=t._model,r=t._chart,a=t._chart.chartArea,o="center",s="center";i.y<e.height?s="top":i.y>r.height-e.height&&(s="bottom");var l=(a.left+a.right)/2,u=(a.top+a.bottom)/2,d="center"===s?(n=function(t){return t<=l},function(t){return l<t}):(n=function(t){return t<=e.width/2},function(t){return t>=r.width-e.width/2}),h=function(t){return t+e.width+i.caretSize+i.caretPadding>r.width},c=function(t){return t-e.width-i.caretSize-i.caretPadding<0},f=function(t){return t<=u?"top":"bottom"};n(i.x)?(o="left",h(i.x)&&(o="center",s=f(i.y))):d(i.x)&&(o="right",c(i.x)&&(o="center",s=f(i.y)));var g=t._options;return{xAlign:g.xAlign?g.xAlign:o,yAlign:g.yAlign?g.yAlign:s}}(this,O=ze(this,S)),e=S,n=O,i=P,r=w._chart,a=e.x,o=e.y,s=e.caretSize,l=e.caretPadding,u=e.cornerRadius,d=i.xAlign,h=i.yAlign,c=s+l,f=u+l,"right"===d?a-=n.width:"center"===d&&((a-=n.width/2)+n.width>r.width&&(a=r.width-n.width),a<0&&(a=0)),"top"===h?o+=c:o-="bottom"===h?n.height+c:n.height/2,"center"===h?"left"===d?a+=c:"right"===d&&(a-=c):"left"===d?a-=f:"right"===d&&(a+=f),T={x:a,y:o}}else S.opacity=0;return S.xAlign=P.xAlign,S.yAlign=P.yAlign,S.x=T.x,S.y=T.y,S.width=O.width,S.height=O.height,S.caretX=A.x,S.caretY=A.y,w._model=S,t&&k.custom&&k.custom.call(w,S),w},drawCaret:function(t,e){var n=this._chart.ctx,i=this._view,r=this.getCaretPosition(t,e,i);n.lineTo(r.x1,r.y1),n.lineTo(r.x2,r.y2),n.lineTo(r.x3,r.y3)},getCaretPosition:function(t,e,n){var i,r,a,o,s,l,u,d=n.caretSize,h=n.cornerRadius,c=n.xAlign,f=n.yAlign,g=t.x,m=t.y,p=e.width,v=e.height;return"center"===f?(a=m+v/2,o="left"===c?(i=(u=g)-d,l=u,r=a+d,a-d):(i=(u=g+p)+d,l=u,r=a-d,a+d)):(l=(u="left"===c?(i=g+h+d)-d:"right"===c?(i=g+p-h-d)-d:(i=n.caretX)-d,i+d),"top"===f?(a=(r=m)-d,o=r):(a=(r=m+v)+d,o=r,s=l,l=u,u=s)),{x1:u,x2:i,x3:l,y1:r,y2:a,y3:o}},drawTitle:function(t,e,n){var i,r,a,o=e.title,s=o.length;if(s){var l=Le(e.rtl,e.x,e.width);for(t.x=Ve(e,e._titleAlign),n.textAlign=l.textAlign(e._titleAlign),n.textBaseline="middle",i=e.titleFontSize,r=e.titleSpacing,n.fillStyle=e.titleFontColor,n.font=B.fontString(i,e._titleFontStyle,e._titleFontFamily),a=0;a<s;++a)n.fillText(o[a],l.x(t.x),t.y+i/2),t.y+=i+r,a+1===s&&(t.y+=e.titleMarginBottom-r)}},drawBody:function(e,t,n){function i(t){n.fillText(t,x.x(e.x+y),e.y+f/2),e.y+=f+g}var r,a,o,s,l,u,d,h,c,f=t.bodyFontSize,g=t.bodySpacing,m=t._bodyAlign,p=t.body,v=t.displayColors,y=0,b=v?Ve(t,"left"):0,x=Le(t.rtl,t.x,t.width),_=x.textAlign(m);for(n.textAlign=m,n.textBaseline="middle",n.font=B.fontString(f,t._bodyFontStyle,t._bodyFontFamily),e.x=Ve(t,_),n.fillStyle=t.bodyFontColor,B.each(t.beforeBody,i),y=v&&"right"!==_?"center"===m?f/2+1:f+2:0,l=0,d=p.length;l<d;++l){for(r=p[l],a=t.labelTextColors[l],o=t.labelColors[l],n.fillStyle=a,B.each(r.before,i),u=0,h=(s=r.lines).length;u<h;++u){v&&(c=x.x(b),n.fillStyle=t.legendColorBackground,n.fillRect(x.leftForLtr(c,f),e.y,f,f),n.lineWidth=1,n.strokeStyle=o.borderColor,n.strokeRect(x.leftForLtr(c,f),e.y,f,f),n.fillStyle=o.backgroundColor,n.fillRect(x.leftForLtr(x.xPlus(c,1),f-2),e.y+1,f-2,f-2),n.fillStyle=a),i(s[u])}B.each(r.after,i)}y=0,B.each(t.afterBody,i),e.y-=g},drawFooter:function(t,e,n){var i,r,a=e.footer,o=a.length;if(o){var s=Le(e.rtl,e.x,e.width);for(t.x=Ve(e,e._footerAlign),t.y+=e.footerMarginTop,n.textAlign=s.textAlign(e._footerAlign),n.textBaseline="middle",i=e.footerFontSize,n.fillStyle=e.footerFontColor,n.font=B.fontString(i,e._footerFontStyle,e._footerFontFamily),r=0;r<o;++r)n.fillText(a[r],s.x(t.x),t.y+i/2),t.y+=i+e.footerSpacing}},drawBackground:function(t,e,n,i){n.fillStyle=e.backgroundColor,n.strokeStyle=e.borderColor,n.lineWidth=e.borderWidth;var r=e.xAlign,a=e.yAlign,o=t.x,s=t.y,l=i.width,u=i.height,d=e.cornerRadius;n.beginPath(),n.moveTo(o+d,s),"top"===a&&this.drawCaret(t,i),n.lineTo(o+l-d,s),n.quadraticCurveTo(o+l,s,o+l,s+d),"center"===a&&"right"===r&&this.drawCaret(t,i),n.lineTo(o+l,s+u-d),n.quadraticCurveTo(o+l,s+u,o+l-d,s+u),"bottom"===a&&this.drawCaret(t,i),n.lineTo(o+d,s+u),n.quadraticCurveTo(o,s+u,o,s+u-d),"center"===a&&"left"===r&&this.drawCaret(t,i),n.lineTo(o,s+d),n.quadraticCurveTo(o,s,o+d,s),n.closePath(),n.fill(),0<e.borderWidth&&n.stroke()},draw:function(){var t,e,n,i,r=this._chart.ctx,a=this._view;0!==a.opacity&&(t={width:a.width,height:a.height},e={x:a.x,y:a.y},n=Math.abs(a.opacity<.001)?0:a.opacity,i=a.title.length||a.beforeBody.length||a.body.length||a.afterBody.length||a.footer.length,this._options.enabled&&i&&(r.save(),r.globalAlpha=n,this.drawBackground(e,a,r,t),e.y+=a.yPadding,B.rtl.overrideTextDirection(r,a.textDirection),this.drawTitle(e,a,r),this.drawBody(e,a,r),this.drawFooter(e,a,r),B.rtl.restoreTextDirection(r,a.textDirection),r.restore()))},handleEvent:function(t){var e,n=this,i=n._options;return n._lastActive=n._lastActive||[],"mouseout"===t.type?n._active=[]:(n._active=n._chart.getElementsAtEventForMode(t,i.mode,i),i.reverse&&n._active.reverse()),(e=!B.arrayEquals(n._active,n._lastActive))&&(n._lastActive=n._active,(i.enabled||i.custom)&&(n._eventPosition={x:t.x,y:t.y},n.update(!0),n.pivot())),e}});He.positioners=Re;var Be=B.valueOrDefault;function je(){return B.merge(Object.create(null),[].slice.call(arguments),{merger:function(t,e,n,i){if("xAxes"===t||"yAxes"===t){var r,a,o,s=n[t].length;for(e[t]||(e[t]=[]),r=0;r<s;++r)o=n[t][r],a=Be(o.type,"xAxes"===t?"category":"linear"),r>=e[t].length&&e[t].push({}),!e[t][r].type||o.type&&o.type!==e[t][r].type?B.merge(e[t][r],[Fe.getScaleDefaults(a),o]):B.merge(e[t][r],o)}else B._merger(t,e,n,i)}})}function Ue(){return B.merge(Object.create(null),[].slice.call(arguments),{merger:function(t,e,n,i){var r=e[t]||Object.create(null),a=n[t];"scales"===t?e[t]=je(r,a):"scale"===t?e[t]=B.merge(r,[Fe.getScaleDefaults(a.type),a]):B._merger(t,e,n,i)}})}function Ge(t,e,n){for(var i,r=function(t){return t.id===i};i=e+n++,0<=B.findIndex(t,r););return i}function qe(t){return"top"===t||"bottom"===t}function Ze(n,i){return function(t,e){return t[n]===e[n]?t[i]-e[i]:t[n]-e[n]}}Y._set("global",{elements:{},events:["mousemove","mouseout","click","touchstart","touchmove"],hover:{onHover:null,mode:"nearest",intersect:!0,animationDuration:400},onClick:null,maintainAspectRatio:!0,responsive:!0,responsiveAnimationDuration:0});function $e(t,e){return this.construct(t,e),this}B.extend($e.prototype,{construct:function(t,e){var n,i,r=this;(i=(n=(n=e)||Object.create(null)).data=n.data||{}).datasets=i.datasets||[],i.labels=i.labels||[],n.options=Ue(Y.global,Y[n.type],n.options||{}),e=n;var a=Oe.acquireContext(t,e),o=a&&a.canvas,s=o&&o.height,l=o&&o.width;r.id=B.uid(),r.ctx=a,r.canvas=o,r.config=e,r.width=l,r.height=s,r.aspectRatio=s?l/s:null,r.options=e.options,r._bufferedRender=!1,r._layers=[],(r.chart=r).controller=r,$e.instances[r.id]=r,Object.defineProperty(r,"data",{get:function(){return r.config.data},set:function(t){r.config.data=t}}),a&&o?(r.initialize(),r.update()):console.error("Failed to create chart: can't acquire context from the given item")},initialize:function(){var t=this;return Ae.notify(t,"beforeInit"),B.retinaScale(t,t.options.devicePixelRatio),t.bindEvents(),t.options.responsive&&t.resize(!0),t.initToolTip(),Ae.notify(t,"afterInit"),t},clear:function(){return B.canvas.clear(this),this},stop:function(){return J.cancelAnimation(this),this},resize:function(t){var e,n=this,i=n.options,r=n.canvas,a=i.maintainAspectRatio&&n.aspectRatio||null,o=Math.max(0,Math.floor(B.getMaximumWidth(r))),s=Math.max(0,Math.floor(a?o/a:B.getMaximumHeight(r)));n.width===o&&n.height===s||(r.width=n.width=o,r.height=n.height=s,r.style.width=o+"px",r.style.height=s+"px",B.retinaScale(n,i.devicePixelRatio),t||(e={width:o,height:s},Ae.notify(n,"resize",[e]),i.onResize&&i.onResize(n,e),n.stop(),n.update({duration:i.responsiveAnimationDuration})))},ensureScalesHaveIDs:function(){var t=this.options,n=t.scales||{},e=t.scale;B.each(n.xAxes,function(t,e){t.id||(t.id=Ge(n.xAxes,"x-axis-",e))}),B.each(n.yAxes,function(t,e){t.id||(t.id=Ge(n.yAxes,"y-axis-",e))}),e&&(e.id=e.id||"scale")},buildOrUpdateScales:function(){var o=this,t=o.options,s=o.scales||{},e=[],l=Object.keys(s).reduce(function(t,e){return t[e]=!1,t},{});t.scales&&(e=e.concat((t.scales.xAxes||[]).map(function(t){return{options:t,dtype:"category",dposition:"bottom"}}),(t.scales.yAxes||[]).map(function(t){return{options:t,dtype:"linear",dposition:"left"}}))),t.scale&&e.push({options:t.scale,dtype:"radialLinear",isDefault:!0,dposition:"chartArea"}),B.each(e,function(t){var e=t.options,n=e.id,i=Be(e.type,t.dtype);qe(e.position)!==qe(t.dposition)&&(e.position=t.dposition),l[n]=!0;var r=null;if(n in s&&s[n].type===i)(r=s[n]).options=e,r.ctx=o.ctx,r.chart=o;else{var a=Fe.getScaleConstructor(i);if(!a)return;r=new a({id:n,type:i,options:e,ctx:o.ctx,chart:o}),s[r.id]=r}r.mergeTicksOptions(),t.isDefault&&(o.scale=r)}),B.each(l,function(t,e){t||delete s[e]}),o.scales=s,Fe.addScalesToLayout(this)},buildOrUpdateControllers:function(){for(var t=this,e=[],n=t.data.datasets,i=0,r=n.length;i<r;i++){var a=n[i],o=t.getDatasetMeta(i),s=a.type||t.config.type;if(o.type&&o.type!==s&&(t.destroyDatasetMeta(i),o=t.getDatasetMeta(i)),o.type=s,o.order=a.order||0,o.index=i,o.controller)o.controller.updateIndex(i),o.controller.linkScales();else{var l=$t[o.type];if(void 0===l)throw new Error('"'+o.type+'" is not a chart type.');o.controller=new l(t,i),e.push(o.controller)}}return e},resetElements:function(){var n=this;B.each(n.data.datasets,function(t,e){n.getDatasetMeta(e).controller.reset()},n)},reset:function(){this.resetElements(),this.tooltip.initialize()},update:function(t){var e,n,i=this;if(t&&"object"==typeof t||(t={duration:t,lazy:arguments[1]}),n=(e=i).options,B.each(e.scales,function(t){he.removeBox(e,t)}),n=Ue(Y.global,Y[e.config.type],n),e.options=e.config.options=n,e.ensureScalesHaveIDs(),e.buildOrUpdateScales(),e.tooltip._options=n.tooltips,e.tooltip.initialize(),Ae._invalidate(i),!1!==Ae.notify(i,"beforeUpdate")){i.tooltip._data=i.data;for(var r=i.buildOrUpdateControllers(),a=0,o=i.data.datasets.length;a<o;a++)i.getDatasetMeta(a).controller.buildOrUpdateElements();i.updateLayout(),i.options.animation&&i.options.animation.duration&&B.each(r,function(t){t.reset()}),i.updateDatasets(),i.tooltip.initialize(),i.lastActive=[],Ae.notify(i,"afterUpdate"),i._layers.sort(Ze("z","_idx")),i._bufferedRender?i._bufferedRequest={duration:t.duration,easing:t.easing,lazy:t.lazy}:i.render(t)}},updateLayout:function(){var e=this;!1!==Ae.notify(e,"beforeLayout")&&(he.update(this,this.width,this.height),e._layers=[],B.each(e.boxes,function(t){t._configure&&t._configure(),e._layers.push.apply(e._layers,t._layers())},e),e._layers.forEach(function(t,e){t._idx=e}),Ae.notify(e,"afterScaleUpdate"),Ae.notify(e,"afterLayout"))},updateDatasets:function(){if(!1!==Ae.notify(this,"beforeDatasetsUpdate")){for(var t=0,e=this.data.datasets.length;t<e;++t)this.updateDataset(t);Ae.notify(this,"afterDatasetsUpdate")}},updateDataset:function(t){var e=this.getDatasetMeta(t),n={meta:e,index:t};!1!==Ae.notify(this,"beforeDatasetUpdate",[n])&&(e.controller._update(),Ae.notify(this,"afterDatasetUpdate",[n]))},render:function(t){var e=this;t&&"object"==typeof t||(t={duration:t,lazy:arguments[1]});var n=e.options.animation,i=Be(t.duration,n&&n.duration),r=t.lazy;if(!1!==Ae.notify(e,"beforeRender")){var a,o=function(t){Ae.notify(e,"afterRender"),B.callback(n&&n.onComplete,[t],e)};return n&&i?(a=new K({numSteps:i/16.66,easing:t.easing||n.easing,render:function(t,e){var n=B.easing.effects[e.easing],i=e.currentStep,r=i/e.numSteps;t.draw(n(r),r,i)},onAnimationProgress:n.onProgress,onAnimationComplete:o}),J.addAnimation(e,a,i,r)):(e.draw(),o(new K({numSteps:0,chart:e}))),e}},draw:function(t){var e,n,i=this;if(i.clear(),B.isNullOrUndef(t)&&(t=1),i.transition(t),!(i.width<=0||i.height<=0)&&!1!==Ae.notify(i,"beforeDraw",[t])){for(n=i._layers,e=0;e<n.length&&n[e].z<=0;++e)n[e].draw(i.chartArea);for(i.drawDatasets(t);e<n.length;++e)n[e].draw(i.chartArea);i._drawTooltip(t),Ae.notify(i,"afterDraw",[t])}},transition:function(t){for(var e=0,n=(this.data.datasets||[]).length;e<n;++e)this.isDatasetVisible(e)&&this.getDatasetMeta(e).controller.transition(t);this.tooltip.transition(t)},_getSortedDatasetMetas:function(t){for(var e=[],n=0,i=(this.data.datasets||[]).length;n<i;++n)t&&!this.isDatasetVisible(n)||e.push(this.getDatasetMeta(n));return e.sort(Ze("order","index")),e},_getSortedVisibleDatasetMetas:function(){return this._getSortedDatasetMetas(!0)},drawDatasets:function(t){var e,n;if(!1!==Ae.notify(this,"beforeDatasetsDraw",[t])){for(n=(e=this._getSortedVisibleDatasetMetas()).length-1;0<=n;--n)this.drawDataset(e[n],t);Ae.notify(this,"afterDatasetsDraw",[t])}},drawDataset:function(t,e){var n={meta:t,index:t.index,easingValue:e};!1!==Ae.notify(this,"beforeDatasetDraw",[n])&&(t.controller.draw(e),Ae.notify(this,"afterDatasetDraw",[n]))},_drawTooltip:function(t){var e=this.tooltip,n={tooltip:e,easingValue:t};!1!==Ae.notify(this,"beforeTooltipDraw",[n])&&(e.draw(),Ae.notify(this,"afterTooltipDraw",[n]))},getElementAtEvent:function(t){return ne.modes.single(this,t)},getElementsAtEvent:function(t){return ne.modes.label(this,t,{intersect:!0})},getElementsAtXAxis:function(t){return ne.modes["x-axis"](this,t,{intersect:!0})},getElementsAtEventForMode:function(t,e,n){var i=ne.modes[e];return"function"==typeof i?i(this,t,n):[]},getDatasetAtEvent:function(t){return ne.modes.dataset(this,t,{intersect:!0})},getDatasetMeta:function(t){var e=this.data.datasets[t];return e._meta||(e._meta={}),e._meta[this.id]||(e._meta[this.id]={type:null,data:[],dataset:null,controller:null,hidden:null,xAxisID:null,yAxisID:null,order:e.order||0,index:t})},getVisibleDatasetCount:function(){for(var t=0,e=0,n=this.data.datasets.length;e<n;++e)this.isDatasetVisible(e)&&t++;return t},isDatasetVisible:function(t){var e=this.getDatasetMeta(t);return"boolean"==typeof e.hidden?!e.hidden:!this.data.datasets[t].hidden},generateLegend:function(){return this.options.legendCallback(this)},destroyDatasetMeta:function(t){var e=this.id,n=this.data.datasets[t],i=n._meta&&n._meta[e];i&&(i.controller.destroy(),delete n._meta[e])},destroy:function(){var t,e,n=this,i=n.canvas;for(n.stop(),t=0,e=n.data.datasets.length;t<e;++t)n.destroyDatasetMeta(t);i&&(n.unbindEvents(),B.canvas.clear(n),Oe.releaseContext(n.ctx),n.canvas=null,n.ctx=null),Ae.notify(n,"destroy"),delete $e.instances[n.id]},toBase64Image:function(){return this.canvas.toDataURL.apply(this.canvas,arguments)},initToolTip:function(){var t=this;t.tooltip=new He({_chart:t,_chartInstance:t,_data:t.data,_options:t.options.tooltips},t)},bindEvents:function(){var e=this,n=e._listeners={},i=function(){e.eventHandler.apply(e,arguments)};B.each(e.options.events,function(t){Oe.addEventListener(e,t,i),n[t]=i}),e.options.responsive&&(i=function(){e.resize()},Oe.addEventListener(e,"resize",i),n.resize=i)},unbindEvents:function(){var n=this,t=n._listeners;t&&(delete n._listeners,B.each(t,function(t,e){Oe.removeEventListener(n,e,t)}))},updateHoverStyle:function(t,e,n){for(var i,r=n?"set":"remove",a=0,o=t.length;a<o;++a)(i=t[a])&&this.getDatasetMeta(i._datasetIndex).controller[r+"HoverStyle"](i);"dataset"===e&&this.getDatasetMeta(t[0]._datasetIndex).controller["_"+r+"DatasetHoverStyle"]()},eventHandler:function(t){var e=this,n=e.tooltip;if(!1!==Ae.notify(e,"beforeEvent",[t])){e._bufferedRender=!0,e._bufferedRequest=null;var i=e.handleEvent(t);n&&(i=n._start?n.handleEvent(t):i|n.handleEvent(t)),Ae.notify(e,"afterEvent",[t]);var r=e._bufferedRequest;return r?e.render(r):i&&!e.animating&&(e.stop(),e.render({duration:e.options.hover.animationDuration,lazy:!0})),e._bufferedRender=!1,e._bufferedRequest=null,e}},handleEvent:function(t){var e,n=this,i=n.options||{},r=i.hover;return n.lastActive=n.lastActive||[],"mouseout"===t.type?n.active=[]:n.active=n.getElementsAtEventForMode(t,r.mode,r),B.callback(i.onHover||i.hover.onHover,[t.native,n.active],n),"mouseup"!==t.type&&"click"!==t.type||i.onClick&&i.onClick.call(n,t.native,n.active),n.lastActive.length&&n.updateHoverStyle(n.lastActive,r.mode,!1),n.active.length&&r.mode&&n.updateHoverStyle(n.active,r.mode,!0),e=!B.arrayEquals(n.active,n.lastActive),n.lastActive=n.active,e}}),$e.instances={};var Xe=$e;($e.Controller=$e).types={},B.configMerge=Ue,B.scaleMerge=je;function Ke(){throw new Error("This method is not implemented: either no adapter can be found or an incomplete integration was provided.")}function Je(t){this.options=t||{}}B.extend(Je.prototype,{formats:Ke,parse:Ke,format:Ke,add:Ke,diff:Ke,startOf:Ke,endOf:Ke,_create:function(t){return t}}),Je.override=function(t){B.extend(Je.prototype,t)};var Qe={_date:Je},tn={formatters:{values:function(t){return B.isArray(t)?t:""+t},linear:function(t,e,n){var i=3<n.length?n[2]-n[1]:n[1]-n[0];1<Math.abs(i)&&t!==Math.floor(t)&&(i=t-Math.floor(t));var r,a,o,s=B.log10(Math.abs(i));return 0!==t?Math.max(Math.abs(n[0]),Math.abs(n[n.length-1]))<1e-4?(r=B.log10(Math.abs(t)),a=Math.floor(r)-Math.floor(s),a=Math.max(Math.min(a,20),0),t.toExponential(a)):(o=-1*Math.floor(s),o=Math.max(Math.min(o,20),0),t.toFixed(o)):"0"},logarithmic:function(t,e,n){var i=t/Math.pow(10,Math.floor(B.log10(t)));return 0===t?"0":1==i||2==i||5==i||0===e||e===n.length-1?t.toExponential():""}}},en=B.isArray,nn=B.isNullOrUndef,rn=B.valueOrDefault,an=B.valueAtIndexOrDefault;function on(t,e,n,i){for(var r,a,o,s,l,u,d,h,c,f,g,m,p,v,y=n.length,b=[],x=[],_=[],w=0,k=0,M=0;M<y;++M){if(o=n[M].label,s=n[M].major?e.major:e.minor,t.font=l=s.string,u=i[l]=i[l]||{data:{},gc:[]},d=s.lineHeight,h=c=0,nn(o)||en(o)){if(en(o))for(r=0,a=o.length;r<a;++r)f=o[r],nn(f)||en(f)||(h=B.measureText(t,u.data,u.gc,h,f),c+=d)}else h=B.measureText(t,u.data,u.gc,h,o),c=d;b.push(h),x.push(c),_.push(d/2),w=Math.max(h,w),k=Math.max(c,k)}function S(t){return{width:b[t]||0,height:x[t]||0,offset:_[t]||0}}return p=i,v=y,B.each(p,function(t){var e,n=t.gc,i=n.length/2;if(v<i){for(e=0;e<i;++e)delete t.data[n[e]];n.splice(0,i)}}),g=b.indexOf(w),m=x.indexOf(k),{first:S(0),last:S(y-1),widest:S(g),highest:S(m)}}function sn(t){return t.drawTicks?t.tickMarkLength:0}function ln(t){var e,n;return t.display?(e=B.options._parseFont(t),n=B.options.toPadding(t.padding),e.lineHeight+n.height):0}function un(t,e){return B.extend(B.options._parseFont({fontFamily:rn(e.fontFamily,t.fontFamily),fontSize:rn(e.fontSize,t.fontSize),fontStyle:rn(e.fontStyle,t.fontStyle),lineHeight:rn(e.lineHeight,t.lineHeight)}),{color:B.options.resolve([e.fontColor,t.fontColor,Y.global.defaultFontColor])})}function dn(t){var e=un(t,t.minor);return{minor:e,major:t.major.enabled?un(t,t.major):e}}function hn(t){for(var e,n=[],i=0,r=t.length;i<r;++i)void 0!==(e=t[i])._index&&n.push(e);return n}function cn(t,e,n,i){var r,a,o,s,l=function(t){var e,n,i=t.length;if(i<2)return!1;for(n=t[0],e=1;e<i;++e)if(t[e]-t[e-1]!==n)return!1;return n}(t),u=(e.length-1)/i;if(!l)return Math.max(u,1);for(o=0,s=(r=B.math._factorize(l)).length-1;o<s;o++)if(u<(a=r[o]))return a;return Math.max(u,1)}function fn(t,e,n,i){var r,a,o,s,l=rn(n,0),u=Math.min(rn(i,t.length),t.length),d=0;for(e=Math.ceil(e),i&&(e=(r=i-n)/Math.floor(r/e)),s=l;s<0;)d++,s=Math.round(l+d*e);for(a=Math.max(l,0);a<u;a++)o=t[a],a===s?(o._index=a,d++,s=Math.round(l+d*e)):delete o.label}Y._set("scale",{display:!0,position:"left",offset:!1,gridLines:{display:!0,color:"rgba(0,0,0,0.1)",lineWidth:1,drawBorder:!0,drawOnChartArea:!0,drawTicks:!0,tickMarkLength:10,zeroLineWidth:1,zeroLineColor:"rgba(0,0,0,0.25)",zeroLineBorderDash:[],zeroLineBorderDashOffset:0,offsetGridLines:!1,borderDash:[],borderDashOffset:0},scaleLabel:{display:!1,labelString:"",padding:{top:4,bottom:4}},ticks:{beginAtZero:!1,minRotation:0,maxRotation:50,mirror:!1,padding:0,reverse:!1,display:!0,autoSkip:!0,autoSkipPadding:0,labelOffset:0,callback:tn.formatters.values,minor:{},major:{}}});var gn=$.extend({zeroLineIndex:0,getPadding:function(){return{left:this.paddingLeft||0,top:this.paddingTop||0,right:this.paddingRight||0,bottom:this.paddingBottom||0}},getTicks:function(){return this._ticks},_getLabels:function(){var t=this.chart.data;return this.options.labels||(this.isHorizontal()?t.xLabels:t.yLabels)||t.labels||[]},mergeTicksOptions:function(){},beforeUpdate:function(){B.callback(this.options.beforeUpdate,[this])},update:function(t,e,n){var i,r,a,o,s,l=this,u=l.options.ticks,d=u.sampleSize;if(l.beforeUpdate(),l.maxWidth=t,l.maxHeight=e,l.margins=B.extend({left:0,right:0,top:0,bottom:0},n),l._ticks=null,l.ticks=null,l._labelSizes=null,l._maxLabelLines=0,l.longestLabelWidth=0,l.longestTextCache=l.longestTextCache||{},l._gridLineItems=null,l._labelItems=null,l.beforeSetDimensions(),l.setDimensions(),l.afterSetDimensions(),l.beforeDataLimits(),l.determineDataLimits(),l.afterDataLimits(),l.beforeBuildTicks(),o=l.buildTicks()||[],(!(o=l.afterBuildTicks(o)||o)||!o.length)&&l.ticks)for(o=[],i=0,r=l.ticks.length;i<r;++i)o.push({value:l.ticks[i],major:!1});return s=d<(l._ticks=o).length,a=l._convertTicksToLabels(s?function(t,e){for(var n=[],i=t.length/e,r=0,a=t.length;r<a;r+=i)n.push(t[Math.floor(r)]);return n}(o,d):o),l._configure(),l.beforeCalculateTickRotation(),l.calculateTickRotation(),l.afterCalculateTickRotation(),l.beforeFit(),l.fit(),l.afterFit(),l._ticksToDraw=u.display&&(u.autoSkip||"auto"===u.source)?l._autoSkip(o):o,s&&(a=l._convertTicksToLabels(l._ticksToDraw)),l.ticks=a,l.afterUpdate(),l.minSize},_configure:function(){var t,e,n=this,i=n.options.ticks.reverse;n.isHorizontal()?(t=n.left,e=n.right):(t=n.top,e=n.bottom,i=!i),n._startPixel=t,n._endPixel=e,n._reversePixels=i,n._length=e-t},afterUpdate:function(){B.callback(this.options.afterUpdate,[this])},beforeSetDimensions:function(){B.callback(this.options.beforeSetDimensions,[this])},setDimensions:function(){var t=this;t.isHorizontal()?(t.width=t.maxWidth,t.left=0,t.right=t.width):(t.height=t.maxHeight,t.top=0,t.bottom=t.height),t.paddingLeft=0,t.paddingTop=0,t.paddingRight=0,t.paddingBottom=0},afterSetDimensions:function(){B.callback(this.options.afterSetDimensions,[this])},beforeDataLimits:function(){B.callback(this.options.beforeDataLimits,[this])},determineDataLimits:B.noop,afterDataLimits:function(){B.callback(this.options.afterDataLimits,[this])},beforeBuildTicks:function(){B.callback(this.options.beforeBuildTicks,[this])},buildTicks:B.noop,afterBuildTicks:function(t){var e=this;return en(t)&&t.length?B.callback(e.options.afterBuildTicks,[e,t]):(e.ticks=B.callback(e.options.afterBuildTicks,[e,e.ticks])||e.ticks,t)},beforeTickToLabelConversion:function(){B.callback(this.options.beforeTickToLabelConversion,[this])},convertTicksToLabels:function(){var t=this.options.ticks;this.ticks=this.ticks.map(t.userCallback||t.callback,this)},afterTickToLabelConversion:function(){B.callback(this.options.afterTickToLabelConversion,[this])},beforeCalculateTickRotation:function(){B.callback(this.options.beforeCalculateTickRotation,[this])},calculateTickRotation:function(){var t,e,n,i,r,a,o,s=this,l=s.options,u=l.ticks,d=s.getTicks().length,h=u.minRotation||0,c=u.maxRotation,f=h;!s._isVisible()||!u.display||c<=h||d<=1||!s.isHorizontal()?s.labelRotation=h:(e=(t=s._getLabelSizes()).widest.width,n=t.highest.height-t.highest.offset,i=Math.min(s.maxWidth,s.chart.width-e),(r=l.offset?s.maxWidth/d:i/(d-1))<e+6&&(r=i/(d-(l.offset?.5:1)),a=s.maxHeight-sn(l.gridLines)-u.padding-ln(l.scaleLabel),o=Math.sqrt(e*e+n*n),f=B.toDegrees(Math.min(Math.asin(Math.min((t.highest.height+6)/r,1)),Math.asin(Math.min(a/o,1))-Math.asin(n/o))),f=Math.max(h,Math.min(c,f))),s.labelRotation=f)},afterCalculateTickRotation:function(){B.callback(this.options.afterCalculateTickRotation,[this])},beforeFit:function(){B.callback(this.options.beforeFit,[this])},fit:function(){var t,e,n,i,r,a,o,s,l,u,d,h,c,f,g,m,p,v,y=this,b=y.minSize={width:0,height:0},x=y.chart,_=y.options,w=_.ticks,k=_.scaleLabel,M=_.gridLines,S=y._isVisible(),D="bottom"===_.position,C=y.isHorizontal();C?b.width=y.maxWidth:S&&(b.width=sn(M)+ln(k)),C?S&&(b.height=sn(M)+ln(k)):b.height=y.maxHeight,w.display&&S&&(t=dn(w),n=(e=y._getLabelSizes()).first,i=e.last,r=e.widest,a=e.highest,o=.4*t.minor.lineHeight,s=w.padding,C?(l=0!==y.labelRotation,u=B.toRadians(y.labelRotation),d=Math.cos(u),c=(h=Math.sin(u))*r.width+d*(a.height-(l?a.offset:0))+(l?0:o),b.height=Math.min(y.maxHeight,b.height+c+s),f=y.getPixelForTick(0)-y.left,g=y.right-y.getPixelForTick(y.getTicks().length-1),p=l?(m=D?d*n.width+h*n.offset:h*(n.height-n.offset),D?h*(i.height-i.offset):d*i.width+h*i.offset):(m=n.width/2,i.width/2),y.paddingLeft=Math.max((m-f)*y.width/(y.width-f),0)+3,y.paddingRight=Math.max((p-g)*y.width/(y.width-g),0)+3):(v=w.mirror?0:r.width+s+o,b.width=Math.min(y.maxWidth,b.width+v),y.paddingTop=n.height/2,y.paddingBottom=i.height/2)),y.handleMargins(),C?(y.width=y._length=x.width-y.margins.left-y.margins.right,y.height=b.height):(y.width=b.width,y.height=y._length=x.height-y.margins.top-y.margins.bottom)},handleMargins:function(){var t=this;t.margins&&(t.margins.left=Math.max(t.paddingLeft,t.margins.left),t.margins.top=Math.max(t.paddingTop,t.margins.top),t.margins.right=Math.max(t.paddingRight,t.margins.right),t.margins.bottom=Math.max(t.paddingBottom,t.margins.bottom))},afterFit:function(){B.callback(this.options.afterFit,[this])},isHorizontal:function(){var t=this.options.position;return"top"===t||"bottom"===t},isFullWidth:function(){return this.options.fullWidth},getRightValue:function(t){if(nn(t))return NaN;if(("number"==typeof t||t instanceof Number)&&!isFinite(t))return NaN;if(t)if(this.isHorizontal()){if(void 0!==t.x)return this.getRightValue(t.x)}else if(void 0!==t.y)return this.getRightValue(t.y);return t},_convertTicksToLabels:function(t){var e,n,i,r=this;for(r.ticks=t.map(function(t){return t.value}),r.beforeTickToLabelConversion(),e=r.convertTicksToLabels(t)||r.ticks,r.afterTickToLabelConversion(),n=0,i=t.length;n<i;++n)t[n].label=e[n];return e},_getLabelSizes:function(){var t=this,e=t._labelSizes;return e||(t._labelSizes=e=on(t.ctx,dn(t.options.ticks),t.getTicks(),t.longestTextCache),t.longestLabelWidth=e.widest.width),e},_parseValue:function(t){var e,n,i,r=en(t)?(e=+this.getRightValue(t[0]),n=+this.getRightValue(t[1]),i=Math.min(e,n),Math.max(e,n)):(e=void 0,i=n=t=+this.getRightValue(t));return{min:i,max:r,start:e,end:n}},_getScaleLabel:function(t){var e=this._parseValue(t);return void 0!==e.start?"["+e.start+", "+e.end+"]":+this.getRightValue(t)},getLabelForIndex:B.noop,getPixelForValue:B.noop,getValueForPixel:B.noop,getPixelForTick:function(t){var e=this.options.offset,n=this._ticks.length,i=1/Math.max(n-(e?0:1),1);return t<0||n-1<t?null:this.getPixelForDecimal(t*i+(e?i/2:0))},getPixelForDecimal:function(t){return this._reversePixels&&(t=1-t),this._startPixel+t*this._length},getDecimalForPixel:function(t){var e=(t-this._startPixel)/this._length;return this._reversePixels?1-e:e},getBasePixel:function(){return this.getPixelForValue(this.getBaseValue())},getBaseValue:function(){var t=this.min,e=this.max;return this.beginAtZero?0:t<0&&e<0?e:0<t&&0<e?t:0},_autoSkip:function(t){var e,n,i,r,a=this.options.ticks,o=this._length,s=a.maxTicksLimit||o/this._tickSize()+1,l=a.major.enabled?function(t){for(var e=[],n=0,i=t.length;n<i;n++)t[n].major&&e.push(n);return e}(t):[],u=l.length,d=l[0],h=l[u-1];if(s<u)return function(t,e,n){var i,r,a=0,o=e[0];for(n=Math.ceil(n),i=0;i<t.length;i++)r=t[i],i===o?(r._index=i,o=e[++a*n]):delete r.label}(t,l,u/s),hn(t);if(i=cn(l,t,0,s),0<u){for(e=0,n=u-1;e<n;e++)fn(t,i,l[e],l[e+1]);return r=1<u?(h-d)/(u-1):null,fn(t,i,B.isNullOrUndef(r)?0:d-r,d),fn(t,i,h,B.isNullOrUndef(r)?t.length:h+r),hn(t)}return fn(t,i),hn(t)},_tickSize:function(){var t=this.options.ticks,e=B.toRadians(this.labelRotation),n=Math.abs(Math.cos(e)),i=Math.abs(Math.sin(e)),r=this._getLabelSizes(),a=t.autoSkipPadding||0,o=r?r.widest.width+a:0,s=r?r.highest.height+a:0;return this.isHorizontal()?o*i<s*n?o/n:s/i:s*i<o*n?s/n:o/i},_isVisible:function(){var t,e,n,i=this.chart,r=this.options.display;if("auto"!==r)return!!r;for(t=0,e=i.data.datasets.length;t<e;++t)if(i.isDatasetVisible(t)&&((n=i.getDatasetMeta(t)).xAxisID===this.id||n.yAxisID===this.id))return!0;return!1},_computeGridLineItems:function(t){function e(t){return F(x,t,O)}var n,i,r,a,o,s,l,u,d,h,c,f,g,m,p,v,y,b=this,x=b.chart,_=b.options,w=_.gridLines,k=_.position,M=w.offsetGridLines,S=b.isHorizontal(),D=b._ticksToDraw,C=D.length+(M?1:0),P=sn(w),T=[],O=w.drawBorder?an(w.lineWidth,0,0):0,A=O/2,F=B._alignPixel;for("top"===k?(n=e(b.bottom),l=b.bottom-P,d=n-A,c=e(t.top)+A,g=t.bottom):"bottom"===k?(n=e(b.top),c=t.top,g=e(t.bottom)-A,l=n+A,d=b.top+P):"left"===k?(n=e(b.right),s=b.right-P,u=n-A,h=e(t.left)+A,f=t.right):(n=e(b.left),h=t.left,f=e(t.right)-A,s=n+A,u=b.left+P),i=0;i<C;++i)r=D[i]||{},nn(r.label)&&i<D.length||(y=i===b.zeroLineIndex&&_.offset===M?(m=w.zeroLineWidth,p=w.zeroLineColor,v=w.zeroLineBorderDash||[],w.zeroLineBorderDashOffset||0):(m=an(w.lineWidth,i,1),p=an(w.color,i,"rgba(0,0,0,0.1)"),v=w.borderDash||[],w.borderDashOffset||0),void 0!==(a=function(t,e,n){var i,r=t.getTicks().length,a=Math.min(e,r-1),o=t.getPixelForTick(a),s=t._startPixel,l=t._endPixel;if(!(n&&(i=1===r?Math.max(o-s,l-o):0===e?(t.getPixelForTick(1)-o)/2:(o-t.getPixelForTick(a-1))/2,(o+=a<e?i:-i)<s-1e-6||l+1e-6<o)))return o}(b,r._index||i,M))&&(o=F(x,a,m),S?s=u=h=f=o:l=d=c=g=o,T.push({tx1:s,ty1:l,tx2:u,ty2:d,x1:h,y1:c,x2:f,y2:g,width:m,color:p,borderDash:v,borderDashOffset:y})));return T.ticksLength=C,T.borderValue=n,T},_computeLabelItems:function(){for(var t,e,n,i,r,a,o,s,l,u=this,d=u.options,h=d.ticks,c=d.position,f=h.mirror,g=u.isHorizontal(),m=u._ticksToDraw,p=dn(h),v=h.padding,y=sn(d.gridLines),b=-B.toRadians(u.labelRotation),x=[],_="top"===c?(i=u.bottom-y-v,b?"left":"center"):"bottom"===c?(i=u.top+y+v,b?"right":"center"):"left"===c?(n=u.right-(f?0:y)-v,f?"left":"right"):(n=u.left+(f?0:y)+v,f?"right":"left"),w=0,k=m.length;w<k;++w)e=(t=m[w]).label,nn(e)||(r=u.getPixelForTick(t._index||w)+h.labelOffset,o=(a=t.major?p.major:p.minor).lineHeight,s=en(e)?e.length:1,l=g?(n=r,"top"===c?((b?1:.5)-s)*o:(b?0:.5)*o):(i=r,(1-s)*o/2),x.push({x:n,y:i,rotation:b,label:e,font:a,textOffset:l,textAlign:_}));return x},_drawGrid:function(t){var e=this,n=e.options.gridLines;if(n.display){for(var i,r,a,o,s,l,u,d,h,c,f=e.ctx,g=e.chart,m=B._alignPixel,p=n.drawBorder?an(n.lineWidth,0,0):0,v=e._gridLineItems||(e._gridLineItems=e._computeGridLineItems(t)),y=0,b=v.length;y<b;++y)i=(a=v[y]).width,r=a.color,i&&r&&(f.save(),f.lineWidth=i,f.strokeStyle=r,f.setLineDash&&(f.setLineDash(a.borderDash),f.lineDashOffset=a.borderDashOffset),f.beginPath(),n.drawTicks&&(f.moveTo(a.tx1,a.ty1),f.lineTo(a.tx2,a.ty2)),n.drawOnChartArea&&(f.moveTo(a.x1,a.y1),f.lineTo(a.x2,a.y2)),f.stroke(),f.restore());p&&(o=p,s=an(n.lineWidth,v.ticksLength-1,1),l=v.borderValue,e.isHorizontal()?(u=m(g,e.left,o)-o/2,d=m(g,e.right,s)+s/2,h=c=l):(h=m(g,e.top,o)-o/2,c=m(g,e.bottom,s)+s/2,u=d=l),f.lineWidth=p,f.strokeStyle=an(n.color,0),f.beginPath(),f.moveTo(u,h),f.lineTo(d,c),f.stroke())}},_drawLabels:function(){var t=this;if(t.options.ticks.display)for(var e,n,i,r,a,o,s=t.ctx,l=t._labelItems||(t._labelItems=t._computeLabelItems()),u=0,d=l.length;u<d;++u){if(r=(i=l[u]).font,s.save(),s.translate(i.x,i.y),s.rotate(i.rotation),s.font=r.string,s.fillStyle=r.color,s.textBaseline="middle",s.textAlign=i.textAlign,a=i.label,o=i.textOffset,en(a))for(e=0,n=a.length;e<n;++e)s.fillText(""+a[e],0,o),o+=r.lineHeight;else s.fillText(a,0,o);s.restore()}},_drawTitle:function(){var t,e,n,i,r,a,o,s,l,u=this,d=u.ctx,h=u.options,c=h.scaleLabel;c.display&&(t=rn(c.fontColor,Y.global.defaultFontColor),e=B.options._parseFont(c),n=B.options.toPadding(c.padding),i=e.lineHeight/2,r=h.position,l=0,u.isHorizontal()?(o=u.left+u.width/2,s="bottom"===r?u.bottom-i-n.bottom:u.top+i+n.top):(o=(a="left"===r)?u.left+i+n.top:u.right-i-n.top,s=u.top+u.height/2,l=a?-.5*Math.PI:.5*Math.PI),d.save(),d.translate(o,s),d.rotate(l),d.textAlign="center",d.textBaseline="middle",d.fillStyle=t,d.font=e.string,d.fillText(c.labelString,0,0),d.restore())},draw:function(t){this._isVisible()&&(this._drawGrid(t),this._drawTitle(),this._drawLabels())},_layers:function(){var t=this,e=t.options,n=e.ticks&&e.ticks.z||0,i=e.gridLines&&e.gridLines.z||0;return t._isVisible()&&n!==i&&t.draw===t._draw?[{z:i,draw:function(){t._drawGrid.apply(t,arguments),t._drawTitle.apply(t,arguments)}},{z:n,draw:function(){t._drawLabels.apply(t,arguments)}}]:[{z:n,draw:function(){t.draw.apply(t,arguments)}}]},_getMatchingVisibleMetas:function(e){var n=this,i=n.isHorizontal();return n.chart._getSortedVisibleDatasetMetas().filter(function(t){return(!e||t.type===e)&&(i?t.xAxisID===n.id:t.yAxisID===n.id)})}});gn.prototype._draw=gn.prototype.draw;var mn=gn,pn=B.isNullOrUndef,vn=mn.extend({determineDataLimits:function(){var t,e=this,n=e._getLabels(),i=e.options.ticks,r=i.min,a=i.max,o=0,s=n.length-1;void 0!==r&&0<=(t=n.indexOf(r))&&(o=t),void 0!==a&&0<=(t=n.indexOf(a))&&(s=t),e.minIndex=o,e.maxIndex=s,e.min=n[o],e.max=n[s]},buildTicks:function(){var t=this._getLabels(),e=this.minIndex,n=this.maxIndex;this.ticks=0===e&&n===t.length-1?t:t.slice(e,n+1)},getLabelForIndex:function(t,e){var n=this.chart;return n.getDatasetMeta(e).controller._getValueScaleId()===this.id?this.getRightValue(n.data.datasets[e].data[t]):this._getLabels()[t]},_configure:function(){var t=this,e=t.options.offset,n=t.ticks;mn.prototype._configure.call(t),t.isHorizontal()||(t._reversePixels=!t._reversePixels),n&&(t._startValue=t.minIndex-(e?.5:0),t._valueRange=Math.max(n.length-(e?0:1),1))},getPixelForValue:function(t,e,n){var i,r,a,o=this;return pn(e)||pn(n)||(t=o.chart.data.datasets[n].data[e]),pn(t)||(i=o.isHorizontal()?t.x:t.y),(void 0!==i||void 0!==t&&isNaN(e))&&(r=o._getLabels(),t=B.valueOrDefault(i,t),e=-1!==(a=r.indexOf(t))?a:e,isNaN(e)&&(e=t)),o.getPixelForDecimal((e-o._startValue)/o._valueRange)},getPixelForTick:function(t){var e=this.ticks;return t<0||t>e.length-1?null:this.getPixelForValue(e[t],t+this.minIndex)},getValueForPixel:function(t){var e=Math.round(this._startValue+this.getDecimalForPixel(t)*this._valueRange);return Math.min(Math.max(e,0),this.ticks.length-1)},getBasePixel:function(){return this.bottom}}),yn={position:"bottom"};vn._defaults=yn;var bn=B.noop,xn=B.isNullOrUndef;var _n=mn.extend({getRightValue:function(t){return"string"==typeof t?+t:mn.prototype.getRightValue.call(this,t)},handleTickRangeOptions:function(){var t,e,n=this,i=n.options.ticks;i.beginAtZero&&(t=B.sign(n.min),e=B.sign(n.max),t<0&&e<0?n.max=0:0<t&&0<e&&(n.min=0));var r=void 0!==i.min||void 0!==i.suggestedMin,a=void 0!==i.max||void 0!==i.suggestedMax;void 0!==i.min?n.min=i.min:void 0!==i.suggestedMin&&(null===n.min?n.min=i.suggestedMin:n.min=Math.min(n.min,i.suggestedMin)),void 0!==i.max?n.max=i.max:void 0!==i.suggestedMax&&(null===n.max?n.max=i.suggestedMax:n.max=Math.max(n.max,i.suggestedMax)),r!=a&&n.min>=n.max&&(r?n.max=n.min+1:n.min=n.max-1),n.min===n.max&&(n.max++,i.beginAtZero||n.min--)},getTickLimit:function(){var t,e=this.options.ticks,n=e.stepSize,i=e.maxTicksLimit;return n?t=Math.ceil(this.max/n)-Math.floor(this.min/n)+1:(t=this._computeTickLimit(),i=i||11),i&&(t=Math.min(i,t)),t},_computeTickLimit:function(){return Number.POSITIVE_INFINITY},handleDirectionalChanges:bn,buildTicks:function(){var t=this,e=t.options.ticks,n=t.getTickLimit(),i={maxTicks:n=Math.max(2,n),min:e.min,max:e.max,precision:e.precision,stepSize:B.valueOrDefault(e.fixedStepSize,e.stepSize)},r=t.ticks=function(t,e){var n,i,r,a,o=[],s=t.stepSize,l=s||1,u=t.maxTicks-1,d=t.min,h=t.max,c=t.precision,f=e.min,g=e.max,m=B.niceNum((g-f)/u/l)*l;if(m<1e-14&&xn(d)&&xn(h))return[f,g];u<(a=Math.ceil(g/m)-Math.floor(f/m))&&(m=B.niceNum(a*m/u/l)*l),s||xn(c)?n=Math.pow(10,B._decimalPlaces(m)):(n=Math.pow(10,c),m=Math.ceil(m*n)/n),i=Math.floor(f/m)*m,r=Math.ceil(g/m)*m,s&&(!xn(d)&&B.almostWhole(d/m,m/1e3)&&(i=d),!xn(h)&&B.almostWhole(h/m,m/1e3)&&(r=h)),a=(r-i)/m,a=B.almostEquals(a,Math.round(a),m/1e3)?Math.round(a):Math.ceil(a),i=Math.round(i*n)/n,r=Math.round(r*n)/n,o.push(xn(d)?i:d);for(var p=1;p<a;++p)o.push(Math.round((i+p*m)*n)/n);return o.push(xn(h)?r:h),o}(i,t);t.handleDirectionalChanges(),t.max=B.max(r),t.min=B.min(r),e.reverse?(r.reverse(),t.start=t.max,t.end=t.min):(t.start=t.min,t.end=t.max)},convertTicksToLabels:function(){var t=this;t.ticksAsNumbers=t.ticks.slice(),t.zeroLineIndex=t.ticks.indexOf(0),mn.prototype.convertTicksToLabels.call(t)},_configure:function(){var t,e=this,n=e.getTicks(),i=e.min,r=e.max;mn.prototype._configure.call(e),e.options.offset&&n.length&&(i-=t=(r-i)/Math.max(n.length-1,1)/2,r+=t),e._startValue=i,e._endValue=r,e._valueRange=r-i}}),wn={position:"left",ticks:{callback:tn.formatters.linear}};var kn=_n.extend({determineDataLimits:function(){var t,e,n,i,r=this,a=r.options,o=r.chart.data.datasets,s=r._getMatchingVisibleMetas(),l=a.stacked,u={},d=s.length;if(r.min=Number.POSITIVE_INFINITY,r.max=Number.NEGATIVE_INFINITY,void 0===l)for(t=0;!l&&t<d;++t)l=void 0!==(e=s[t]).stack;for(t=0;t<d;++t)n=o[(e=s[t]).index].data,l?function(t,e,n,i){for(var r,a,o,s,l,u=t.options,d=u.stacked,h=(r=e,a=d,s=[(o=n).type,void 0===a&&void 0===o.stack?o.index:"",o.stack].join("."),void 0===r[s]&&(r[s]={pos:[],neg:[]}),r[s]),c=h.pos,f=h.neg,g=i.length,m=0;m<g;++m)l=t._parseValue(i[m]),isNaN(l.min)||isNaN(l.max)||n.data[m].hidden||(c[m]=c[m]||0,f[m]=f[m]||0,u.relativePoints?c[m]=100:l.min<0||l.max<0?f[m]+=l.min:c[m]+=l.max)}(r,u,e,n):function(t,e,n){for(var i,r=n.length,a=0;a<r;++a)i=t._parseValue(n[a]),isNaN(i.min)||isNaN(i.max)||e.data[a].hidden||(t.min=Math.min(t.min,i.min),t.max=Math.max(t.max,i.max))}(r,e,n);B.each(u,function(t){i=t.pos.concat(t.neg),r.min=Math.min(r.min,B.min(i)),r.max=Math.max(r.max,B.max(i))}),r.min=B.isFinite(r.min)&&!isNaN(r.min)?r.min:0,r.max=B.isFinite(r.max)&&!isNaN(r.max)?r.max:1,r.handleTickRangeOptions()},_computeTickLimit:function(){var t;return this.isHorizontal()?Math.ceil(this.width/40):(t=B.options._parseFont(this.options.ticks),Math.ceil(this.height/t.lineHeight))},handleDirectionalChanges:function(){this.isHorizontal()||this.ticks.reverse()},getLabelForIndex:function(t,e){return this._getScaleLabel(this.chart.data.datasets[e].data[t])},getPixelForValue:function(t){return this.getPixelForDecimal((this.getRightValue(t)-this._startValue)/this._valueRange)},getValueForPixel:function(t){return this._startValue+this.getDecimalForPixel(t)*this._valueRange},getPixelForTick:function(t){var e=this.ticksAsNumbers;return t<0||t>e.length-1?null:this.getPixelForValue(e[t])}});kn._defaults=wn;var Mn=B.valueOrDefault,Sn=B.math.log10;var Dn={position:"left",ticks:{callback:tn.formatters.logarithmic}};function Cn(t,e){return B.isFinite(t)&&0<=t?t:e}var Pn=mn.extend({determineDataLimits:function(){var t,e,n,i,r=this,a=r.options,o=r.chart,s=o.data.datasets,l=r.isHorizontal();function u(t){return l?t.xAxisID===r.id:t.yAxisID===r.id}r.min=Number.POSITIVE_INFINITY,r.max=Number.NEGATIVE_INFINITY,r.minNotZero=Number.POSITIVE_INFINITY;var d=a.stacked;if(void 0===d)for(c=0;c<s.length;c++)if(t=o.getDatasetMeta(c),o.isDatasetVisible(c)&&u(t)&&void 0!==t.stack){d=!0;break}if(a.stacked||d){for(var h={},c=0;c<s.length;c++){var f=[(t=o.getDatasetMeta(c)).type,void 0===a.stacked&&void 0===t.stack?c:"",t.stack].join(".");if(o.isDatasetVisible(c)&&u(t))for(void 0===h[f]&&(h[f]=[]),n=0,i=(e=s[c].data).length;n<i;n++){var g=h[f],m=r._parseValue(e[n]);isNaN(m.min)||isNaN(m.max)||t.data[n].hidden||m.min<0||m.max<0||(g[n]=g[n]||0,g[n]+=m.max)}}B.each(h,function(t){var e,n;0<t.length&&(e=B.min(t),n=B.max(t),r.min=Math.min(r.min,e),r.max=Math.max(r.max,n))})}else for(c=0;c<s.length;c++)if(t=o.getDatasetMeta(c),o.isDatasetVisible(c)&&u(t))for(n=0,i=(e=s[c].data).length;n<i;n++)m=r._parseValue(e[n]),isNaN(m.min)||isNaN(m.max)||t.data[n].hidden||m.min<0||m.max<0||(r.min=Math.min(m.min,r.min),r.max=Math.max(m.max,r.max),0!==m.min&&(r.minNotZero=Math.min(m.min,r.minNotZero)));r.min=B.isFinite(r.min)?r.min:null,r.max=B.isFinite(r.max)?r.max:null,r.minNotZero=B.isFinite(r.minNotZero)?r.minNotZero:null,this.handleTickRangeOptions()},handleTickRangeOptions:function(){var t=this,e=t.options.ticks;t.min=Cn(e.min,t.min),t.max=Cn(e.max,t.max),t.min===t.max&&(0!==t.min&&null!==t.min?(t.min=Math.pow(10,Math.floor(Sn(t.min))-1),t.max=Math.pow(10,Math.floor(Sn(t.max))+1)):(t.min=1,t.max=10)),null===t.min&&(t.min=Math.pow(10,Math.floor(Sn(t.max))-1)),null===t.max&&(t.max=0!==t.min?Math.pow(10,Math.floor(Sn(t.min))+1):10),null===t.minNotZero&&(0<t.min?t.minNotZero=t.min:t.max<1?t.minNotZero=Math.pow(10,Math.floor(Sn(t.max))):t.minNotZero=1)},buildTicks:function(){var t=this,e=t.options.ticks,n=!t.isHorizontal(),i={min:Cn(e.min),max:Cn(e.max)},r=t.ticks=function(t,e){var n,i,r=[],a=Mn(t.min,Math.pow(10,Math.floor(Sn(e.min)))),o=Math.floor(Sn(e.max)),s=Math.ceil(e.max/Math.pow(10,o));0===a?(n=Math.floor(Sn(e.minNotZero)),i=Math.floor(e.minNotZero/Math.pow(10,n)),r.push(a),a=i*Math.pow(10,n)):(n=Math.floor(Sn(a)),i=Math.floor(a/Math.pow(10,n)));for(var l=n<0?Math.pow(10,Math.abs(n)):1;r.push(a),10===++i&&(i=1,l=0<=++n?1:l),a=Math.round(i*Math.pow(10,n)*l)/l,n<o||n===o&&i<s;);var u=Mn(t.max,a);return r.push(u),r}(i,t);t.max=B.max(r),t.min=B.min(r),e.reverse?(n=!n,t.start=t.max,t.end=t.min):(t.start=t.min,t.end=t.max),n&&r.reverse()},convertTicksToLabels:function(){this.tickValues=this.ticks.slice(),mn.prototype.convertTicksToLabels.call(this)},getLabelForIndex:function(t,e){return this._getScaleLabel(this.chart.data.datasets[e].data[t])},getPixelForTick:function(t){var e=this.tickValues;return t<0||t>e.length-1?null:this.getPixelForValue(e[t])},_getFirstTickValue:function(t){var e=Math.floor(Sn(t));return Math.floor(t/Math.pow(10,e))*Math.pow(10,e)},_configure:function(){var t=this,e=t.min,n=0;mn.prototype._configure.call(t),0===e&&(e=t._getFirstTickValue(t.minNotZero),n=Mn(t.options.ticks.fontSize,Y.global.defaultFontSize)/t._length),t._startValue=Sn(e),t._valueOffset=n,t._valueRange=(Sn(t.max)-Sn(e))/(1-n)},getPixelForValue:function(t){var e=this,n=0;return(t=+e.getRightValue(t))>e.min&&0<t&&(n=(Sn(t)-e._startValue)/e._valueRange+e._valueOffset),e.getPixelForDecimal(n)},getValueForPixel:function(t){var e=this,n=e.getDecimalForPixel(t);return 0===n&&0===e.min?0:Math.pow(10,e._startValue+(n-e._valueOffset)*e._valueRange)}});Pn._defaults=Dn;var Tn=B.valueOrDefault,On=B.valueAtIndexOrDefault,An=B.options.resolve,Fn={display:!0,animate:!0,position:"chartArea",angleLines:{display:!0,color:"rgba(0,0,0,0.1)",lineWidth:1,borderDash:[],borderDashOffset:0},gridLines:{circular:!1},ticks:{showLabelBackdrop:!0,backdropColor:"rgba(255,255,255,0.75)",backdropPaddingY:2,backdropPaddingX:2,callback:tn.formatters.linear},pointLabels:{display:!0,fontSize:10,callback:function(t){return t}}};function In(t){var e=t.ticks;return e.display&&t.display?Tn(e.fontSize,Y.global.defaultFontSize)+2*e.backdropPaddingY:0}function Ln(t,e,n,i,r){return t===i||t===r?{start:e-n/2,end:e+n/2}:t<i||r<t?{start:e-n,end:e}:{start:e,end:e+n}}function Rn(t){var e,n,i=B.options._parseFont(t.options.pointLabels),r={l:0,r:t.width,t:0,b:t.height-t.paddingTop},a={};t.ctx.font=i.string,t._pointLabelSizes=[];for(var o,s,l,u=t.chart.data.labels.length,d=0;d<u;d++){n=t.getPointPosition(d,t.drawingArea+5),o=t.ctx,s=i.lineHeight,l=t.pointLabels[d],e=B.isArray(l)?{w:B.longestText(o,o.font,l),h:l.length*s}:{w:o.measureText(l).width,h:s},t._pointLabelSizes[d]=e;var h=t.getIndexAngle(d),c=B.toDegrees(h)%360,f=Ln(c,n.x,e.w,0,180),g=Ln(c,n.y,e.h,90,270);f.start<r.l&&(r.l=f.start,a.l=h),f.end>r.r&&(r.r=f.end,a.r=h),g.start<r.t&&(r.t=g.start,a.t=h),g.end>r.b&&(r.b=g.end,a.b=h)}t.setReductions(t.drawingArea,r,a)}function Nn(t){var e=t.ctx,n=t.options,i=n.pointLabels,r=In(n),a=t.getDistanceFromCenterForValue(n.ticks.reverse?t.min:t.max),o=B.options._parseFont(i);e.save(),e.font=o.string,e.textBaseline="middle";for(var s,l,u,d,h=t.chart.data.labels.length-1;0<=h;h--){var c=0===h?r/2:0,f=t.getPointPosition(h,a+c+5),g=On(i.fontColor,h,Y.global.defaultFontColor);e.fillStyle=g;var m=t.getIndexAngle(h),p=B.toDegrees(m);e.textAlign=0===(d=p)||180===d?"center":d<180?"left":"right",s=p,l=t._pointLabelSizes[h],u=f,90===s||270===s?u.y-=l.h/2:(270<s||s<90)&&(u.y-=l.h),function(t,e,n,i){var r,a,o=n.y+i/2;if(B.isArray(e))for(r=0,a=e.length;r<a;++r)t.fillText(e[r],n.x,o),o+=i;else t.fillText(e,n.x,o)}(e,t.pointLabels[h],f,o.lineHeight)}e.restore()}function Wn(t){return B.isNumber(t)?t:0}var Yn=_n.extend({setDimensions:function(){var t=this;t.width=t.maxWidth,t.height=t.maxHeight,t.paddingTop=In(t.options)/2,t.xCenter=Math.floor(t.width/2),t.yCenter=Math.floor((t.height-t.paddingTop)/2),t.drawingArea=Math.min(t.height-t.paddingTop,t.width)/2},determineDataLimits:function(){var r=this,n=r.chart,a=Number.POSITIVE_INFINITY,o=Number.NEGATIVE_INFINITY;B.each(n.data.datasets,function(t,e){var i;n.isDatasetVisible(e)&&(i=n.getDatasetMeta(e),B.each(t.data,function(t,e){var n=+r.getRightValue(t);isNaN(n)||i.data[e].hidden||(a=Math.min(n,a),o=Math.max(n,o))}))}),r.min=a===Number.POSITIVE_INFINITY?0:a,r.max=o===Number.NEGATIVE_INFINITY?0:o,r.handleTickRangeOptions()},_computeTickLimit:function(){return Math.ceil(this.drawingArea/In(this.options))},convertTicksToLabels:function(){var e=this;_n.prototype.convertTicksToLabels.call(e),e.pointLabels=e.chart.data.labels.map(function(){var t=B.callback(e.options.pointLabels.callback,arguments,e);return t||0===t?t:""})},getLabelForIndex:function(t,e){return+this.getRightValue(this.chart.data.datasets[e].data[t])},fit:function(){var t=this.options;t.display&&t.pointLabels.display?Rn(this):this.setCenterPoint(0,0,0,0)},setReductions:function(t,e,n){var i=this,r=e.l/Math.sin(n.l),a=Math.max(e.r-i.width,0)/Math.sin(n.r),o=-e.t/Math.cos(n.t),s=-Math.max(e.b-(i.height-i.paddingTop),0)/Math.cos(n.b),r=Wn(r),a=Wn(a),o=Wn(o),s=Wn(s);i.drawingArea=Math.min(Math.floor(t-(r+a)/2),Math.floor(t-(o+s)/2)),i.setCenterPoint(r,a,o,s)},setCenterPoint:function(t,e,n,i){var r=this,a=r.width-e-r.drawingArea,o=t+r.drawingArea,s=n+r.drawingArea,l=r.height-r.paddingTop-i-r.drawingArea;r.xCenter=Math.floor((o+a)/2+r.left),r.yCenter=Math.floor((s+l)/2+r.top+r.paddingTop)},getIndexAngle:function(t){var e=this.chart,n=(t*(360/e.data.labels.length)+((e.options||{}).startAngle||0))%360;return(n<0?360+n:n)*Math.PI*2/360},getDistanceFromCenterForValue:function(t){var e=this;if(B.isNullOrUndef(t))return NaN;var n=e.drawingArea/(e.max-e.min);return e.options.ticks.reverse?(e.max-t)*n:(t-e.min)*n},getPointPosition:function(t,e){var n=this.getIndexAngle(t)-Math.PI/2;return{x:Math.cos(n)*e+this.xCenter,y:Math.sin(n)*e+this.yCenter}},getPointPositionForValue:function(t,e){return this.getPointPosition(t,this.getDistanceFromCenterForValue(e))},getBasePosition:function(t){var e=this.min,n=this.max;return this.getPointPositionForValue(t||0,this.beginAtZero?0:e<0&&n<0?n:0<e&&0<n?e:0)},_drawGrid:function(){var t,n,e,i=this,r=i.ctx,a=i.options,o=a.gridLines,s=a.angleLines,l=Tn(s.lineWidth,o.lineWidth),u=Tn(s.color,o.color);if(a.pointLabels.display&&Nn(i),o.display&&B.each(i.ticks,function(t,e){0!==e&&(n=i.getDistanceFromCenterForValue(i.ticksAsNumbers[e]),function(t,e,n,i){var r,a=t.ctx,o=e.circular,s=t.chart.data.labels.length,l=On(e.color,i-1),u=On(e.lineWidth,i-1);if((o||s)&&l&&u){if(a.save(),a.strokeStyle=l,a.lineWidth=u,a.setLineDash&&(a.setLineDash(e.borderDash||[]),a.lineDashOffset=e.borderDashOffset||0),a.beginPath(),o)a.arc(t.xCenter,t.yCenter,n,0,2*Math.PI);else{r=t.getPointPosition(0,n),a.moveTo(r.x,r.y);for(var d=1;d<s;d++)r=t.getPointPosition(d,n),a.lineTo(r.x,r.y)}a.closePath(),a.stroke(),a.restore()}}(i,o,n,e))}),s.display&&l&&u){for(r.save(),r.lineWidth=l,r.strokeStyle=u,r.setLineDash&&(r.setLineDash(An([s.borderDash,o.borderDash,[]])),r.lineDashOffset=An([s.borderDashOffset,o.borderDashOffset,0])),t=i.chart.data.labels.length-1;0<=t;t--)n=i.getDistanceFromCenterForValue(a.ticks.reverse?i.min:i.max),e=i.getPointPosition(t,n),r.beginPath(),r.moveTo(i.xCenter,i.yCenter),r.lineTo(e.x,e.y),r.stroke();r.restore()}},_drawLabels:function(){var t,n,i,r,a,o=this,s=o.ctx,l=o.options.ticks;l.display&&(t=o.getIndexAngle(0),n=B.options._parseFont(l),i=Tn(l.fontColor,Y.global.defaultFontColor),s.save(),s.font=n.string,s.translate(o.xCenter,o.yCenter),s.rotate(t),s.textAlign="center",s.textBaseline="middle",B.each(o.ticks,function(t,e){0===e&&!l.reverse||(r=o.getDistanceFromCenterForValue(o.ticksAsNumbers[e]),l.showLabelBackdrop&&(a=s.measureText(t).width,s.fillStyle=l.backdropColor,s.fillRect(-a/2-l.backdropPaddingX,-r-n.size/2-l.backdropPaddingY,a+2*l.backdropPaddingX,n.size+2*l.backdropPaddingY)),s.fillStyle=i,s.fillText(t,0,-r))}),s.restore())},_drawTitle:B.noop});Yn._defaults=Fn;var zn=B._deprecated,Vn=B.options.resolve,En=B.valueOrDefault,Hn=Number.MIN_SAFE_INTEGER||-9007199254740991,Bn=Number.MAX_SAFE_INTEGER||9007199254740991,jn={millisecond:{common:!0,size:1,steps:1e3},second:{common:!0,size:1e3,steps:60},minute:{common:!0,size:6e4,steps:60},hour:{common:!0,size:36e5,steps:24},day:{common:!0,size:864e5,steps:30},week:{common:!1,size:6048e5,steps:4},month:{common:!0,size:2628e6,steps:12},quarter:{common:!1,size:7884e6,steps:4},year:{common:!0,size:3154e7}},Un=Object.keys(jn);function Gn(t,e){return t-e}function qn(t){return B.valueOrDefault(t.time.min,t.ticks.min)}function Zn(t){return B.valueOrDefault(t.time.max,t.ticks.max)}function $n(t,e,n,i){var r=function(t,e,n){for(var i,r,a,o=0,s=t.length-1;0<=o&&o<=s;){if(r=t[(i=o+s>>1)-1]||null,a=t[i],!r)return{lo:null,hi:a};if(a[e]<n)o=1+i;else{if(!(r[e]>n))return{lo:r,hi:a};s=i-1}}return{lo:a,hi:null}}(t,e,n),a=r.lo?r.hi?r.lo:t[t.length-2]:t[0],o=r.lo?r.hi?r.hi:t[t.length-1]:t[1],s=o[e]-a[e],l=s?(n-a[e])/s:0,u=(o[i]-a[i])*l;return a[i]+u}function Xn(t,e){var n=t._adapter,i=t.options.time,r=i.parser,a=r||i.format,o=e;return"function"==typeof r&&(o=r(o)),B.isFinite(o)||(o="string"==typeof a?n.parse(o,a):n.parse(o)),null!==o?+o:(r||"function"!=typeof a||(o=a(e),B.isFinite(o)||(o=n.parse(o))),o)}function Kn(t,e){if(B.isNullOrUndef(e))return null;var n=t.options.time,i=Xn(t,t.getRightValue(e));return null===i||n.round&&(i=+t._adapter.startOf(i,n.round)),i}function Jn(t,e,n,i){for(var r,a,o=Un.length,s=Un.indexOf(t);s<o-1;++s)if(a=(r=jn[Un[s]]).steps?r.steps:Bn,r.common&&Math.ceil((n-e)/(a*r.size))<=i)return Un[s];return Un[o-1]}function Qn(t,e,n){for(var i,r=[],a={},o=e.length,s=0;s<o;++s)a[i=e[s]]=s,r.push({value:i,major:!1});return 0!==o&&n?function(t,e,n,i){for(var r,a=t._adapter,o=+a.startOf(e[0].value,i),s=e[e.length-1].value,l=o;l<=s;l=+a.add(l,1,i))0<=(r=n[l])&&(e[r].major=!0);return e}(t,r,a,n):r}var ti=mn.extend({initialize:function(){this.mergeTicksOptions(),mn.prototype.initialize.call(this)},update:function(){var t=this.options,e=t.time||(t.time={}),n=this._adapter=new Qe._date(t.adapters.date);return zn("time scale",e.format,"time.format","time.parser"),zn("time scale",e.min,"time.min","ticks.min"),zn("time scale",e.max,"time.max","ticks.max"),B.mergeIf(e.displayFormats,n.formats()),mn.prototype.update.apply(this,arguments)},getRightValue:function(t){return t&&void 0!==t.t&&(t=t.t),mn.prototype.getRightValue.call(this,t)},determineDataLimits:function(){for(var t,e,n,i,r,a=this,o=a.chart,s=a._adapter,l=a.options,u=l.time.unit||"day",d=Bn,h=Hn,c=[],f=[],g=[],m=a._getLabels(),p=0,v=m.length;p<v;++p)g.push(Kn(a,m[p]));for(p=0,v=(o.data.datasets||[]).length;p<v;++p)if(o.isDatasetVisible(p))if(n=o.data.datasets[p].data,B.isObject(n[0]))for(f[p]=[],t=0,e=n.length;t<e;++t)i=Kn(a,n[t]),c.push(i),f[p][t]=i;else f[p]=g.slice(0),r||(c=c.concat(g),r=!0);else f[p]=[];g.length&&(d=Math.min(d,g[0]),h=Math.max(h,g[g.length-1])),c.length&&(c=1<v?function(t){for(var e,n={},i=[],r=0,a=t.length;r<a;++r)n[e=t[r]]||(n[e]=!0,i.push(e));return i}(c).sort(Gn):c.sort(Gn),d=Math.min(d,c[0]),h=Math.max(h,c[c.length-1])),d=Kn(a,qn(l))||d,h=Kn(a,Zn(l))||h,d=d===Bn?+s.startOf(Date.now(),u):d,h=h===Hn?+s.endOf(Date.now(),u)+1:h,a.min=Math.min(d,h),a.max=Math.max(d+1,h),a._table=[],a._timestamps={data:c,datasets:f,labels:g}},buildTicks:function(){var t,e,n,i,r,a,o,s,l,u=this,d=u.min,h=u.max,c=u.options,f=c.ticks,g=c.time,m=u._timestamps,p=[],v=u.getLabelCapacity(d),y=f.source,b=c.distribution,m="data"===y||"auto"===y&&"series"===b?m.data:"labels"===y?m.labels:function(t,e,n,i){var r,a=t._adapter,o=t.options,s=o.time,l=s.unit||Jn(s.minUnit,e,n,i),u=Vn([s.stepSize,s.unitStepSize,1]),d="week"===l&&s.isoWeekday,h=e,c=[];if(d&&(h=+a.startOf(h,"isoWeek",d)),h=+a.startOf(h,d?"day":l),a.diff(n,e,l)>1e5*u)throw e+" and "+n+" are too far apart with stepSize of "+u+" "+l;for(r=h;r<n;r=+a.add(r,u,l))c.push(r);return r!==n&&"ticks"!==o.bounds||c.push(r),c}(u,d,h,v);for("ticks"===c.bounds&&m.length&&(d=m[0],h=m[m.length-1]),d=Kn(u,qn(c))||d,h=Kn(u,Zn(c))||h,t=0,e=m.length;t<e;++t)d<=(n=m[t])&&n<=h&&p.push(n);return u.min=d,u.max=h,u._unit=g.unit||(f.autoSkip?Jn(g.minUnit,u.min,u.max,v):function(t,e,n,i,r){for(var a,o=Un.length-1;o>=Un.indexOf(n);o--)if(a=Un[o],jn[a].common&&t._adapter.diff(r,i,a)>=e-1)return a;return Un[n?Un.indexOf(n):0]}(u,p.length,g.minUnit,u.min,u.max)),u._majorUnit=f.major.enabled&&"year"!==u._unit?function(t){for(var e=Un.indexOf(t)+1,n=Un.length;e<n;++e)if(jn[Un[e]].common)return Un[e]}(u._unit):void 0,u._table=function(t,e,n,i){if("linear"===i||!t.length)return[{time:e,pos:0},{time:n,pos:1}];for(var r,a,o,s=[],l=[e],u=0,d=t.length;u<d;++u)e<(a=t[u])&&a<n&&l.push(a);for(l.push(n),u=0,d=l.length;u<d;++u)o=l[u+1],r=l[u-1],a=l[u],void 0!==r&&void 0!==o&&Math.round((o+r)/2)===a||s.push({time:a,pos:u/(d-1)});return s}(u._timestamps.data,d,h,b),u._offsets=(i=u._table,r=p,l=s=0,c.offset&&r.length&&(a=$n(i,"time",r[0],"pos"),s=1===r.length?1-a:($n(i,"time",r[1],"pos")-a)/2,o=$n(i,"time",r[r.length-1],"pos"),l=1===r.length?o:(o-$n(i,"time",r[r.length-2],"pos"))/2),{start:s,end:l,factor:1/(s+1+l)}),f.reverse&&p.reverse(),Qn(u,p,u._majorUnit)},getLabelForIndex:function(t,e){var n=this,i=n._adapter,r=n.chart.data,a=n.options.time,o=r.labels&&t<r.labels.length?r.labels[t]:"",s=r.datasets[e].data[t];return B.isObject(s)&&(o=n.getRightValue(s)),a.tooltipFormat?i.format(Xn(n,o),a.tooltipFormat):"string"==typeof o?o:i.format(Xn(n,o),a.displayFormats.datetime)},tickFormatFunction:function(t,e,n,i){var r=this._adapter,a=this.options,o=a.time.displayFormats,s=o[this._unit],l=this._majorUnit,u=o[l],d=n[e],h=a.ticks,c=l&&u&&d&&d.major,f=r.format(t,i||(c?u:s)),g=c?h.major:h.minor,m=Vn([g.callback,g.userCallback,h.callback,h.userCallback]);return m?m(f,e,n):f},convertTicksToLabels:function(t){for(var e=[],n=0,i=t.length;n<i;++n)e.push(this.tickFormatFunction(t[n].value,n,t));return e},getPixelForOffset:function(t){var e=this._offsets,n=$n(this._table,"time",t,"pos");return this.getPixelForDecimal((e.start+n)*e.factor)},getPixelForValue:function(t,e,n){var i=null;if(void 0!==e&&void 0!==n&&(i=this._timestamps.datasets[n][e]),null===i&&(i=Kn(this,t)),null!==i)return this.getPixelForOffset(i)},getPixelForTick:function(t){var e=this.getTicks();return 0<=t&&t<e.length?this.getPixelForOffset(e[t].value):null},getValueForPixel:function(t){var e=this._offsets,n=this.getDecimalForPixel(t)/e.factor-e.end,i=$n(this._table,"pos",n,"time");return this._adapter._create(i)},_getLabelSize:function(t){var e=this.options.ticks,n=this.ctx.measureText(t).width,i=B.toRadians(this.isHorizontal()?e.maxRotation:e.minRotation),r=Math.cos(i),a=Math.sin(i),o=En(e.fontSize,Y.global.defaultFontSize);return{w:n*r+o*a,h:n*a+o*r}},getLabelWidth:function(t){return this._getLabelSize(t).w},getLabelCapacity:function(t){var e=this.options.time,n=e.displayFormats,i=n[e.unit]||n.millisecond,r=this.tickFormatFunction(t,0,Qn(this,[t],this._majorUnit),i),a=this._getLabelSize(r),o=Math.floor(this.isHorizontal()?this.width/a.w:this.height/a.h);return this.options.offset&&o--,0<o?o:1}}),ei={position:"bottom",distribution:"linear",bounds:"data",adapters:{},time:{parser:!1,unit:!1,round:!1,displayFormat:!1,isoWeekday:!1,minUnit:"millisecond",displayFormats:{}},ticks:{autoSkip:!1,source:"auto",major:{enabled:!1}}};ti._defaults=ei;var ni={category:vn,linear:kn,logarithmic:Pn,radialLinear:Yn,time:ti},ii=t(function(za,t){za.exports=function(){var e,r;function u(){return e.apply(null,arguments)}function t(t){e=t}function o(t){return t instanceof Array||Object.prototype.toString.call(t)==="[object Array]"}function s(t){return t!=null&&Object.prototype.toString.call(t)==="[object Object]"}function l(t){if(Object.getOwnPropertyNames){return Object.getOwnPropertyNames(t).length===0}else{var e;for(e in t){if(t.hasOwnProperty(e)){return false}}return true}}function a(t){return t===void 0}function d(t){return typeof t==="number"||Object.prototype.toString.call(t)==="[object Number]"}function h(t){return t instanceof Date||Object.prototype.toString.call(t)==="[object Date]"}function n(t,e){var n=[],i;for(i=0;i<t.length;++i){n.push(e(t[i],i))}return n}function c(t,e){return Object.prototype.hasOwnProperty.call(t,e)}function f(t,e){for(var n in e){if(c(e,n)){t[n]=e[n]}}if(c(e,"toString")){t.toString=e.toString}if(c(e,"valueOf")){t.valueOf=e.valueOf}return t}function g(t,e,n,i){return Gn(t,e,n,i,true).utc()}function i(){return{empty:false,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:false,invalidMonth:null,invalidFormat:false,userInvalidated:false,iso:false,parsedDateParts:[],meridiem:null,rfc2822:false,weekdayMismatch:false}}function m(t){if(t._pf==null){t._pf=i()}return t._pf}if(Array.prototype.some){r=Array.prototype.some}else{r=function(t){var e=Object(this);var n=e.length>>>0;for(var i=0;i<n;i++){if(i in e&&t.call(this,e[i],i,e)){return true}}return false}}function p(t){if(t._isValid==null){var e=m(t);var n=r.call(e.parsedDateParts,function(t){return t!=null});var i=!isNaN(t._d.getTime())&&e.overflow<0&&!e.empty&&!e.invalidMonth&&!e.invalidWeekday&&!e.weekdayMismatch&&!e.nullInput&&!e.invalidFormat&&!e.userInvalidated&&(!e.meridiem||e.meridiem&&n);if(t._strict){i=i&&e.charsLeftOver===0&&e.unusedTokens.length===0&&e.bigHour===undefined}if(Object.isFrozen==null||!Object.isFrozen(t)){t._isValid=i}else{return i}}return t._isValid}function v(t){var e=g(NaN);if(t!=null){f(m(e),t)}else{m(e).userInvalidated=true}return e}var y=u.momentProperties=[];function b(t,e){var n,i,r;if(!a(e._isAMomentObject)){t._isAMomentObject=e._isAMomentObject}if(!a(e._i)){t._i=e._i}if(!a(e._f)){t._f=e._f}if(!a(e._l)){t._l=e._l}if(!a(e._strict)){t._strict=e._strict}if(!a(e._tzm)){t._tzm=e._tzm}if(!a(e._isUTC)){t._isUTC=e._isUTC}if(!a(e._offset)){t._offset=e._offset}if(!a(e._pf)){t._pf=m(e)}if(!a(e._locale)){t._locale=e._locale}if(y.length>0){for(n=0;n<y.length;n++){i=y[n];r=e[i];if(!a(r)){t[i]=r}}}return t}var x=false;function _(t){b(this,t);this._d=new Date(t._d!=null?t._d.getTime():NaN);if(!this.isValid()){this._d=new Date(NaN)}if(x===false){x=true;u.updateOffset(this);x=false}}function w(t){return t instanceof _||t!=null&&t._isAMomentObject!=null}function k(t){if(t<0){return Math.ceil(t)||0}else{return Math.floor(t)}}function M(t){var e=+t,n=0;if(e!==0&&isFinite(e)){n=k(e)}return n}function S(t,e,n){var i=Math.min(t.length,e.length),r=Math.abs(t.length-e.length),a=0,o;for(o=0;o<i;o++){if(n&&t[o]!==e[o]||!n&&M(t[o])!==M(e[o])){a++}}return a+r}function D(t){if(u.suppressDeprecationWarnings===false&&typeof console!=="undefined"&&console.warn){console.warn("Deprecation warning: "+t)}}function C(r,a){var o=true;return f(function(){if(u.deprecationHandler!=null){u.deprecationHandler(null,r)}if(o){var t=[];var e;for(var n=0;n<arguments.length;n++){e="";if(typeof arguments[n]==="object"){e+="\n["+n+"] ";for(var i in arguments[0]){e+=i+": "+arguments[0][i]+", "}e=e.slice(0,-2)}else{e=arguments[n]}t.push(e)}D(r+"\nArguments: "+Array.prototype.slice.call(t).join("")+"\n"+(new Error).stack);o=false}return a.apply(this,arguments)},a)}var P={},T;function O(t,e){if(u.deprecationHandler!=null){u.deprecationHandler(t,e)}if(!P[t]){D(e);P[t]=true}}function A(t){return t instanceof Function||Object.prototype.toString.call(t)==="[object Function]"}function F(t){var e,n;for(n in t){e=t[n];if(A(e)){this[n]=e}else{this["_"+n]=e}}this._config=t;this._dayOfMonthOrdinalParseLenient=new RegExp((this._dayOfMonthOrdinalParse.source||this._ordinalParse.source)+"|"+/\d{1,2}/.source)}function I(t,e){var n=f({},t),i;for(i in e){if(c(e,i)){if(s(t[i])&&s(e[i])){n[i]={};f(n[i],t[i]);f(n[i],e[i])}else if(e[i]!=null){n[i]=e[i]}else{delete n[i]}}}for(i in t){if(c(t,i)&&!c(e,i)&&s(t[i])){n[i]=f({},n[i])}}return n}function L(t){if(t!=null){this.set(t)}}if(u.suppressDeprecationWarnings=false,u.deprecationHandler=null,Object.keys){T=Object.keys}else{T=function(t){var e,n=[];for(e in t){if(c(t,e)){n.push(e)}}return n}}var R={sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"};function N(t,e,n){var i=this._calendar[t]||this._calendar["sameElse"];return A(i)?i.call(e,n):i}var W={LTS:"h:mm:ss A",LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"};function Y(t){var e=this._longDateFormat[t],n=this._longDateFormat[t.toUpperCase()];if(e||!n){return e}this._longDateFormat[t]=n.replace(/MMMM|MM|DD|dddd/g,function(t){return t.slice(1)});return this._longDateFormat[t]}var z="Invalid date";function V(){return this._invalidDate}var E="%d",H=/\d{1,2}/;function B(t){return this._ordinal.replace("%d",t)}var j={future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"};function U(t,e,n,i){var r=this._relativeTime[n];return A(r)?r(t,e,n,i):r.replace(/%d/i,t)}function G(t,e){var n=this._relativeTime[t>0?"future":"past"];return A(n)?n(e):n.replace(/%s/i,e)}var q={};function Z(t,e){var n=t.toLowerCase();q[n]=q[n+"s"]=q[e]=t}function $(t){return typeof t==="string"?q[t]||q[t.toLowerCase()]:undefined}function X(t){var e={},n,i;for(i in t){if(c(t,i)){n=$(i);if(n){e[n]=t[i]}}}return e}var K={};function J(t,e){K[t]=e}function Q(t){var e=[];for(var n in t){e.push({unit:n,priority:K[n]})}e.sort(function(t,e){return t.priority-e.priority});return e}function tt(t,e,n){var i=""+Math.abs(t),r=e-i.length,a=t>=0;return(a?n?"+":"":"-")+Math.pow(10,Math.max(0,r)).toString().substr(1)+i}var et=/(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,nt=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,it={},rt={};function at(t,e,n,i){var r=i;if(typeof i==="string"){r=function(){return this[i]()}}if(t){rt[t]=r}if(e){rt[e[0]]=function(){return tt(r.apply(this,arguments),e[1],e[2])}}if(n){rt[n]=function(){return this.localeData().ordinal(r.apply(this,arguments),t)}}}function ot(t){if(t.match(/\[[\s\S]/)){return t.replace(/^\[|\]$/g,"")}return t.replace(/\\/g,"")}function st(i){var r=i.match(et),t,a;for(t=0,a=r.length;t<a;t++){if(rt[r[t]]){r[t]=rt[r[t]]}else{r[t]=ot(r[t])}}return function(t){var e="",n;for(n=0;n<a;n++){e+=A(r[n])?r[n].call(t,i):r[n]}return e}}function lt(t,e){if(!t.isValid()){return t.localeData().invalidDate()}e=ut(e,t.localeData());it[e]=it[e]||st(e);return it[e](t)}function ut(t,e){var n=5;function i(t){return e.longDateFormat(t)||t}nt.lastIndex=0;while(n>=0&&nt.test(t)){t=t.replace(nt,i);nt.lastIndex=0;n-=1}return t}var dt=/\d/,ht=/\d\d/,ct=/\d{3}/,ft=/\d{4}/,gt=/[+-]?\d{6}/,mt=/\d\d?/,pt=/\d\d\d\d?/,vt=/\d\d\d\d\d\d?/,yt=/\d{1,3}/,bt=/\d{1,4}/,xt=/[+-]?\d{1,6}/,_t=/\d+/,wt=/[+-]?\d+/,kt=/Z|[+-]\d\d:?\d\d/gi,Mt=/Z|[+-]\d\d(?::?\d\d)?/gi,St=/[+-]?\d+(\.\d{1,3})?/,Dt=/[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i,Ct={};function Pt(t,n,i){Ct[t]=A(n)?n:function(t,e){return t&&i?i:n}}function Tt(t,e){if(!c(Ct,t)){return new RegExp(Ot(t))}return Ct[t](e._strict,e._locale)}function Ot(t){return At(t.replace("\\","").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,function(t,e,n,i,r){return e||n||i||r}))}function At(t){return t.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}var Ft={};function It(t,n){var e,i=n;if(typeof t==="string"){t=[t]}if(d(n)){i=function(t,e){e[n]=M(t)}}for(e=0;e<t.length;e++){Ft[t[e]]=i}}function Lt(t,r){It(t,function(t,e,n,i){n._w=n._w||{};r(t,n._w,n,i)})}function Rt(t,e,n){if(e!=null&&c(Ft,t)){Ft[t](e,n._a,n,t)}}var Nt=0,Wt=1,Yt=2,zt=3,Vt=4,Et=5,Ht=6,Bt=7,jt=8;function Ut(t){return Gt(t)?366:365}function Gt(t){return t%4===0&&t%100!==0||t%400===0}at("Y",0,0,function(){var t=this.year();return t<=9999?""+t:"+"+t}),at(0,["YY",2],0,function(){return this.year()%100}),at(0,["YYYY",4],0,"year"),at(0,["YYYYY",5],0,"year"),at(0,["YYYYYY",6,true],0,"year"),Z("year","y"),J("year",1),Pt("Y",wt),Pt("YY",mt,ht),Pt("YYYY",bt,ft),Pt("YYYYY",xt,gt),Pt("YYYYYY",xt,gt),It(["YYYYY","YYYYYY"],Nt),It("YYYY",function(t,e){e[Nt]=t.length===2?u.parseTwoDigitYear(t):M(t)}),It("YY",function(t,e){e[Nt]=u.parseTwoDigitYear(t)}),It("Y",function(t,e){e[Nt]=parseInt(t,10)}),u.parseTwoDigitYear=function(t){return M(t)+(M(t)>68?1900:2e3)};var qt=Xt("FullYear",true),Zt;function $t(){return Gt(this.year())}function Xt(e,n){return function(t){if(t!=null){Jt(this,e,t);u.updateOffset(this,n);return this}else{return Kt(this,e)}}}function Kt(t,e){return t.isValid()?t._d["get"+(t._isUTC?"UTC":"")+e]():NaN}function Jt(t,e,n){if(t.isValid()&&!isNaN(n)){if(e==="FullYear"&&Gt(t.year())&&t.month()===1&&t.date()===29){t._d["set"+(t._isUTC?"UTC":"")+e](n,t.month(),ne(n,t.month()))}else{t._d["set"+(t._isUTC?"UTC":"")+e](n)}}}function Qt(t){t=$(t);if(A(this[t])){return this[t]()}return this}function te(t,e){if(typeof t==="object"){t=X(t);var n=Q(t);for(var i=0;i<n.length;i++){this[n[i].unit](t[n[i].unit])}}else{t=$(t);if(A(this[t])){return this[t](e)}}return this}function ee(t,e){return(t%e+e)%e}if(Array.prototype.indexOf){Zt=Array.prototype.indexOf}else{Zt=function(t){var e;for(e=0;e<this.length;++e){if(this[e]===t){return e}}return-1}}function ne(t,e){if(isNaN(t)||isNaN(e)){return NaN}var n=ee(e,12);t+=(e-n)/12;return n===1?Gt(t)?29:28:31-n%7%2}at("M",["MM",2],"Mo",function(){return this.month()+1}),at("MMM",0,0,function(t){return this.localeData().monthsShort(this,t)}),at("MMMM",0,0,function(t){return this.localeData().months(this,t)}),Z("month","M"),J("month",8),Pt("M",mt),Pt("MM",mt,ht),Pt("MMM",function(t,e){return e.monthsShortRegex(t)}),Pt("MMMM",function(t,e){return e.monthsRegex(t)}),It(["M","MM"],function(t,e){e[Wt]=M(t)-1}),It(["MMM","MMMM"],function(t,e,n,i){var r=n._locale.monthsParse(t,i,n._strict);if(r!=null){e[Wt]=r}else{m(n).invalidMonth=t}});var ie=/D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/,re="January_February_March_April_May_June_July_August_September_October_November_December".split("_");function ae(t,e){if(!t){return o(this._months)?this._months:this._months["standalone"]}return o(this._months)?this._months[t.month()]:this._months[(this._months.isFormat||ie).test(e)?"format":"standalone"][t.month()]}var oe="Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_");function se(t,e){if(!t){return o(this._monthsShort)?this._monthsShort:this._monthsShort["standalone"]}return o(this._monthsShort)?this._monthsShort[t.month()]:this._monthsShort[ie.test(e)?"format":"standalone"][t.month()]}function le(t,e,n){var i,r,a,o=t.toLocaleLowerCase();if(!this._monthsParse){this._monthsParse=[];this._longMonthsParse=[];this._shortMonthsParse=[];for(i=0;i<12;++i){a=g([2e3,i]);this._shortMonthsParse[i]=this.monthsShort(a,"").toLocaleLowerCase();this._longMonthsParse[i]=this.months(a,"").toLocaleLowerCase()}}if(n){if(e==="MMM"){r=Zt.call(this._shortMonthsParse,o);return r!==-1?r:null}else{r=Zt.call(this._longMonthsParse,o);return r!==-1?r:null}}else{if(e==="MMM"){r=Zt.call(this._shortMonthsParse,o);if(r!==-1){return r}r=Zt.call(this._longMonthsParse,o);return r!==-1?r:null}else{r=Zt.call(this._longMonthsParse,o);if(r!==-1){return r}r=Zt.call(this._shortMonthsParse,o);return r!==-1?r:null}}}function ue(t,e,n){var i,r,a;if(this._monthsParseExact){return le.call(this,t,e,n)}if(!this._monthsParse){this._monthsParse=[];this._longMonthsParse=[];this._shortMonthsParse=[]}for(i=0;i<12;i++){r=g([2e3,i]);if(n&&!this._longMonthsParse[i]){this._longMonthsParse[i]=new RegExp("^"+this.months(r,"").replace(".","")+"$","i");this._shortMonthsParse[i]=new RegExp("^"+this.monthsShort(r,"").replace(".","")+"$","i")}if(!n&&!this._monthsParse[i]){a="^"+this.months(r,"")+"|^"+this.monthsShort(r,"");this._monthsParse[i]=new RegExp(a.replace(".",""),"i")}if(n&&e==="MMMM"&&this._longMonthsParse[i].test(t)){return i}else if(n&&e==="MMM"&&this._shortMonthsParse[i].test(t)){return i}else if(!n&&this._monthsParse[i].test(t)){return i}}}function de(t,e){var n;if(!t.isValid()){return t}if(typeof e==="string"){if(/^\d+$/.test(e)){e=M(e)}else{e=t.localeData().monthsParse(e);if(!d(e)){return t}}}n=Math.min(t.date(),ne(t.year(),e));t._d["set"+(t._isUTC?"UTC":"")+"Month"](e,n);return t}function he(t){if(t!=null){de(this,t);u.updateOffset(this,true);return this}else{return Kt(this,"Month")}}function ce(){return ne(this.year(),this.month())}var fe=Dt;function ge(t){if(this._monthsParseExact){if(!c(this,"_monthsRegex")){ve.call(this)}if(t){return this._monthsShortStrictRegex}else{return this._monthsShortRegex}}else{if(!c(this,"_monthsShortRegex")){this._monthsShortRegex=fe}return this._monthsShortStrictRegex&&t?this._monthsShortStrictRegex:this._monthsShortRegex}}var me=Dt;function pe(t){if(this._monthsParseExact){if(!c(this,"_monthsRegex")){ve.call(this)}if(t){return this._monthsStrictRegex}else{return this._monthsRegex}}else{if(!c(this,"_monthsRegex")){this._monthsRegex=me}return this._monthsStrictRegex&&t?this._monthsStrictRegex:this._monthsRegex}}function ve(){function t(t,e){return e.length-t.length}var e=[],n=[],i=[],r,a;for(r=0;r<12;r++){a=g([2e3,r]);e.push(this.monthsShort(a,""));n.push(this.months(a,""));i.push(this.months(a,""));i.push(this.monthsShort(a,""))}e.sort(t);n.sort(t);i.sort(t);for(r=0;r<12;r++){e[r]=At(e[r]);n[r]=At(n[r])}for(r=0;r<24;r++){i[r]=At(i[r])}this._monthsRegex=new RegExp("^("+i.join("|")+")","i");this._monthsShortRegex=this._monthsRegex;this._monthsStrictRegex=new RegExp("^("+n.join("|")+")","i");this._monthsShortStrictRegex=new RegExp("^("+e.join("|")+")","i")}function ye(t,e,n,i,r,a,o){var s;if(t<100&&t>=0){s=new Date(t+400,e,n,i,r,a,o);if(isFinite(s.getFullYear())){s.setFullYear(t)}}else{s=new Date(t,e,n,i,r,a,o)}return s}function be(t){var e;if(t<100&&t>=0){var n=Array.prototype.slice.call(arguments);n[0]=t+400;e=new Date(Date.UTC.apply(null,n));if(isFinite(e.getUTCFullYear())){e.setUTCFullYear(t)}}else{e=new Date(Date.UTC.apply(null,arguments))}return e}function xe(t,e,n){var i=7+e-n,r=(7+be(t,0,i).getUTCDay()-e)%7;return-r+i-1}function _e(t,e,n,i,r){var a=(7+n-i)%7,o=xe(t,i,r),s=1+7*(e-1)+a+o,l,u;if(s<=0){l=t-1;u=Ut(l)+s}else if(s>Ut(t)){l=t+1;u=s-Ut(t)}else{l=t;u=s}return{year:l,dayOfYear:u}}function we(t,e,n){var i=xe(t.year(),e,n),r=Math.floor((t.dayOfYear()-i-1)/7)+1,a,o;if(r<1){o=t.year()-1;a=r+ke(o,e,n)}else if(r>ke(t.year(),e,n)){a=r-ke(t.year(),e,n);o=t.year()+1}else{o=t.year();a=r}return{week:a,year:o}}function ke(t,e,n){var i=xe(t,e,n),r=xe(t+1,e,n);return(Ut(t)-i+r)/7}function Me(t){return we(t,this._week.dow,this._week.doy).week}at("w",["ww",2],"wo","week"),at("W",["WW",2],"Wo","isoWeek"),Z("week","w"),Z("isoWeek","W"),J("week",5),J("isoWeek",5),Pt("w",mt),Pt("ww",mt,ht),Pt("W",mt),Pt("WW",mt,ht),Lt(["w","ww","W","WW"],function(t,e,n,i){e[i.substr(0,1)]=M(t)});var Se={dow:0,doy:6};function De(){return this._week.dow}function Ce(){return this._week.doy}function Pe(t){var e=this.localeData().week(this);return t==null?e:this.add((t-e)*7,"d")}function Te(t){var e=we(this,1,4).week;return t==null?e:this.add((t-e)*7,"d")}function Oe(t,e){if(typeof t!=="string"){return t}if(!isNaN(t)){return parseInt(t,10)}t=e.weekdaysParse(t);if(typeof t==="number"){return t}return null}function Ae(t,e){if(typeof t==="string"){return e.weekdaysParse(t)%7||7}return isNaN(t)?null:t}function Fe(t,e){return t.slice(e,7).concat(t.slice(0,e))}at("d",0,"do","day"),at("dd",0,0,function(t){return this.localeData().weekdaysMin(this,t)}),at("ddd",0,0,function(t){return this.localeData().weekdaysShort(this,t)}),at("dddd",0,0,function(t){return this.localeData().weekdays(this,t)}),at("e",0,0,"weekday"),at("E",0,0,"isoWeekday"),Z("day","d"),Z("weekday","e"),Z("isoWeekday","E"),J("day",11),J("weekday",11),J("isoWeekday",11),Pt("d",mt),Pt("e",mt),Pt("E",mt),Pt("dd",function(t,e){return e.weekdaysMinRegex(t)}),Pt("ddd",function(t,e){return e.weekdaysShortRegex(t)}),Pt("dddd",function(t,e){return e.weekdaysRegex(t)}),Lt(["dd","ddd","dddd"],function(t,e,n,i){var r=n._locale.weekdaysParse(t,i,n._strict);if(r!=null){e.d=r}else{m(n).invalidWeekday=t}}),Lt(["d","e","E"],function(t,e,n,i){e[i]=M(t)});var Ie="Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_");function Le(t,e){var n=o(this._weekdays)?this._weekdays:this._weekdays[t&&t!==true&&this._weekdays.isFormat.test(e)?"format":"standalone"];return t===true?Fe(n,this._week.dow):t?n[t.day()]:n}var Re="Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_");function Ne(t){return t===true?Fe(this._weekdaysShort,this._week.dow):t?this._weekdaysShort[t.day()]:this._weekdaysShort}var We="Su_Mo_Tu_We_Th_Fr_Sa".split("_");function Ye(t){return t===true?Fe(this._weekdaysMin,this._week.dow):t?this._weekdaysMin[t.day()]:this._weekdaysMin}function ze(t,e,n){var i,r,a,o=t.toLocaleLowerCase();if(!this._weekdaysParse){this._weekdaysParse=[];this._shortWeekdaysParse=[];this._minWeekdaysParse=[];for(i=0;i<7;++i){a=g([2e3,1]).day(i);this._minWeekdaysParse[i]=this.weekdaysMin(a,"").toLocaleLowerCase();this._shortWeekdaysParse[i]=this.weekdaysShort(a,"").toLocaleLowerCase();this._weekdaysParse[i]=this.weekdays(a,"").toLocaleLowerCase()}}if(n){if(e==="dddd"){r=Zt.call(this._weekdaysParse,o);return r!==-1?r:null}else if(e==="ddd"){r=Zt.call(this._shortWeekdaysParse,o);return r!==-1?r:null}else{r=Zt.call(this._minWeekdaysParse,o);return r!==-1?r:null}}else{if(e==="dddd"){r=Zt.call(this._weekdaysParse,o);if(r!==-1){return r}r=Zt.call(this._shortWeekdaysParse,o);if(r!==-1){return r}r=Zt.call(this._minWeekdaysParse,o);return r!==-1?r:null}else if(e==="ddd"){r=Zt.call(this._shortWeekdaysParse,o);if(r!==-1){return r}r=Zt.call(this._weekdaysParse,o);if(r!==-1){return r}r=Zt.call(this._minWeekdaysParse,o);return r!==-1?r:null}else{r=Zt.call(this._minWeekdaysParse,o);if(r!==-1){return r}r=Zt.call(this._weekdaysParse,o);if(r!==-1){return r}r=Zt.call(this._shortWeekdaysParse,o);return r!==-1?r:null}}}function Ve(t,e,n){var i,r,a;if(this._weekdaysParseExact){return ze.call(this,t,e,n)}if(!this._weekdaysParse){this._weekdaysParse=[];this._minWeekdaysParse=[];this._shortWeekdaysParse=[];this._fullWeekdaysParse=[]}for(i=0;i<7;i++){r=g([2e3,1]).day(i);if(n&&!this._fullWeekdaysParse[i]){this._fullWeekdaysParse[i]=new RegExp("^"+this.weekdays(r,"").replace(".","\\.?")+"$","i");this._shortWeekdaysParse[i]=new RegExp("^"+this.weekdaysShort(r,"").replace(".","\\.?")+"$","i");this._minWeekdaysParse[i]=new RegExp("^"+this.weekdaysMin(r,"").replace(".","\\.?")+"$","i")}if(!this._weekdaysParse[i]){a="^"+this.weekdays(r,"")+"|^"+this.weekdaysShort(r,"")+"|^"+this.weekdaysMin(r,"");this._weekdaysParse[i]=new RegExp(a.replace(".",""),"i")}if(n&&e==="dddd"&&this._fullWeekdaysParse[i].test(t)){return i}else if(n&&e==="ddd"&&this._shortWeekdaysParse[i].test(t)){return i}else if(n&&e==="dd"&&this._minWeekdaysParse[i].test(t)){return i}else if(!n&&this._weekdaysParse[i].test(t)){return i}}}function Ee(t){if(!this.isValid()){return t!=null?this:NaN}var e=this._isUTC?this._d.getUTCDay():this._d.getDay();if(t!=null){t=Oe(t,this.localeData());return this.add(t-e,"d")}else{return e}}function He(t){if(!this.isValid()){return t!=null?this:NaN}var e=(this.day()+7-this.localeData()._week.dow)%7;return t==null?e:this.add(t-e,"d")}function Be(t){if(!this.isValid()){return t!=null?this:NaN}if(t!=null){var e=Ae(t,this.localeData());return this.day(this.day()%7?e:e-7)}else{return this.day()||7}}var je=Dt;function Ue(t){if(this._weekdaysParseExact){if(!c(this,"_weekdaysRegex")){Ke.call(this)}if(t){return this._weekdaysStrictRegex}else{return this._weekdaysRegex}}else{if(!c(this,"_weekdaysRegex")){this._weekdaysRegex=je}return this._weekdaysStrictRegex&&t?this._weekdaysStrictRegex:this._weekdaysRegex}}var Ge=Dt;function qe(t){if(this._weekdaysParseExact){if(!c(this,"_weekdaysRegex")){Ke.call(this)}if(t){return this._weekdaysShortStrictRegex}else{return this._weekdaysShortRegex}}else{if(!c(this,"_weekdaysShortRegex")){this._weekdaysShortRegex=Ge}return this._weekdaysShortStrictRegex&&t?this._weekdaysShortStrictRegex:this._weekdaysShortRegex}}var Ze=Dt,$e;function Xe(t){if(this._weekdaysParseExact){if(!c(this,"_weekdaysRegex")){Ke.call(this)}if(t){return this._weekdaysMinStrictRegex}else{return this._weekdaysMinRegex}}else{if(!c(this,"_weekdaysMinRegex")){this._weekdaysMinRegex=Ze}return this._weekdaysMinStrictRegex&&t?this._weekdaysMinStrictRegex:this._weekdaysMinRegex}}function Ke(){function t(t,e){return e.length-t.length}var e=[],n=[],i=[],r=[],a,o,s,l,u;for(a=0;a<7;a++){o=g([2e3,1]).day(a);s=this.weekdaysMin(o,"");l=this.weekdaysShort(o,"");u=this.weekdays(o,"");e.push(s);n.push(l);i.push(u);r.push(s);r.push(l);r.push(u)}e.sort(t);n.sort(t);i.sort(t);r.sort(t);for(a=0;a<7;a++){n[a]=At(n[a]);i[a]=At(i[a]);r[a]=At(r[a])}this._weekdaysRegex=new RegExp("^("+r.join("|")+")","i");this._weekdaysShortRegex=this._weekdaysRegex;this._weekdaysMinRegex=this._weekdaysRegex;this._weekdaysStrictRegex=new RegExp("^("+i.join("|")+")","i");this._weekdaysShortStrictRegex=new RegExp("^("+n.join("|")+")","i");this._weekdaysMinStrictRegex=new RegExp("^("+e.join("|")+")","i")}function Je(){return this.hours()%12||12}function Qe(){return this.hours()||24}function tn(t,e){at(t,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),e)})}function en(t,e){return e._meridiemParse}function nn(t){return(t+"").toLowerCase().charAt(0)==="p"}function rn(t,e,n){if(t>11){return n?"pm":"PM"}else{return n?"am":"AM"}}at("H",["HH",2],0,"hour"),at("h",["hh",2],0,Je),at("k",["kk",2],0,Qe),at("hmm",0,0,function(){return""+Je.apply(this)+tt(this.minutes(),2)}),at("hmmss",0,0,function(){return""+Je.apply(this)+tt(this.minutes(),2)+tt(this.seconds(),2)}),at("Hmm",0,0,function(){return""+this.hours()+tt(this.minutes(),2)}),at("Hmmss",0,0,function(){return""+this.hours()+tt(this.minutes(),2)+tt(this.seconds(),2)}),tn("a",true),tn("A",false),Z("hour","h"),J("hour",13),Pt("a",en),Pt("A",en),Pt("H",mt),Pt("h",mt),Pt("k",mt),Pt("HH",mt,ht),Pt("hh",mt,ht),Pt("kk",mt,ht),Pt("hmm",pt),Pt("hmmss",vt),Pt("Hmm",pt),Pt("Hmmss",vt),It(["H","HH"],zt),It(["k","kk"],function(t,e,n){var i=M(t);e[zt]=i===24?0:i}),It(["a","A"],function(t,e,n){n._isPm=n._locale.isPM(t);n._meridiem=t}),It(["h","hh"],function(t,e,n){e[zt]=M(t);m(n).bigHour=true}),It("hmm",function(t,e,n){var i=t.length-2;e[zt]=M(t.substr(0,i));e[Vt]=M(t.substr(i));m(n).bigHour=true}),It("hmmss",function(t,e,n){var i=t.length-4;var r=t.length-2;e[zt]=M(t.substr(0,i));e[Vt]=M(t.substr(i,2));e[Et]=M(t.substr(r));m(n).bigHour=true}),It("Hmm",function(t,e,n){var i=t.length-2;e[zt]=M(t.substr(0,i));e[Vt]=M(t.substr(i))}),It("Hmmss",function(t,e,n){var i=t.length-4;var r=t.length-2;e[zt]=M(t.substr(0,i));e[Vt]=M(t.substr(i,2));e[Et]=M(t.substr(r))});var an=Xt("Hours",true),on={calendar:R,longDateFormat:W,invalidDate:z,ordinal:E,dayOfMonthOrdinalParse:H,relativeTime:j,months:re,monthsShort:oe,week:Se,weekdays:Ie,weekdaysMin:We,weekdaysShort:Re,meridiemParse:/[ap]\.?m?\.?/i},sn={},ln={},un;function dn(t){return t?t.toLowerCase().replace("_","-"):t}function hn(t){var e=0,n,i,r,a;while(e<t.length){a=dn(t[e]).split("-");n=a.length;i=dn(t[e+1]);i=i?i.split("-"):null;while(n>0){r=cn(a.slice(0,n).join("-"));if(r){return r}if(i&&i.length>=n&&S(a,i,true)>=n-1){break}n--}e++}return un}function cn(t){var e=null;if(!sn[t]&&"object"!=="undefined"&&za&&za.exports){try{e=un._abbr;var n=Va;n("./locale/"+t);fn(e)}catch(t){}}return sn[t]}function fn(t,e){var n;if(t){if(a(e)){n=pn(t)}else{n=gn(t,e)}if(n){un=n}else{if(typeof console!=="undefined"&&console.warn){console.warn("Locale "+t+" not found. Did you forget to load it?")}}}return un._abbr}function gn(t,e){if(e!==null){var n,i=on;e.abbr=t;if(sn[t]!=null){O("defineLocaleOverride","use moment.updateLocale(localeName, config) to change "+"an existing locale. moment.defineLocale(localeName, "+"config) should only be used for creating a new locale "+"See http://momentjs.com/guides/#/warnings/define-locale/ for more info.");i=sn[t]._config}else if(e.parentLocale!=null){if(sn[e.parentLocale]!=null){i=sn[e.parentLocale]._config}else{n=cn(e.parentLocale);if(n!=null){i=n._config}else{if(!ln[e.parentLocale]){ln[e.parentLocale]=[]}ln[e.parentLocale].push({name:t,config:e});return null}}}sn[t]=new L(I(i,e));if(ln[t]){ln[t].forEach(function(t){gn(t.name,t.config)})}fn(t);return sn[t]}else{delete sn[t];return null}}function mn(t,e){if(null!=e){var n,i,r=on;null!=(i=cn(t))&&(r=i._config),e=I(r,e),(n=new L(e)).parentLocale=sn[t],sn[t]=n,fn(t)}else null!=sn[t]&&(null!=sn[t].parentLocale?sn[t]=sn[t].parentLocale:null!=sn[t]&&delete sn[t]);return sn[t]}function pn(t){var e;if(t&&t._locale&&t._locale._abbr){t=t._locale._abbr}if(!t){return un}if(!o(t)){e=cn(t);if(e){return e}t=[t]}return hn(t)}function vn(){return T(sn)}function yn(t){var e;var n=t._a;if(n&&m(t).overflow===-2){e=n[Wt]<0||n[Wt]>11?Wt:n[Yt]<1||n[Yt]>ne(n[Nt],n[Wt])?Yt:n[zt]<0||n[zt]>24||n[zt]===24&&(n[Vt]!==0||n[Et]!==0||n[Ht]!==0)?zt:n[Vt]<0||n[Vt]>59?Vt:n[Et]<0||n[Et]>59?Et:n[Ht]<0||n[Ht]>999?Ht:-1;if(m(t)._overflowDayOfYear&&(e<Nt||e>Yt)){e=Yt}if(m(t)._overflowWeeks&&e===-1){e=Bt}if(m(t)._overflowWeekday&&e===-1){e=jt}m(t).overflow=e}return t}function bn(t,e,n){if(t!=null){return t}if(e!=null){return e}return n}function xn(t){var e=new Date(u.now());if(t._useUTC){return[e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate()]}return[e.getFullYear(),e.getMonth(),e.getDate()]}function _n(t){var e,n,i=[],r,a,o;if(t._d){return}r=xn(t);if(t._w&&t._a[Yt]==null&&t._a[Wt]==null){wn(t)}if(t._dayOfYear!=null){o=bn(t._a[Nt],r[Nt]);if(t._dayOfYear>Ut(o)||t._dayOfYear===0){m(t)._overflowDayOfYear=true}n=be(o,0,t._dayOfYear);t._a[Wt]=n.getUTCMonth();t._a[Yt]=n.getUTCDate()}for(e=0;e<3&&t._a[e]==null;++e){t._a[e]=i[e]=r[e]}for(;e<7;e++){t._a[e]=i[e]=t._a[e]==null?e===2?1:0:t._a[e]}if(t._a[zt]===24&&t._a[Vt]===0&&t._a[Et]===0&&t._a[Ht]===0){t._nextDay=true;t._a[zt]=0}t._d=(t._useUTC?be:ye).apply(null,i);a=t._useUTC?t._d.getUTCDay():t._d.getDay();if(t._tzm!=null){t._d.setUTCMinutes(t._d.getUTCMinutes()-t._tzm)}if(t._nextDay){t._a[zt]=24}if(t._w&&typeof t._w.d!=="undefined"&&t._w.d!==a){m(t).weekdayMismatch=true}}function wn(t){var e,n,i,r,a,o,s,l;e=t._w;if(e.GG!=null||e.W!=null||e.E!=null){a=1;o=4;n=bn(e.GG,t._a[Nt],we(qn(),1,4).year);i=bn(e.W,1);r=bn(e.E,1);if(r<1||r>7){l=true}}else{a=t._locale._week.dow;o=t._locale._week.doy;var u=we(qn(),a,o);n=bn(e.gg,t._a[Nt],u.year);i=bn(e.w,u.week);if(e.d!=null){r=e.d;if(r<0||r>6){l=true}}else if(e.e!=null){r=e.e+a;if(e.e<0||e.e>6){l=true}}else{r=a}}if(i<1||i>ke(n,a,o)){m(t)._overflowWeeks=true}else if(l!=null){m(t)._overflowWeekday=true}else{s=_e(n,i,r,a,o);t._a[Nt]=s.year;t._dayOfYear=s.dayOfYear}}var kn=/^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/,Mn=/^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/,Sn=/Z|[+-]\d\d(?::?\d\d)?/,Dn=[["YYYYYY-MM-DD",/[+-]\d{6}-\d\d-\d\d/],["YYYY-MM-DD",/\d{4}-\d\d-\d\d/],["GGGG-[W]WW-E",/\d{4}-W\d\d-\d/],["GGGG-[W]WW",/\d{4}-W\d\d/,false],["YYYY-DDD",/\d{4}-\d{3}/],["YYYY-MM",/\d{4}-\d\d/,false],["YYYYYYMMDD",/[+-]\d{10}/],["YYYYMMDD",/\d{8}/],["GGGG[W]WWE",/\d{4}W\d{3}/],["GGGG[W]WW",/\d{4}W\d{2}/,false],["YYYYDDD",/\d{7}/]],Cn=[["HH:mm:ss.SSSS",/\d\d:\d\d:\d\d\.\d+/],["HH:mm:ss,SSSS",/\d\d:\d\d:\d\d,\d+/],["HH:mm:ss",/\d\d:\d\d:\d\d/],["HH:mm",/\d\d:\d\d/],["HHmmss.SSSS",/\d\d\d\d\d\d\.\d+/],["HHmmss,SSSS",/\d\d\d\d\d\d,\d+/],["HHmmss",/\d\d\d\d\d\d/],["HHmm",/\d\d\d\d/],["HH",/\d\d/]],Pn=/^\/?Date\((\-?\d+)/i;function Tn(t){var e,n,i=t._i,r=kn.exec(i)||Mn.exec(i),a,o,s,l;if(r){m(t).iso=true;for(e=0,n=Dn.length;e<n;e++){if(Dn[e][1].exec(r[1])){o=Dn[e][0];a=Dn[e][2]!==false;break}}if(o==null){t._isValid=false;return}if(r[3]){for(e=0,n=Cn.length;e<n;e++){if(Cn[e][1].exec(r[3])){s=(r[2]||" ")+Cn[e][0];break}}if(s==null){t._isValid=false;return}}if(!a&&s!=null){t._isValid=false;return}if(r[4]){if(Sn.exec(r[4])){l="Z"}else{t._isValid=false;return}}t._f=o+(s||"")+(l||"");zn(t)}else{t._isValid=false}}var On=/^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/;function An(t,e,n,i,r,a){var o=[Fn(t),oe.indexOf(e),parseInt(n,10),parseInt(i,10),parseInt(r,10)];if(a){o.push(parseInt(a,10))}return o}function Fn(t){var e=parseInt(t,10);if(e<=49){return 2e3+e}else if(e<=999){return 1900+e}return e}function In(t){return t.replace(/\([^)]*\)|[\n\t]/g," ").replace(/(\s\s+)/g," ").replace(/^\s\s*/,"").replace(/\s\s*$/,"")}function Ln(t,e,n){if(t){var i=Re.indexOf(t),r=new Date(e[0],e[1],e[2]).getDay();if(i!==r){m(n).weekdayMismatch=true;n._isValid=false;return false}}return true}var Rn={UT:0,GMT:0,EDT:-4*60,EST:-5*60,CDT:-5*60,CST:-6*60,MDT:-6*60,MST:-7*60,PDT:-7*60,PST:-8*60};function Nn(t,e,n){if(t){return Rn[t]}else if(e){return 0}else{var i=parseInt(n,10);var r=i%100,a=(i-r)/100;return a*60+r}}function Wn(t){var e=On.exec(In(t._i));if(e){var n=An(e[4],e[3],e[2],e[5],e[6],e[7]);if(!Ln(e[1],n,t)){return}t._a=n;t._tzm=Nn(e[8],e[9],e[10]);t._d=be.apply(null,t._a);t._d.setUTCMinutes(t._d.getUTCMinutes()-t._tzm);m(t).rfc2822=true}else{t._isValid=false}}function Yn(t){var e=Pn.exec(t._i);if(e!==null){t._d=new Date(+e[1]);return}Tn(t);if(t._isValid===false){delete t._isValid}else{return}Wn(t);if(t._isValid===false){delete t._isValid}else{return}u.createFromInputFallback(t)}function zn(t){if(t._f===u.ISO_8601){Tn(t);return}if(t._f===u.RFC_2822){Wn(t);return}t._a=[];m(t).empty=true;var e=""+t._i,n,i,r,a,o,s=e.length,l=0;r=ut(t._f,t._locale).match(et)||[];for(n=0;n<r.length;n++){a=r[n];i=(e.match(Tt(a,t))||[])[0];if(i){o=e.substr(0,e.indexOf(i));if(o.length>0){m(t).unusedInput.push(o)}e=e.slice(e.indexOf(i)+i.length);l+=i.length}if(rt[a]){if(i){m(t).empty=false}else{m(t).unusedTokens.push(a)}Rt(a,i,t)}else if(t._strict&&!i){m(t).unusedTokens.push(a)}}m(t).charsLeftOver=s-l;if(e.length>0){m(t).unusedInput.push(e)}if(t._a[zt]<=12&&m(t).bigHour===true&&t._a[zt]>0){m(t).bigHour=undefined}m(t).parsedDateParts=t._a.slice(0);m(t).meridiem=t._meridiem;t._a[zt]=Vn(t._locale,t._a[zt],t._meridiem);_n(t);yn(t)}function Vn(t,e,n){var i;if(n==null){return e}if(t.meridiemHour!=null){return t.meridiemHour(e,n)}else if(t.isPM!=null){i=t.isPM(n);if(i&&e<12){e+=12}if(!i&&e===12){e=0}return e}else{return e}}function En(t){var e,n,i,r,a;if(t._f.length===0){m(t).invalidFormat=true;t._d=new Date(NaN);return}for(r=0;r<t._f.length;r++){a=0;e=b({},t);if(t._useUTC!=null){e._useUTC=t._useUTC}e._f=t._f[r];zn(e);if(!p(e)){continue}a+=m(e).charsLeftOver;a+=m(e).unusedTokens.length*10;m(e).score=a;if(i==null||a<i){i=a;n=e}}f(t,n||e)}function Hn(t){if(t._d){return}var e=X(t._i);t._a=n([e.year,e.month,e.day||e.date,e.hour,e.minute,e.second,e.millisecond],function(t){return t&&parseInt(t,10)});_n(t)}function Bn(t){var e=new _(yn(jn(t)));if(e._nextDay){e.add(1,"d");e._nextDay=undefined}return e}function jn(t){var e=t._i,n=t._f;t._locale=t._locale||pn(t._l);if(e===null||n===undefined&&e===""){return v({nullInput:true})}if(typeof e==="string"){t._i=e=t._locale.preparse(e)}if(w(e)){return new _(yn(e))}else if(h(e)){t._d=e}else if(o(n)){En(t)}else if(n){zn(t)}else{Un(t)}if(!p(t)){t._d=null}return t}function Un(t){var e=t._i;if(a(e)){t._d=new Date(u.now())}else if(h(e)){t._d=new Date(e.valueOf())}else if(typeof e==="string"){Yn(t)}else if(o(e)){t._a=n(e.slice(0),function(t){return parseInt(t,10)});_n(t)}else if(s(e)){Hn(t)}else if(d(e)){t._d=new Date(e)}else{u.createFromInputFallback(t)}}function Gn(t,e,n,i,r){var a={};if(n===true||n===false){i=n;n=undefined}if(s(t)&&l(t)||o(t)&&t.length===0){t=undefined}a._isAMomentObject=true;a._useUTC=a._isUTC=r;a._l=n;a._i=t;a._f=e;a._strict=i;return Bn(a)}function qn(t,e,n,i){return Gn(t,e,n,i,false)}u.createFromInputFallback=C("value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), "+"which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are "+"discouraged and will be removed in an upcoming major release. Please refer to "+"http://momentjs.com/guides/#/warnings/js-date/ for more info.",function(t){t._d=new Date(t._i+(t._useUTC?" UTC":""))}),u.ISO_8601=function(){},u.RFC_2822=function(){};var Zn=C("moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var t=qn.apply(null,arguments);if(this.isValid()&&t.isValid()){return t<this?this:t}else{return v()}}),$n=C("moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var t=qn.apply(null,arguments);if(this.isValid()&&t.isValid()){return t>this?this:t}else{return v()}});function Xn(t,e){var n,i;if(e.length===1&&o(e[0])){e=e[0]}if(!e.length){return qn()}n=e[0];for(i=1;i<e.length;++i){if(!e[i].isValid()||e[i][t](n)){n=e[i]}}return n}function Kn(){var t;return Xn("isBefore",[].slice.call(arguments,0))}function Jn(){var t;return Xn("isAfter",[].slice.call(arguments,0))}var Qn=function(){return Date.now?Date.now():+new Date},ti=["year","quarter","month","week","day","hour","minute","second","millisecond"];function ei(t){for(var e in t){if(!(Zt.call(ti,e)!==-1&&(t[e]==null||!isNaN(t[e])))){return false}}var n=false;for(var i=0;i<ti.length;++i){if(t[ti[i]]){if(n){return false}if(parseFloat(t[ti[i]])!==M(t[ti[i]])){n=true}}}return true}function ni(){return this._isValid}function ii(){return Si(NaN)}function ri(t){var e=X(t),n=e.year||0,i=e.quarter||0,r=e.month||0,a=e.week||e.isoWeek||0,o=e.day||0,s=e.hour||0,l=e.minute||0,u=e.second||0,d=e.millisecond||0;this._isValid=ei(e);this._milliseconds=+d+u*1e3+l*6e4+s*1e3*60*60;this._days=+o+a*7;this._months=+r+i*3+n*12;this._data={};this._locale=pn();this._bubble()}function ai(t){return t instanceof ri}function oi(t){if(t<0){return Math.round(-1*t)*-1}else{return Math.round(t)}}function si(t,n){at(t,0,0,function(){var t=this.utcOffset();var e="+";if(t<0){t=-t;e="-"}return e+tt(~~(t/60),2)+n+tt(~~t%60,2)})}si("Z",":"),si("ZZ",""),Pt("Z",Mt),Pt("ZZ",Mt),It(["Z","ZZ"],function(t,e,n){n._useUTC=true;n._tzm=ui(Mt,t)});var li=/([\+\-]|\d\d)/gi;function ui(t,e){var n=(e||"").match(t);if(n===null){return null}var i=n[n.length-1]||[];var r=(i+"").match(li)||["-",0,0];var a=+(r[1]*60)+M(r[2]);return a===0?0:r[0]==="+"?a:-a}function di(t,e){var n,i;if(e._isUTC){n=e.clone();i=(w(t)||h(t)?t.valueOf():qn(t).valueOf())-n.valueOf();n._d.setTime(n._d.valueOf()+i);u.updateOffset(n,false);return n}else{return qn(t).local()}}function hi(t){return-Math.round(t._d.getTimezoneOffset()/15)*15}function ci(t,e,n){var i=this._offset||0,r;if(!this.isValid()){return t!=null?this:NaN}if(t!=null){if(typeof t==="string"){t=ui(Mt,t);if(t===null){return this}}else if(Math.abs(t)<16&&!n){t=t*60}if(!this._isUTC&&e){r=hi(this)}this._offset=t;this._isUTC=true;if(r!=null){this.add(r,"m")}if(i!==t){if(!e||this._changeInProgress){Oi(this,Si(t-i,"m"),1,false)}else if(!this._changeInProgress){this._changeInProgress=true;u.updateOffset(this,true);this._changeInProgress=null}}return this}else{return this._isUTC?i:hi(this)}}function fi(t,e){if(t!=null){if(typeof t!=="string"){t=-t}this.utcOffset(t,e);return this}else{return-this.utcOffset()}}function gi(t){return this.utcOffset(0,t)}function mi(t){if(this._isUTC){this.utcOffset(0,t);this._isUTC=false;if(t){this.subtract(hi(this),"m")}}return this}function pi(){if(this._tzm!=null){this.utcOffset(this._tzm,false,true)}else if(typeof this._i==="string"){var t=ui(kt,this._i);if(t!=null){this.utcOffset(t)}else{this.utcOffset(0,true)}}return this}function vi(t){if(!this.isValid()){return false}t=t?qn(t).utcOffset():0;return(this.utcOffset()-t)%60===0}function yi(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()}function bi(){if(!a(this._isDSTShifted)){return this._isDSTShifted}var t={};b(t,this);t=jn(t);if(t._a){var e=t._isUTC?g(t._a):qn(t._a);this._isDSTShifted=this.isValid()&&S(t._a,e.toArray())>0}else{this._isDSTShifted=false}return this._isDSTShifted}function xi(){return this.isValid()?!this._isUTC:false}function _i(){return this.isValid()?this._isUTC:false}function wi(){return this.isValid()?this._isUTC&&this._offset===0:false}u.updateOffset=function(){};var ki=/^(\-|\+)?(?:(\d*)[. ])?(\d+)\:(\d+)(?:\:(\d+)(\.\d*)?)?$/,Mi=/^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;function Si(t,e){var n=t,i=null,r,a,o;if(ai(t)){n={ms:t._milliseconds,d:t._days,M:t._months}}else if(d(t)){n={};if(e){n[e]=t}else{n.milliseconds=t}}else if(!!(i=ki.exec(t))){r=i[1]==="-"?-1:1;n={y:0,d:M(i[Yt])*r,h:M(i[zt])*r,m:M(i[Vt])*r,s:M(i[Et])*r,ms:M(oi(i[Ht]*1e3))*r}}else if(!!(i=Mi.exec(t))){r=i[1]==="-"?-1:1;n={y:Di(i[2],r),M:Di(i[3],r),w:Di(i[4],r),d:Di(i[5],r),h:Di(i[6],r),m:Di(i[7],r),s:Di(i[8],r)}}else if(n==null){n={}}else if(typeof n==="object"&&("from"in n||"to"in n)){o=Pi(qn(n.from),qn(n.to));n={};n.ms=o.milliseconds;n.M=o.months}a=new ri(n);if(ai(t)&&c(t,"_locale")){a._locale=t._locale}return a}function Di(t,e){var n=t&&parseFloat(t.replace(",","."));return(isNaN(n)?0:n)*e}function Ci(t,e){var n={};n.months=e.month()-t.month()+(e.year()-t.year())*12;if(t.clone().add(n.months,"M").isAfter(e)){--n.months}n.milliseconds=+e-+t.clone().add(n.months,"M");return n}function Pi(t,e){var n;if(!(t.isValid()&&e.isValid())){return{milliseconds:0,months:0}}e=di(e,t);if(t.isBefore(e)){n=Ci(t,e)}else{n=Ci(e,t);n.milliseconds=-n.milliseconds;n.months=-n.months}return n}function Ti(r,a){return function(t,e){var n,i;if(e!==null&&!isNaN(+e)){O(a,"moment()."+a+"(period, number) is deprecated. Please use moment()."+a+"(number, period). "+"See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.");i=t;t=e;e=i}t=typeof t==="string"?+t:t;n=Si(t,e);Oi(this,n,r);return this}}function Oi(t,e,n,i){var r=e._milliseconds,a=oi(e._days),o=oi(e._months);if(!t.isValid()){return}i=i==null?true:i;if(o){de(t,Kt(t,"Month")+o*n)}if(a){Jt(t,"Date",Kt(t,"Date")+a*n)}if(r){t._d.setTime(t._d.valueOf()+r*n)}if(i){u.updateOffset(t,a||o)}}Si.fn=ri.prototype,Si.invalid=ii;var Ai=Ti(1,"add"),Fi=Ti(-1,"subtract");function Ii(t,e){var n=t.diff(e,"days",!0);return n<-6?"sameElse":n<-1?"lastWeek":n<0?"lastDay":n<1?"sameDay":n<2?"nextDay":n<7?"nextWeek":"sameElse"}function Li(t,e){var n=t||qn(),i=di(n,this).startOf("day"),r=u.calendarFormat(this,i)||"sameElse";var a=e&&(A(e[r])?e[r].call(this,n):e[r]);return this.format(a||this.localeData().calendar(r,this,qn(n)))}function Ri(){return new _(this)}function Ni(t,e){var n=w(t)?t:qn(t);if(!(this.isValid()&&n.isValid())){return false}e=$(e)||"millisecond";if(e==="millisecond"){return this.valueOf()>n.valueOf()}else{return n.valueOf()<this.clone().startOf(e).valueOf()}}function Wi(t,e){var n=w(t)?t:qn(t);if(!(this.isValid()&&n.isValid())){return false}e=$(e)||"millisecond";if(e==="millisecond"){return this.valueOf()<n.valueOf()}else{return this.clone().endOf(e).valueOf()<n.valueOf()}}function Yi(t,e,n,i){var r=w(t)?t:qn(t),a=w(e)?e:qn(e);if(!(this.isValid()&&r.isValid()&&a.isValid())){return false}i=i||"()";return(i[0]==="("?this.isAfter(r,n):!this.isBefore(r,n))&&(i[1]===")"?this.isBefore(a,n):!this.isAfter(a,n))}function zi(t,e){var n=w(t)?t:qn(t),i;if(!(this.isValid()&&n.isValid())){return false}e=$(e)||"millisecond";if(e==="millisecond"){return this.valueOf()===n.valueOf()}else{i=n.valueOf();return this.clone().startOf(e).valueOf()<=i&&i<=this.clone().endOf(e).valueOf()}}function Vi(t,e){return this.isSame(t,e)||this.isAfter(t,e)}function Ei(t,e){return this.isSame(t,e)||this.isBefore(t,e)}function Hi(t,e,n){var i,r,a;if(!this.isValid()){return NaN}i=di(t,this);if(!i.isValid()){return NaN}r=(i.utcOffset()-this.utcOffset())*6e4;e=$(e);switch(e){case"year":a=Bi(this,i)/12;break;case"month":a=Bi(this,i);break;case"quarter":a=Bi(this,i)/3;break;case"second":a=(this-i)/1e3;break;case"minute":a=(this-i)/6e4;break;case"hour":a=(this-i)/36e5;break;case"day":a=(this-i-r)/864e5;break;case"week":a=(this-i-r)/6048e5;break;default:a=this-i}return n?a:k(a)}function Bi(t,e){var n=(e.year()-t.year())*12+(e.month()-t.month()),i=t.clone().add(n,"months"),r,a;if(e-i<0){r=t.clone().add(n-1,"months");a=(e-i)/(i-r)}else{r=t.clone().add(n+1,"months");a=(e-i)/(r-i)}return-(n+a)||0}function ji(){return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")}function Ui(t){if(!this.isValid()){return null}var e=t!==true;var n=e?this.clone().utc():this;if(n.year()<0||n.year()>9999){return lt(n,e?"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]":"YYYYYY-MM-DD[T]HH:mm:ss.SSSZ")}if(A(Date.prototype.toISOString)){if(e){return this.toDate().toISOString()}else{return new Date(this.valueOf()+this.utcOffset()*60*1e3).toISOString().replace("Z",lt(n,"Z"))}}return lt(n,e?"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]":"YYYY-MM-DD[T]HH:mm:ss.SSSZ")}function Gi(){if(!this.isValid()){return"moment.invalid(/* "+this._i+" */)"}var t="moment";var e="";if(!this.isLocal()){t=this.utcOffset()===0?"moment.utc":"moment.parseZone";e="Z"}var n="["+t+'("]';var i=0<=this.year()&&this.year()<=9999?"YYYY":"YYYYYY";var r="-MM-DD[T]HH:mm:ss.SSS";var a=e+'[")]';return this.format(n+i+r+a)}function qi(t){if(!t){t=this.isUtc()?u.defaultFormatUtc:u.defaultFormat}var e=lt(this,t);return this.localeData().postformat(e)}function Zi(t,e){if(this.isValid()&&(w(t)&&t.isValid()||qn(t).isValid())){return Si({to:this,from:t}).locale(this.locale()).humanize(!e)}else{return this.localeData().invalidDate()}}function $i(t){return this.from(qn(),t)}function Xi(t,e){if(this.isValid()&&(w(t)&&t.isValid()||qn(t).isValid())){return Si({from:this,to:t}).locale(this.locale()).humanize(!e)}else{return this.localeData().invalidDate()}}function Ki(t){return this.to(qn(),t)}function Ji(t){var e;if(t===undefined){return this._locale._abbr}else{e=pn(t);if(e!=null){this._locale=e}return this}}u.defaultFormat="YYYY-MM-DDTHH:mm:ssZ",u.defaultFormatUtc="YYYY-MM-DDTHH:mm:ss[Z]";var Qi=C("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",function(t){if(t===undefined){return this.localeData()}else{return this.locale(t)}});function tr(){return this._locale}var er=1e3,nr=60*er,ir=60*nr,rr=(365*400+97)*24*ir;function ar(t,e){return(t%e+e)%e}function or(t,e,n){if(t<100&&t>=0){return new Date(t+400,e,n)-rr}else{return new Date(t,e,n).valueOf()}}function sr(t,e,n){if(t<100&&t>=0){return Date.UTC(t+400,e,n)-rr}else{return Date.UTC(t,e,n)}}function lr(t){var e;t=$(t);if(t===undefined||t==="millisecond"||!this.isValid()){return this}var n=this._isUTC?sr:or;switch(t){case"year":e=n(this.year(),0,1);break;case"quarter":e=n(this.year(),this.month()-this.month()%3,1);break;case"month":e=n(this.year(),this.month(),1);break;case"week":e=n(this.year(),this.month(),this.date()-this.weekday());break;case"isoWeek":e=n(this.year(),this.month(),this.date()-(this.isoWeekday()-1));break;case"day":case"date":e=n(this.year(),this.month(),this.date());break;case"hour":e=this._d.valueOf();e-=ar(e+(this._isUTC?0:this.utcOffset()*nr),ir);break;case"minute":e=this._d.valueOf();e-=ar(e,nr);break;case"second":e=this._d.valueOf();e-=ar(e,er);break}this._d.setTime(e);u.updateOffset(this,true);return this}function ur(t){var e;t=$(t);if(t===undefined||t==="millisecond"||!this.isValid()){return this}var n=this._isUTC?sr:or;switch(t){case"year":e=n(this.year()+1,0,1)-1;break;case"quarter":e=n(this.year(),this.month()-this.month()%3+3,1)-1;break;case"month":e=n(this.year(),this.month()+1,1)-1;break;case"week":e=n(this.year(),this.month(),this.date()-this.weekday()+7)-1;break;case"isoWeek":e=n(this.year(),this.month(),this.date()-(this.isoWeekday()-1)+7)-1;break;case"day":case"date":e=n(this.year(),this.month(),this.date()+1)-1;break;case"hour":e=this._d.valueOf();e+=ir-ar(e+(this._isUTC?0:this.utcOffset()*nr),ir)-1;break;case"minute":e=this._d.valueOf();e+=nr-ar(e,nr)-1;break;case"second":e=this._d.valueOf();e+=er-ar(e,er)-1;break}this._d.setTime(e);u.updateOffset(this,true);return this}function dr(){return this._d.valueOf()-(this._offset||0)*6e4}function hr(){return Math.floor(this.valueOf()/1e3)}function cr(){return new Date(this.valueOf())}function fr(){var t=this;return[t.year(),t.month(),t.date(),t.hour(),t.minute(),t.second(),t.millisecond()]}function gr(){var t=this;return{years:t.year(),months:t.month(),date:t.date(),hours:t.hours(),minutes:t.minutes(),seconds:t.seconds(),milliseconds:t.milliseconds()}}function mr(){return this.isValid()?this.toISOString():null}function pr(){return p(this)}function vr(){return f({},m(this))}function yr(){return m(this).overflow}function br(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}}function xr(t,e){at(0,[t,t.length],0,e)}function _r(t){return Sr.call(this,t,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy)}function wr(t){return Sr.call(this,t,this.isoWeek(),this.isoWeekday(),1,4)}function kr(){return ke(this.year(),1,4)}function Mr(){var t=this.localeData()._week;return ke(this.year(),t.dow,t.doy)}function Sr(t,e,n,i,r){var a;if(t==null){return we(this,i,r).year}else{a=ke(t,i,r);if(e>a){e=a}return Dr.call(this,t,e,n,i,r)}}function Dr(t,e,n,i,r){var a=_e(t,e,n,i,r),o=be(a.year,0,a.dayOfYear);this.year(o.getUTCFullYear());this.month(o.getUTCMonth());this.date(o.getUTCDate());return this}function Cr(t){return t==null?Math.ceil((this.month()+1)/3):this.month((t-1)*3+this.month()%3)}at(0,["gg",2],0,function(){return this.weekYear()%100}),at(0,["GG",2],0,function(){return this.isoWeekYear()%100}),xr("gggg","weekYear"),xr("ggggg","weekYear"),xr("GGGG","isoWeekYear"),xr("GGGGG","isoWeekYear"),Z("weekYear","gg"),Z("isoWeekYear","GG"),J("weekYear",1),J("isoWeekYear",1),Pt("G",wt),Pt("g",wt),Pt("GG",mt,ht),Pt("gg",mt,ht),Pt("GGGG",bt,ft),Pt("gggg",bt,ft),Pt("GGGGG",xt,gt),Pt("ggggg",xt,gt),Lt(["gggg","ggggg","GGGG","GGGGG"],function(t,e,n,i){e[i.substr(0,2)]=M(t)}),Lt(["gg","GG"],function(t,e,n,i){e[i]=u.parseTwoDigitYear(t)}),at("Q",0,"Qo","quarter"),Z("quarter","Q"),J("quarter",7),Pt("Q",dt),It("Q",function(t,e){e[Wt]=(M(t)-1)*3}),at("D",["DD",2],"Do","date"),Z("date","D"),J("date",9),Pt("D",mt),Pt("DD",mt,ht),Pt("Do",function(t,e){return t?e._dayOfMonthOrdinalParse||e._ordinalParse:e._dayOfMonthOrdinalParseLenient}),It(["D","DD"],Yt),It("Do",function(t,e){e[Yt]=M(t.match(mt)[0])});var Pr=Xt("Date",true);function Tr(t){var e=Math.round((this.clone().startOf("day")-this.clone().startOf("year"))/864e5)+1;return t==null?e:this.add(t-e,"d")}at("DDD",["DDDD",3],"DDDo","dayOfYear"),Z("dayOfYear","DDD"),J("dayOfYear",4),Pt("DDD",yt),Pt("DDDD",ct),It(["DDD","DDDD"],function(t,e,n){n._dayOfYear=M(t)}),at("m",["mm",2],0,"minute"),Z("minute","m"),J("minute",14),Pt("m",mt),Pt("mm",mt,ht),It(["m","mm"],Vt);var Or=Xt("Minutes",false);at("s",["ss",2],0,"second"),Z("second","s"),J("second",15),Pt("s",mt),Pt("ss",mt,ht),It(["s","ss"],Et);var Ar=Xt("Seconds",false),Fr;for(at("S",0,0,function(){return~~(this.millisecond()/100)}),at(0,["SS",2],0,function(){return~~(this.millisecond()/10)}),at(0,["SSS",3],0,"millisecond"),at(0,["SSSS",4],0,function(){return this.millisecond()*10}),at(0,["SSSSS",5],0,function(){return this.millisecond()*100}),at(0,["SSSSSS",6],0,function(){return this.millisecond()*1e3}),at(0,["SSSSSSS",7],0,function(){return this.millisecond()*1e4}),at(0,["SSSSSSSS",8],0,function(){return this.millisecond()*1e5}),at(0,["SSSSSSSSS",9],0,function(){return this.millisecond()*1e6}),Z("millisecond","ms"),J("millisecond",16),Pt("S",yt,dt),Pt("SS",yt,ht),Pt("SSS",yt,ct),Fr="SSSS";Fr.length<=9;Fr+="S"){Pt(Fr,_t)}function Ir(t,e){e[Ht]=M(("0."+t)*1e3)}for(Fr="S";Fr.length<=9;Fr+="S"){It(Fr,Ir)}var Lr=Xt("Milliseconds",false);function Rr(){return this._isUTC?"UTC":""}function Nr(){return this._isUTC?"Coordinated Universal Time":""}at("z",0,0,"zoneAbbr"),at("zz",0,0,"zoneName");var Wr=_.prototype;function Yr(t){return qn(1e3*t)}function zr(){return qn.apply(null,arguments).parseZone()}function Vr(t){return t}Wr.add=Ai,Wr.calendar=Li,Wr.clone=Ri,Wr.diff=Hi,Wr.endOf=ur,Wr.format=qi,Wr.from=Zi,Wr.fromNow=$i,Wr.to=Xi,Wr.toNow=Ki,Wr.get=Qt,Wr.invalidAt=yr,Wr.isAfter=Ni,Wr.isBefore=Wi,Wr.isBetween=Yi,Wr.isSame=zi,Wr.isSameOrAfter=Vi,Wr.isSameOrBefore=Ei,Wr.isValid=pr,Wr.lang=Qi,Wr.locale=Ji,Wr.localeData=tr,Wr.max=$n,Wr.min=Zn,Wr.parsingFlags=vr,Wr.set=te,Wr.startOf=lr,Wr.subtract=Fi,Wr.toArray=fr,Wr.toObject=gr,Wr.toDate=cr,Wr.toISOString=Ui,Wr.inspect=Gi,Wr.toJSON=mr,Wr.toString=ji,Wr.unix=hr,Wr.valueOf=dr,Wr.creationData=br,Wr.year=qt,Wr.isLeapYear=$t,Wr.weekYear=_r,Wr.isoWeekYear=wr,Wr.quarter=Wr.quarters=Cr,Wr.month=he,Wr.daysInMonth=ce,Wr.week=Wr.weeks=Pe,Wr.isoWeek=Wr.isoWeeks=Te,Wr.weeksInYear=Mr,Wr.isoWeeksInYear=kr,Wr.date=Pr,Wr.day=Wr.days=Ee,Wr.weekday=He,Wr.isoWeekday=Be,Wr.dayOfYear=Tr,Wr.hour=Wr.hours=an,Wr.minute=Wr.minutes=Or,Wr.second=Wr.seconds=Ar,Wr.millisecond=Wr.milliseconds=Lr,Wr.utcOffset=ci,Wr.utc=gi,Wr.local=mi,Wr.parseZone=pi,Wr.hasAlignedHourOffset=vi,Wr.isDST=yi,Wr.isLocal=xi,Wr.isUtcOffset=_i,Wr.isUtc=wi,Wr.isUTC=wi,Wr.zoneAbbr=Rr,Wr.zoneName=Nr,Wr.dates=C("dates accessor is deprecated. Use date instead.",Pr),Wr.months=C("months accessor is deprecated. Use month instead",he),Wr.years=C("years accessor is deprecated. Use year instead",qt),Wr.zone=C("moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/",fi),Wr.isDSTShifted=C("isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information",bi);var Er=L.prototype;function Hr(t,e,n,i){var r=pn();var a=g().set(i,e);return r[n](a,t)}function Br(t,e,n){if(d(t)){e=t;t=undefined}t=t||"";if(e!=null){return Hr(t,e,n,"month")}var i;var r=[];for(i=0;i<12;i++){r[i]=Hr(t,i,n,"month")}return r}function jr(t,e,n,i){if(typeof t==="boolean"){if(d(e)){n=e;e=undefined}e=e||""}else{e=t;n=e;t=false;if(d(e)){n=e;e=undefined}e=e||""}var r=pn(),a=t?r._week.dow:0;if(n!=null){return Hr(e,(n+a)%7,i,"day")}var o;var s=[];for(o=0;o<7;o++){s[o]=Hr(e,(o+a)%7,i,"day")}return s}function Ur(t,e){return Br(t,e,"months")}function Gr(t,e){return Br(t,e,"monthsShort")}function qr(t,e,n){return jr(t,e,n,"weekdays")}function Zr(t,e,n){return jr(t,e,n,"weekdaysShort")}function $r(t,e,n){return jr(t,e,n,"weekdaysMin")}Er.calendar=N,Er.longDateFormat=Y,Er.invalidDate=V,Er.ordinal=B,Er.preparse=Vr,Er.postformat=Vr,Er.relativeTime=U,Er.pastFuture=G,Er.set=F,Er.months=ae,Er.monthsShort=se,Er.monthsParse=ue,Er.monthsRegex=pe,Er.monthsShortRegex=ge,Er.week=Me,Er.firstDayOfYear=Ce,Er.firstDayOfWeek=De,Er.weekdays=Le,Er.weekdaysMin=Ye,Er.weekdaysShort=Ne,Er.weekdaysParse=Ve,Er.weekdaysRegex=Ue,Er.weekdaysShortRegex=qe,Er.weekdaysMinRegex=Xe,Er.isPM=nn,Er.meridiem=rn,fn("en",{dayOfMonthOrdinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(t){var e=t%10,n=M(t%100/10)===1?"th":e===1?"st":e===2?"nd":e===3?"rd":"th";return t+n}}),u.lang=C("moment.lang is deprecated. Use moment.locale instead.",fn),u.langData=C("moment.langData is deprecated. Use moment.localeData instead.",pn);var Xr=Math.abs;function Kr(){var t=this._data;return this._milliseconds=Xr(this._milliseconds),this._days=Xr(this._days),this._months=Xr(this._months),t.milliseconds=Xr(t.milliseconds),t.seconds=Xr(t.seconds),t.minutes=Xr(t.minutes),t.hours=Xr(t.hours),t.months=Xr(t.months),t.years=Xr(t.years),this}function Jr(t,e,n,i){var r=Si(e,n);t._milliseconds+=i*r._milliseconds;t._days+=i*r._days;t._months+=i*r._months;return t._bubble()}function Qr(t,e){return Jr(this,t,e,1)}function ta(t,e){return Jr(this,t,e,-1)}function ea(t){if(t<0){return Math.floor(t)}else{return Math.ceil(t)}}function na(){var t,e,n,i,r,a=this._milliseconds,o=this._days,s=this._months,l=this._data;if(!(0<=a&&0<=o&&0<=s||a<=0&&o<=0&&s<=0))a+=864e5*ea(ra(s)+o),s=o=0;return l.milliseconds=a%1e3,t=k(a/1e3),l.seconds=t%60,e=k(t/60),l.minutes=e%60,n=k(e/60),l.hours=n%24,o+=k(n/24),r=k(ia(o)),s+=r,o-=ea(ra(r)),i=k(s/12),s%=12,l.days=o,l.months=s,l.years=i,this}function ia(t){return t*4800/146097}function ra(t){return t*146097/4800}function aa(t){if(!this.isValid())return NaN;var e,n,i=this._milliseconds;if("month"===(t=$(t))||"quarter"===t||"year"===t)switch(e=this._days+i/864e5,n=this._months+ia(e),t){case"month":return n;case"quarter":return n/3;case"year":return n/12}else switch(e=this._days+Math.round(ra(this._months)),t){case"week":return e/7+i/6048e5;case"day":return e+i/864e5;case"hour":return 24*e+i/36e5;case"minute":return 1440*e+i/6e4;case"second":return 86400*e+i/1e3;case"millisecond":return Math.floor(864e5*e)+i;default:throw new Error("Unknown unit "+t)}}function oa(){return this.isValid()?this._milliseconds+864e5*this._days+this._months%12*2592e6+31536e6*M(this._months/12):NaN}function sa(t){return function(){return this.as(t)}}var la=sa("ms"),ua=sa("s"),da=sa("m"),ha=sa("h"),ca=sa("d"),fa=sa("w"),ga=sa("M"),ma=sa("Q"),pa=sa("y");function va(){return Si(this)}function ya(t){return t=$(t),this.isValid()?this[t+"s"]():NaN}function ba(t){return function(){return this.isValid()?this._data[t]:NaN}}var xa=ba("milliseconds"),_a=ba("seconds"),wa=ba("minutes"),ka=ba("hours"),Ma=ba("days"),Sa=ba("months"),Da=ba("years");function Ca(){return k(this.days()/7)}var Pa=Math.round,Ta={ss:44,s:45,m:45,h:22,d:26,M:11};function Oa(t,e,n,i,r){return r.relativeTime(e||1,!!n,t,i)}function Aa(t,e,n){var i=Si(t).abs(),r=Pa(i.as("s")),a=Pa(i.as("m")),o=Pa(i.as("h")),s=Pa(i.as("d")),l=Pa(i.as("M")),u=Pa(i.as("y")),d=(r<=Ta.ss?["s",r]:r<Ta.s&&["ss",r])||a<=1&&["m"]||a<Ta.m&&["mm",a]||o<=1&&["h"]||o<Ta.h&&["hh",o]||s<=1&&["d"]||s<Ta.d&&["dd",s]||l<=1&&["M"]||l<Ta.M&&["MM",l]||u<=1&&["y"]||["yy",u];return d[2]=e,d[3]=0<+t,d[4]=n,function(t,e,n,i,r){return r.relativeTime(e||1,!!n,t,i)}.apply(null,d)}function Fa(t){return void 0!==t?"function"==typeof t&&(Pa=t,!0):Pa}function Ia(t,e){if(void 0===Ta[t])return!1;if(void 0===e)return Ta[t];if(Ta[t]=e,"s"===t)Ta.ss=e-1;return!0}function La(t){if(!this.isValid())return this.localeData().invalidDate();var e=this.localeData(),n=function(t,e,n){var i=Si(t).abs(),r=Pa(i.as("s")),a=Pa(i.as("m")),o=Pa(i.as("h")),s=Pa(i.as("d")),l=Pa(i.as("M")),u=Pa(i.as("y")),d=(r<=Ta.ss?["s",r]:r<Ta.s&&["ss",r])||a<=1&&["m"]||a<Ta.m&&["mm",a]||o<=1&&["h"]||o<Ta.h&&["hh",o]||s<=1&&["d"]||s<Ta.d&&["dd",s]||l<=1&&["M"]||l<Ta.M&&["MM",l]||u<=1&&["y"]||["yy",u];return d[2]=e,d[3]=0<+t,d[4]=n,function(t,e,n,i,r){return r.relativeTime(e||1,!!n,t,i)}.apply(null,d)}(this,!t,e);if(t)n=e.pastFuture(+this,n);return e.postformat(n)}var Ra=Math.abs;function Na(t){return(t>0)-(t<0)||+t}function Wa(){if(!this.isValid()){return this.localeData().invalidDate()}var t=Ra(this._milliseconds)/1e3;var e=Ra(this._days);var n=Ra(this._months);var i,r,a;i=k(t/60);r=k(i/60);t%=60;i%=60;a=k(n/12);n%=12;var o=a;var s=n;var l=e;var u=r;var d=i;var h=t?t.toFixed(3).replace(/\.?0+$/,""):"";var c=this.asSeconds();if(!c){return"P0D"}var f=c<0?"-":"";var g=Na(this._months)!==Na(c)?"-":"";var m=Na(this._days)!==Na(c)?"-":"";var p=Na(this._milliseconds)!==Na(c)?"-":"";return f+"P"+(o?g+o+"Y":"")+(s?g+s+"M":"")+(l?m+l+"D":"")+(u||d||h?"T":"")+(u?p+u+"H":"")+(d?p+d+"M":"")+(h?p+h+"S":"")}var Ya=ri.prototype;return Ya.isValid=function(){return this._isValid},Ya.abs=function(){var t=this._data;return this._milliseconds=Xr(this._milliseconds),this._days=Xr(this._days),this._months=Xr(this._months),t.milliseconds=Xr(t.milliseconds),t.seconds=Xr(t.seconds),t.minutes=Xr(t.minutes),t.hours=Xr(t.hours),t.months=Xr(t.months),t.years=Xr(t.years),this},Ya.add=function(t,e){return Jr(this,t,e,1)},Ya.subtract=function(t,e){return Jr(this,t,e,-1)},Ya.as=function(t){if(!this.isValid())return NaN;var e,n,i=this._milliseconds;if("month"===(t=$(t))||"quarter"===t||"year"===t)switch(e=this._days+i/864e5,n=this._months+ia(e),t){case"month":return n;case"quarter":return n/3;case"year":return n/12}else switch(e=this._days+Math.round(ra(this._months)),t){case"week":return e/7+i/6048e5;case"day":return e+i/864e5;case"hour":return 24*e+i/36e5;case"minute":return 1440*e+i/6e4;case"second":return 86400*e+i/1e3;case"millisecond":return Math.floor(864e5*e)+i;default:throw new Error("Unknown unit "+t)}},Ya.asMilliseconds=la,Ya.asSeconds=ua,Ya.asMinutes=da,Ya.asHours=ha,Ya.asDays=ca,Ya.asWeeks=fa,Ya.asMonths=ga,Ya.asQuarters=ma,Ya.asYears=pa,Ya.valueOf=function(){return this.isValid()?this._milliseconds+864e5*this._days+this._months%12*2592e6+31536e6*M(this._months/12):NaN},Ya._bubble=function(){var t,e,n,i,r,a=this._milliseconds,o=this._days,s=this._months,l=this._data;0<=a&&0<=o&&0<=s||a<=0&&o<=0&&s<=0||(a+=864e5*ea(ra(s)+o),s=o=0);return l.milliseconds=a%1e3,t=k(a/1e3),l.seconds=t%60,e=k(t/60),l.minutes=e%60,n=k(e/60),l.hours=n%24,o+=k(n/24),r=k(ia(o)),s+=r,o-=ea(ra(r)),i=k(s/12),s%=12,l.days=o,l.months=s,l.years=i,this},Ya.clone=function(){return Si(this)},Ya.get=function(t){return t=$(t),this.isValid()?this[t+"s"]():NaN},Ya.milliseconds=xa,Ya.seconds=_a,Ya.minutes=wa,Ya.hours=ka,Ya.days=Ma,Ya.weeks=function(){return k(this.days()/7)},Ya.months=Sa,Ya.years=Da,Ya.humanize=function(t){if(!this.isValid())return this.localeData().invalidDate();var e=this.localeData(),n=function(t,e,n){var i=Si(t).abs(),r=Pa(i.as("s")),a=Pa(i.as("m")),o=Pa(i.as("h")),s=Pa(i.as("d")),l=Pa(i.as("M")),u=Pa(i.as("y")),d=(r<=Ta.ss?["s",r]:r<Ta.s&&["ss",r])||a<=1&&["m"]||a<Ta.m&&["mm",a]||o<=1&&["h"]||o<Ta.h&&["hh",o]||s<=1&&["d"]||s<Ta.d&&["dd",s]||l<=1&&["M"]||l<Ta.M&&["MM",l]||u<=1&&["y"]||["yy",u];return d[2]=e,d[3]=0<+t,d[4]=n,function(t,e,n,i,r){return r.relativeTime(e||1,!!n,t,i)}.apply(null,d)}(this,!t,e);t&&(n=e.pastFuture(+this,n));return e.postformat(n)},Ya.toISOString=Wa,Ya.toString=Wa,Ya.toJSON=Wa,Ya.locale=Ji,Ya.localeData=tr,Ya.toIsoString=C("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",Wa),Ya.lang=Qi,at("X",0,0,"unix"),at("x",0,0,"valueOf"),Pt("x",wt),Pt("X",/[+-]?\d+(\.\d{1,3})?/),It("X",function(t,e,n){n._d=new Date(1e3*parseFloat(t,10))}),It("x",function(t,e,n){n._d=new Date(M(t))}),u.version="2.24.0",function(t){e=t}(qn),u.fn=Wr,u.min=function(){return Xn("isBefore",[].slice.call(arguments,0))},u.max=function(){return Xn("isAfter",[].slice.call(arguments,0))},u.now=function(){return Date.now?Date.now():+new Date},u.utc=g,u.unix=function(t){return qn(1e3*t)},u.months=function(t,e){return Br(t,e,"months")},u.isDate=h,u.locale=fn,u.invalid=v,u.duration=Si,u.isMoment=w,u.weekdays=function(t,e,n){return jr(t,e,n,"weekdays")},u.parseZone=function(){return qn.apply(null,arguments).parseZone()},u.localeData=pn,u.isDuration=ai,u.monthsShort=function(t,e){return Br(t,e,"monthsShort")},u.weekdaysMin=function(t,e,n){return jr(t,e,n,"weekdaysMin")},u.defineLocale=gn,u.updateLocale=function(t,e){{var n,i,r;null!=e?(r=on,null!=(i=cn(t))&&(r=i._config),e=I(r,e),(n=new L(e)).parentLocale=sn[t],sn[t]=n,fn(t)):null!=sn[t]&&(null!=sn[t].parentLocale?sn[t]=sn[t].parentLocale:null!=sn[t]&&delete sn[t])}return sn[t]},u.locales=function(){return T(sn)},u.weekdaysShort=function(t,e,n){return jr(t,e,n,"weekdaysShort")},u.normalizeUnits=$,u.relativeTimeRounding=function(t){return void 0!==t?"function"==typeof t&&(Pa=t,!0):Pa},u.relativeTimeThreshold=function(t,e){if(void 0===Ta[t])return!1;if(void 0===e)return Ta[t];Ta[t]=e,"s"===t&&(Ta.ss=e-1);return!0},u.calendarFormat=function(t,e){var n=t.diff(e,"days",!0);return n<-6?"sameElse":n<-1?"lastWeek":n<0?"lastDay":n<1?"sameDay":n<2?"nextDay":n<7?"nextWeek":"sameElse"},u.prototype=Wr,u.HTML5_FMT={DATETIME_LOCAL:"YYYY-MM-DDTHH:mm",DATETIME_LOCAL_SECONDS:"YYYY-MM-DDTHH:mm:ss",DATETIME_LOCAL_MS:"YYYY-MM-DDTHH:mm:ss.SSS",DATE:"YYYY-MM-DD",TIME:"HH:mm",TIME_SECONDS:"HH:mm:ss",TIME_MS:"HH:mm:ss.SSS",WEEK:"GGGG-[W]WW",MONTH:"YYYY-MM"},u}()}),ri={datetime:"MMM D, YYYY, h:mm:ss a",millisecond:"h:mm:ss.SSS a",second:"h:mm:ss a",minute:"h:mm a",hour:"hA",day:"MMM D",week:"ll",month:"MMM YYYY",quarter:"[Q]Q - YYYY",year:"YYYY"};Qe._date.override("function"==typeof ii?{_id:"moment",formats:function(){return ri},parse:function(t,e){return"string"==typeof t&&"string"==typeof e?t=ii(t,e):t instanceof ii||(t=ii(t)),t.isValid()?t.valueOf():null},format:function(t,e){return ii(t).format(e)},add:function(t,e,n){return ii(t).add(e,n).valueOf()},diff:function(t,e,n){return ii(t).diff(ii(e),n)},startOf:function(t,e,n){return t=ii(t),"isoWeek"===e?t.isoWeekday(n).valueOf():t.startOf(e).valueOf()},endOf:function(t,e){return ii(t).endOf(e).valueOf()},_create:function(t){return ii(t)}}:{}),Y._set("global",{plugins:{filler:{propagate:!0}}});var ai={dataset:function(t){var e=t.fill,n=t.chart,i=n.getDatasetMeta(e),r=i&&n.isDatasetVisible(e)&&i.dataset._children||[],a=r.length||0;return a?function(t,e){return e<a&&r[e]._view||null}:null},boundary:function(t){var n=t.boundary,e=n?n.x:null,i=n?n.y:null;return B.isArray(n)?function(t,e){return n[e]}:function(t){return{x:null===e?t.x:e,y:null===i?t.y:i}}}};function oi(t){return((t.el._scale||{}).getPointPositionForValue?function(t){var e,n,i,r,a,o=t.el._scale,s=o.options,l=o.chart.data.labels.length,u=t.fill,d=[];if(!l)return null;for(e=s.ticks.reverse?o.max:o.min,n=s.ticks.reverse?o.min:o.max,i=o.getPointPositionForValue(0,e),r=0;r<l;++r)a="start"===u||"end"===u?o.getPointPositionForValue(r,"start"===u?e:n):o.getBasePosition(r),s.gridLines.circular&&(a.cx=i.x,a.cy=i.y,a.angle=o.getIndexAngle(r)-Math.PI/2),d.push(a);return d}:function(t){var e,n=t.el._model||{},i=t.el._scale||{},r=t.fill,a=null;if(isFinite(r))return null;if("start"===r?a=void 0===n.scaleBottom?i.bottom:n.scaleBottom:"end"===r?a=void 0===n.scaleTop?i.top:n.scaleTop:void 0!==n.scaleZero?a=n.scaleZero:i.getBasePixel&&(a=i.getBasePixel()),null!=a){if(void 0!==a.x&&void 0!==a.y)return a;if(B.isFinite(a))return{x:(e=i.isHorizontal())?a:null,y:e?null:a}}return null})(t)}function si(t){return t&&!t.skip}function li(t,e,n,i,r){var a,o,s,l;if(i&&r){for(t.moveTo(e[0].x,e[0].y),a=1;a<i;++a)B.canvas.lineTo(t,e[a-1],e[a]);if(void 0===n[0].angle)for(t.lineTo(n[r-1].x,n[r-1].y),a=r-1;0<a;--a)B.canvas.lineTo(t,n[a],n[a-1],!0);else for(o=n[0].cx,s=n[0].cy,l=Math.sqrt(Math.pow(n[0].x-o,2)+Math.pow(n[0].y-s,2)),a=r-1;0<a;--a)t.arc(o,s,l,n[a].angle,n[a-1].angle,!0)}}var ui={id:"filler",afterDatasetsUpdate:function(t,e){for(var n,i,r,a,o,s,l=(t.data.datasets||[]).length,u=e.propagate,d=[],h=0;h<l;++h)r=null,(i=(n=t.getDatasetMeta(h)).dataset)&&i._model&&i instanceof wt.Line&&(r={visible:t.isDatasetVisible(h),fill:function(t,e,n){var i,r=t._model||{},a=r.fill;if(void 0===a&&(a=!!r.backgroundColor),!1===a||null===a)return!1;if(!0===a)return"origin";if(i=parseFloat(a,10),isFinite(i)&&Math.floor(i)===i)return"-"!==a[0]&&"+"!==a[0]||(i=e+i),!(i===e||i<0||n<=i)&&i;switch(a){case"bottom":return"start";case"top":return"end";case"zero":return"origin";case"origin":case"start":case"end":return a;default:return!1}}(i,h,l),chart:t,el:i}),n.$filler=r,d.push(r);for(h=0;h<l;++h)(r=d[h])&&(r.fill=function(t,e,n){var i,r=t[e].fill,a=[e];if(!n)return r;for(;!1!==r&&-1===a.indexOf(r);){if(!isFinite(r))return r;if(!(i=t[r]))return!1;if(i.visible)return r;a.push(r),r=i.fill}return!1}(d,h,u),r.boundary=oi(r),r.mapper=(s=void 0,o=(a=r).fill,!(s="dataset")===o?null:(isFinite(o)||(s="boundary"),ai[s](a))))},beforeDatasetsDraw:function(t){for(var e,n,i,r,a,o,s=t._getSortedVisibleDatasetMetas(),l=t.ctx,u=s.length-1;0<=u;--u)(e=s[u].$filler)&&e.visible&&(i=(n=e.el)._view,r=n._children||[],a=e.mapper,o=i.backgroundColor||Y.global.defaultColor,a&&o&&r.length&&(B.canvas.clipArea(l,t.chartArea),function(t,e,n,i,r,a){var o,s,l,u,d,h,c,f,g=e.length,m=i.spanGaps,p=[],v=[],y=0,b=0;for(t.beginPath(),o=0,s=g;o<s;++o)d=n(u=e[l=o%g]._view,l,i),h=si(u),c=si(d),a&&void 0===f&&h&&(s=g+(f=o+1)),h&&c?(y=p.push(u),b=v.push(d)):y&&b&&(m?(h&&p.push(u),c&&v.push(d)):(li(t,p,v,y,b),y=b=0,p=[],v=[]));li(t,p,v,y,b),t.closePath(),t.fillStyle=r,t.fill()}(l,r,a,i,o,n._loop),B.canvas.unclipArea(l)))}},di=B.rtl.getRtlAdapter,hi=B.noop,ci=B.valueOrDefault;function fi(t,e){return t.usePointStyle&&t.boxWidth>e?e:t.boxWidth}Y._set("global",{legend:{display:!0,position:"top",align:"center",fullWidth:!0,reverse:!1,weight:1e3,onClick:function(t,e){var n=e.datasetIndex,i=this.chart,r=i.getDatasetMeta(n);r.hidden=null===r.hidden?!i.data.datasets[n].hidden:null,i.update()},onHover:null,onLeave:null,labels:{boxWidth:40,padding:10,generateLabels:function(n){var i=n.data.datasets,t=n.options.legend||{},r=t.labels&&t.labels.usePointStyle;return n._getSortedDatasetMetas().map(function(t){var e=t.controller.getStyle(r?0:void 0);return{text:i[t.index].label,fillStyle:e.backgroundColor,hidden:!n.isDatasetVisible(t.index),lineCap:e.borderCapStyle,lineDash:e.borderDash,lineDashOffset:e.borderDashOffset,lineJoin:e.borderJoinStyle,lineWidth:e.borderWidth,strokeStyle:e.borderColor,pointStyle:e.pointStyle,rotation:e.rotation,datasetIndex:t.index}},this)}}},legendCallback:function(t){var e,n,i,r=document.createElement("ul"),a=t.data.datasets;for(r.setAttribute("class",t.id+"-legend"),e=0,n=a.length;e<n;e++)(i=r.appendChild(document.createElement("li"))).appendChild(document.createElement("span")).style.backgroundColor=a[e].backgroundColor,a[e].label&&i.appendChild(document.createTextNode(a[e].label));return r.outerHTML}});var gi=$.extend({initialize:function(t){B.extend(this,t),this.legendHitBoxes=[],this._hoveredItem=null,this.doughnutMode=!1},beforeUpdate:hi,update:function(t,e,n){var i=this;return i.beforeUpdate(),i.maxWidth=t,i.maxHeight=e,i.margins=n,i.beforeSetDimensions(),i.setDimensions(),i.afterSetDimensions(),i.beforeBuildLabels(),i.buildLabels(),i.afterBuildLabels(),i.beforeFit(),i.fit(),i.afterFit(),i.afterUpdate(),i.minSize},afterUpdate:hi,beforeSetDimensions:hi,setDimensions:function(){var t=this;t.isHorizontal()?(t.width=t.maxWidth,t.left=0,t.right=t.width):(t.height=t.maxHeight,t.top=0,t.bottom=t.height),t.paddingLeft=0,t.paddingTop=0,t.paddingRight=0,t.paddingBottom=0,t.minSize={width:0,height:0}},afterSetDimensions:hi,beforeBuildLabels:hi,buildLabels:function(){var e=this,n=e.options.labels||{},t=B.callback(n.generateLabels,[e.chart],e)||[];n.filter&&(t=t.filter(function(t){return n.filter(t,e.chart.data)})),e.options.reverse&&t.reverse(),e.legendItems=t},afterBuildLabels:hi,beforeFit:hi,fit:function(){var i,r,a,o,s,l,u,d,t=this,e=t.options,h=e.labels,n=e.display,c=t.ctx,f=B.options._parseFont(h),g=f.size,m=t.legendHitBoxes=[],p=t.minSize,v=t.isHorizontal();v?(p.width=t.maxWidth,p.height=n?10:0):(p.width=n?10:0,p.height=t.maxHeight),n?(c.font=f.string,v?(i=t.lineWidths=[0],r=0,c.textAlign="left",c.textBaseline="middle",B.each(t.legendItems,function(t,e){var n=fi(h,g)+g/2+c.measureText(t.text).width;(0===e||i[i.length-1]+n+2*h.padding>p.width)&&(r+=g+h.padding,i[i.length-(0<e?0:1)]=0),m[e]={left:0,top:0,width:n,height:g},i[i.length-1]+=n+h.padding}),p.height+=r):(a=h.padding,o=t.columnWidths=[],s=t.columnHeights=[],l=h.padding,d=u=0,B.each(t.legendItems,function(t,e){var n=fi(h,g)+g/2+c.measureText(t.text).width;0<e&&d+g+2*a>p.height&&(l+=u+h.padding,o.push(u),s.push(d),d=u=0),u=Math.max(u,n),d+=g+a,m[e]={left:0,top:0,width:n,height:g}}),l+=u,o.push(u),s.push(d),p.width+=l),t.width=p.width,t.height=p.height):t.width=p.width=t.height=p.height=0},afterFit:hi,isHorizontal:function(){return"top"===this.options.position||"bottom"===this.options.position},draw:function(){var _,w,t,e,k,M,S,D,C,P,T,O=this,n=O.options,A=n.labels,i=Y.global,F=i.defaultColor,I=i.elements.line,L=O.height,R=O.columnHeights,N=O.width,W=O.lineWidths;n.display&&(_=di(n.rtl,O.left,O.minSize.width),w=O.ctx,t=ci(A.fontColor,i.defaultFontColor),e=B.options._parseFont(A),k=e.size,w.textAlign=_.textAlign("left"),w.textBaseline="middle",w.lineWidth=.5,w.strokeStyle=t,w.fillStyle=t,w.font=e.string,M=fi(A,k),S=O.legendHitBoxes,D=function(t,e){switch(n.align){case"start":return A.padding;case"end":return t-e;default:return(t-e+A.padding)/2}},C=O.isHorizontal(),P=C?{x:O.left+D(N,W[0]),y:O.top+A.padding,line:0}:{x:O.left+A.padding,y:O.top+D(L,R[0]),line:0},B.rtl.overrideTextDirection(O.ctx,n.textDirection),T=k+A.padding,B.each(O.legendItems,function(t,e){var n=w.measureText(t.text).width,i=M+k/2+n,r=P.x,a=P.y;_.setWidth(O.minSize.width),C?0<e&&r+i+A.padding>O.left+O.minSize.width&&(a=P.y+=T,P.line++,r=P.x=O.left+D(N,W[P.line])):0<e&&a+T>O.top+O.minSize.height&&(r=P.x=r+O.columnWidths[P.line]+A.padding,P.line++,a=P.y=O.top+D(L,R[P.line]));var o,s,l,u,d,h,c,f,g,m,p,v,y,b,x=_.x(r);o=x,s=a,l=t,isNaN(M)||M<=0||(w.save(),u=ci(l.lineWidth,I.borderWidth),w.fillStyle=ci(l.fillStyle,F),w.lineCap=ci(l.lineCap,I.borderCapStyle),w.lineDashOffset=ci(l.lineDashOffset,I.borderDashOffset),w.lineJoin=ci(l.lineJoin,I.borderJoinStyle),w.lineWidth=u,w.strokeStyle=ci(l.strokeStyle,F),w.setLineDash&&w.setLineDash(ci(l.lineDash,I.borderDash)),A&&A.usePointStyle?(d=M*Math.SQRT2/2,h=_.xPlus(o,M/2),c=s+k/2,B.canvas.drawPoint(w,l.pointStyle,d,h,c,l.rotation)):(w.fillRect(_.leftForLtr(o,M),s,M,k),0!==u&&w.strokeRect(_.leftForLtr(o,M),s,M,k)),w.restore()),S[e].left=_.leftForLtr(x,S[e].width),S[e].top=a,f=x,g=a,m=t,p=n,v=k/2,y=_.xPlus(f,M+v),b=g+v,w.fillText(m.text,y,b),m.hidden&&(w.beginPath(),w.lineWidth=2,w.moveTo(y,b),w.lineTo(_.xPlus(y,p),b),w.stroke()),C?P.x+=i+A.padding:P.y+=T}),B.rtl.restoreTextDirection(O.ctx,n.textDirection))},_getLegendItemAt:function(t,e){var n,i,r;if(t>=this.left&&t<=this.right&&e>=this.top&&e<=this.bottom)for(r=this.legendHitBoxes,n=0;n<r.length;++n)if(t>=(i=r[n]).left&&t<=i.left+i.width&&e>=i.top&&e<=i.top+i.height)return this.legendItems[n];return null},handleEvent:function(t){var e,n=this.options,i="mouseup"===t.type?"click":t.type;if("mousemove"===i){if(!n.onHover&&!n.onLeave)return}else{if("click"!==i)return;if(!n.onClick)return}e=this._getLegendItemAt(t.x,t.y),"click"===i?e&&n.onClick&&n.onClick.call(this,t.native,e):(n.onLeave&&e!==this._hoveredItem&&(this._hoveredItem&&n.onLeave.call(this,t.native,this._hoveredItem),this._hoveredItem=e),n.onHover&&e&&n.onHover.call(this,t.native,e))}});function mi(t,e){var n=new gi({ctx:t.ctx,options:e,chart:t});he.configure(t,n,e),he.addBox(t,n),t.legend=n}var pi={id:"legend",_element:gi,beforeInit:function(t){var e=t.options.legend;e&&mi(t,e)},beforeUpdate:function(t){var e=t.options.legend,n=t.legend;e?(B.mergeIf(e,Y.global.legend),n?(he.configure(t,n,e),n.options=e):mi(t,e)):n&&(he.removeBox(t,n),delete t.legend)},afterEvent:function(t,e){var n=t.legend;n&&n.handleEvent(e)}},vi=B.noop;Y._set("global",{title:{display:!1,fontStyle:"bold",fullWidth:!0,padding:10,position:"top",text:"",weight:2e3}});var yi=$.extend({initialize:function(t){B.extend(this,t),this.legendHitBoxes=[]},beforeUpdate:vi,update:function(t,e,n){var i=this;return i.beforeUpdate(),i.maxWidth=t,i.maxHeight=e,i.margins=n,i.beforeSetDimensions(),i.setDimensions(),i.afterSetDimensions(),i.beforeBuildLabels(),i.buildLabels(),i.afterBuildLabels(),i.beforeFit(),i.fit(),i.afterFit(),i.afterUpdate(),i.minSize},afterUpdate:vi,beforeSetDimensions:vi,setDimensions:function(){var t=this;t.isHorizontal()?(t.width=t.maxWidth,t.left=0,t.right=t.width):(t.height=t.maxHeight,t.top=0,t.bottom=t.height),t.paddingLeft=0,t.paddingTop=0,t.paddingRight=0,t.paddingBottom=0,t.minSize={width:0,height:0}},afterSetDimensions:vi,beforeBuildLabels:vi,buildLabels:vi,afterBuildLabels:vi,beforeFit:vi,fit:function(){var t,e=this.options,n=this.minSize={},i=this.isHorizontal();e.display?(t=(B.isArray(e.text)?e.text.length:1)*B.options._parseFont(e).lineHeight+2*e.padding,this.width=n.width=i?this.maxWidth:t,this.height=n.height=i?t:this.maxHeight):this.width=n.width=this.height=n.height=0},afterFit:vi,isHorizontal:function(){var t=this.options.position;return"top"===t||"bottom"===t},draw:function(){var t=this.ctx,e=this.options;if(e.display){var n,i,r,a=B.options._parseFont(e),o=a.lineHeight,s=o/2+e.padding,l=0,u=this.top,d=this.left,h=this.bottom,c=this.right;t.fillStyle=B.valueOrDefault(e.fontColor,Y.global.defaultFontColor),t.font=a.string,this.isHorizontal()?(i=d+(c-d)/2,r=u+s,n=c-d):(i="left"===e.position?d+s:c-s,r=u+(h-u)/2,n=h-u,l=Math.PI*("left"===e.position?-.5:.5)),t.save(),t.translate(i,r),t.rotate(l),t.textAlign="center",t.textBaseline="middle";var f=e.text;if(B.isArray(f))for(var g=0,m=0;m<f.length;++m)t.fillText(f[m],0,g,n),g+=o;else t.fillText(f,0,0,n);t.restore()}}});function bi(t,e){var n=new yi({ctx:t.ctx,options:e,chart:t});he.configure(t,n,e),he.addBox(t,n),t.titleBlock=n}var xi={},_i=ui,wi=pi,ki={id:"title",_element:yi,beforeInit:function(t){var e=t.options.title;e&&bi(t,e)},beforeUpdate:function(t){var e=t.options.title,n=t.titleBlock;e?(B.mergeIf(e,Y.global.title),n?(he.configure(t,n,e),n.options=e):bi(t,e)):n&&(he.removeBox(t,n),delete t.titleBlock)}};function Mi(t,e,n){var i;return"string"==typeof t?(i=parseInt(t,10),-1!==t.indexOf("%")&&(i=i/100*e.parentNode[n])):i=t,i}function Si(t){return null!=t&&"none"!==t}function Di(t,e,n){var i=document.defaultView,r=B._getParentNode(t),a=i.getComputedStyle(t)[e],o=i.getComputedStyle(r)[e],s=Si(a),l=Si(o),u=Number.POSITIVE_INFINITY;return s||l?Math.min(s?Mi(a,t,n):u,l?Mi(o,r,n):u):"none"}for(var Ci in xi.filler=_i,xi.legend=wi,xi.title=ki,(Xe.helpers=B).where=function(t,e){if(B.isArray(t)&&Array.prototype.filter)return t.filter(e);var n=[];return B.each(t,function(t){e(t)&&n.push(t)}),n},B.findIndex=Array.prototype.findIndex?function(t,e,n){return t.findIndex(e,n)}:function(t,e,n){n=void 0===n?t:n;for(var i=0,r=t.length;i<r;++i)if(e.call(n,t[i],i,t))return i;return-1},B.findNextWhere=function(t,e,n){B.isNullOrUndef(n)&&(n=-1);for(var i=n+1;i<t.length;i++){var r=t[i];if(e(r))return r}},B.findPreviousWhere=function(t,e,n){B.isNullOrUndef(n)&&(n=t.length);for(var i=n-1;0<=i;i--){var r=t[i];if(e(r))return r}},B.isNumber=function(t){return!isNaN(parseFloat(t))&&isFinite(t)},B.almostEquals=function(t,e,n){return Math.abs(t-e)<n},B.almostWhole=function(t,e){var n=Math.round(t);return n-e<=t&&t<=n+e},B.max=function(t){return t.reduce(function(t,e){return isNaN(e)?t:Math.max(t,e)},Number.NEGATIVE_INFINITY)},B.min=function(t){return t.reduce(function(t,e){return isNaN(e)?t:Math.min(t,e)},Number.POSITIVE_INFINITY)},B.sign=Math.sign?function(t){return Math.sign(t)}:function(t){return 0===(t=+t)||isNaN(t)?t:0<t?1:-1},B.toRadians=function(t){return t*(Math.PI/180)},B.toDegrees=function(t){return t*(180/Math.PI)},B._decimalPlaces=function(t){if(B.isFinite(t)){for(var e=1,n=0;Math.round(t*e)/e!==t;)e*=10,n++;return n}},B.getAngleFromPoint=function(t,e){var n=e.x-t.x,i=e.y-t.y,r=Math.sqrt(n*n+i*i),a=Math.atan2(i,n);return a<-.5*Math.PI&&(a+=2*Math.PI),{angle:a,distance:r}},B.distanceBetweenPoints=function(t,e){return Math.sqrt(Math.pow(e.x-t.x,2)+Math.pow(e.y-t.y,2))},B.aliasPixel=function(t){return t%2==0?0:.5},B._alignPixel=function(t,e,n){var i=t.currentDevicePixelRatio,r=n/2;return Math.round((e-r)*i)/i+r},B.splineCurve=function(t,e,n,i){var r=t.skip?e:t,a=e,o=n.skip?e:n,s=Math.sqrt(Math.pow(a.x-r.x,2)+Math.pow(a.y-r.y,2)),l=Math.sqrt(Math.pow(o.x-a.x,2)+Math.pow(o.y-a.y,2)),u=s/(s+l),d=l/(s+l),h=i*(u=isNaN(u)?0:u),c=i*(d=isNaN(d)?0:d);return{previous:{x:a.x-h*(o.x-r.x),y:a.y-h*(o.y-r.y)},next:{x:a.x+c*(o.x-r.x),y:a.y+c*(o.y-r.y)}}},B.EPSILON=Number.EPSILON||1e-14,B.splineCurveMonotone=function(t){for(var e,n,i,r,a,o,s,l,u,d=(t||[]).map(function(t){return{model:t._model,deltaK:0,mK:0}}),h=d.length,c=0;c<h;++c){(e=d[c]).model.skip||(i=0<c?d[c-1]:null,(r=c<h-1?d[c+1]:null)&&!r.model.skip&&(n=r.model.x-e.model.x,e.deltaK=0!=n?(r.model.y-e.model.y)/n:0),!i||i.model.skip?e.mK=e.deltaK:!r||r.model.skip?e.mK=i.deltaK:this.sign(i.deltaK)!==this.sign(e.deltaK)?e.mK=0:e.mK=(i.deltaK+e.deltaK)/2)}for(c=0;c<h-1;++c)e=d[c],r=d[c+1],e.model.skip||r.model.skip||(B.almostEquals(e.deltaK,0,this.EPSILON)?e.mK=r.mK=0:(a=e.mK/e.deltaK,o=r.mK/e.deltaK,(l=Math.pow(a,2)+Math.pow(o,2))<=9||(s=3/Math.sqrt(l),e.mK=a*s*e.deltaK,r.mK=o*s*e.deltaK)));for(c=0;c<h;++c)(e=d[c]).model.skip||(i=0<c?d[c-1]:null,r=c<h-1?d[c+1]:null,i&&!i.model.skip&&(u=(e.model.x-i.model.x)/3,e.model.controlPointPreviousX=e.model.x-u,e.model.controlPointPreviousY=e.model.y-u*e.mK),r&&!r.model.skip&&(u=(r.model.x-e.model.x)/3,e.model.controlPointNextX=e.model.x+u,e.model.controlPointNextY=e.model.y+u*e.mK))},B.nextItem=function(t,e,n){return n?e>=t.length-1?t[0]:t[e+1]:e>=t.length-1?t[t.length-1]:t[e+1]},B.previousItem=function(t,e,n){return n?e<=0?t[t.length-1]:t[e-1]:e<=0?t[0]:t[e-1]},B.niceNum=function(t,e){var n=Math.floor(B.log10(t)),i=t/Math.pow(10,n),r=e?i<1.5?1:i<3?2:i<7?5:10:i<=1?1:i<=2?2:i<=5?5:10;return r*Math.pow(10,n)},B.requestAnimFrame="undefined"==typeof window?function(t){t()}:window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(t){return window.setTimeout(t,1e3/60)},B.getRelativePosition=function(t,e){var n=t.originalEvent||t,i=t.target||t.srcElement,r=i.getBoundingClientRect(),a=n.touches,o=a&&0<a.length?(f=a[0].clientX,a[0].clientY):(f=n.clientX,n.clientY),s=parseFloat(B.getStyle(i,"padding-left")),l=parseFloat(B.getStyle(i,"padding-top")),u=parseFloat(B.getStyle(i,"padding-right")),d=parseFloat(B.getStyle(i,"padding-bottom")),h=r.right-r.left-s-u,c=r.bottom-r.top-l-d,f=Math.round((f-r.left-s)/h*i.width/e.currentDevicePixelRatio);return{x:f,y:o=Math.round((o-r.top-l)/c*i.height/e.currentDevicePixelRatio)}},B.getConstraintWidth=function(t){return Di(t,"max-width","clientWidth")},B.getConstraintHeight=function(t){return Di(t,"max-height","clientHeight")},B._calculatePadding=function(t,e,n){return-1<(e=B.getStyle(t,e)).indexOf("%")?n*parseInt(e,10)/100:parseInt(e,10)},B._getParentNode=function(t){var e=t.parentNode;return e&&"[object ShadowRoot]"===e.toString()&&(e=e.host),e},B.getMaximumWidth=function(t){var e=B._getParentNode(t);if(!e)return t.clientWidth;var n=e.clientWidth,i=n-B._calculatePadding(e,"padding-left",n)-B._calculatePadding(e,"padding-right",n),r=B.getConstraintWidth(t);return isNaN(r)?i:Math.min(i,r)},B.getMaximumHeight=function(t){var e=B._getParentNode(t);if(!e)return t.clientHeight;var n=e.clientHeight,i=n-B._calculatePadding(e,"padding-top",n)-B._calculatePadding(e,"padding-bottom",n),r=B.getConstraintHeight(t);return isNaN(r)?i:Math.min(i,r)},B.getStyle=function(t,e){return t.currentStyle?t.currentStyle[e]:document.defaultView.getComputedStyle(t,null).getPropertyValue(e)},B.retinaScale=function(t,e){var n,i,r,a=t.currentDevicePixelRatio=e||"undefined"!=typeof window&&window.devicePixelRatio||1;1!==a&&(n=t.canvas,i=t.height,r=t.width,n.height=i*a,n.width=r*a,t.ctx.scale(a,a),n.style.height||n.style.width||(n.style.height=i+"px",n.style.width=r+"px"))},B.fontString=function(t,e,n){return e+" "+t+"px "+n},B.longestText=function(t,e,n,i){var r=(i=i||{}).data=i.data||{},a=i.garbageCollect=i.garbageCollect||[];i.font!==e&&(r=i.data={},a=i.garbageCollect=[],i.font=e),t.font=e;for(var o,s,l,u,d=0,h=n.length,c=0;c<h;c++)if(null!=(l=n[c])&&!0!==B.isArray(l))d=B.measureText(t,r,a,d,l);else if(B.isArray(l))for(o=0,s=l.length;o<s;o++)null==(u=l[o])||B.isArray(u)||(d=B.measureText(t,r,a,d,u));var f=a.length/2;if(f>n.length){for(c=0;c<f;c++)delete r[a[c]];a.splice(0,f)}return d},B.measureText=function(t,e,n,i,r){var a=e[r];return a||(a=e[r]=t.measureText(r).width,n.push(r)),i<a&&(i=a),i},B.numberOfLabelLines=function(t){var e=1;return B.each(t,function(t){B.isArray(t)&&t.length>e&&(e=t.length)}),e},B.color=w?function(t){return t instanceof CanvasGradient&&(t=Y.global.defaultColor),w(t)}:function(t){return console.error("Color.js not found!"),t},B.getHoverColor=function(t){return t instanceof CanvasPattern||t instanceof CanvasGradient?t:B.color(t).saturate(.5).darken(.1).rgbString()},Xe._adapters=Qe,Xe.Animation=K,Xe.animationService=J,Xe.controllers=$t,Xe.DatasetController=it,Xe.defaults=Y,Xe.Element=$,Xe.elements=wt,Xe.Interaction=ne,Xe.layouts=he,Xe.platform=Oe,Xe.plugins=Ae,Xe.Scale=mn,Xe.scaleService=Fe,Xe.Ticks=tn,Xe.Tooltip=He,Xe.helpers.each(ni,function(t,e){Xe.scaleService.registerScaleType(e,t,t._defaults)}),xi)xi.hasOwnProperty(Ci)&&Xe.plugins.register(xi[Ci]);Xe.platform.initialize();var Pi=Xe;return"undefined"!=typeof window&&(window.Chart=Xe),(Xe.Chart=Xe).Legend=xi.legend._element,Xe.Title=xi.title._element,Xe.pluginService=Xe.plugins,Xe.PluginBase=Xe.Element.extend({}),Xe.canvasHelpers=Xe.helpers.canvas,Xe.layoutService=Xe.layouts,Xe.LinearScaleBase=_n,Xe.helpers.each(["Bar","Bubble","Doughnut","Line","PolarArea","Radar","Scatter"],function(n){Xe[n]=function(t,e){return new Xe(t,Xe.helpers.merge(e||{},{type:n.charAt(0).toLowerCase()+n.slice(1)}))}}),Pi});