
var SAAdvancedMenu = function ($scope, $) {
    var $indicator_class = $(".sa-el-simple-menu-container", $scope).data(
            "indicator-class"
            );

    var $dropdown_indicator_class = $(
            ".sa-el-simple-menu-container",
            $scope
            ).data("dropdown-indicator-class");
    var $horizontal = $(".sa-el-simple-menu", $scope).hasClass(
            "sa-el-simple-menu-horizontal"
            );

    if ($horizontal) {

        $(".sa-el-simple-menu > li.menu-item-has-children", $scope).each(
                function () {
                    $("> a", $(this)).append(
                            '<span class="' + $indicator_class + '"></span>'
                            );
                }
        );
        $(".sa-el-simple-menu > li ul li.menu-item-has-children", $scope).each(
                function () {
                    $("> a", $(this)).append(
                            '<span class="' + $dropdown_indicator_class + '"></span>'
                            );
                }
        );


        $(".sa-el-simple-menu-horizontal", $scope)
                .before('<span class="sa-el-simple-menu-toggle-text"></span>')
                .after(
                        '<button class="sa-el-simple-menu-toggle"><span class="eicon-menu-bar"></span></button>'
                        );


        $(".sa-el-simple-menu-container", $scope).on(
                "click",
                ".sa-el-simple-menu-toggle",
                function (e) {
                    e.preventDefault();
                    $(this)
                            .siblings(".sa-el-simple-menu-horizontal")
                            .css("display") == "none"
                            ? $(this)
                            .siblings(".sa-el-simple-menu-horizontal")
                            .slideDown(300)
                            : $(this)
                            .siblings(".sa-el-simple-menu-horizontal")
                            .slideUp(300);
                }
        );

        $(window).on("resize load", function () {
            if (window.matchMedia("(max-width: 991px)").matches) {
                $(".sa-el-simple-menu-horizontal", $scope).addClass(
                        "sa-el-simple-menu-responsive"
                        );
                $(".sa-el-simple-menu-toggle-text", $scope).text(
                        $(
                                ".sa-el-simple-menu-horizontal .current-menu-item a",
                                $scope
                                )
                        .eq(0)
                        .text()
                        );
            } else {
                $(".sa-el-simple-menu-horizontal", $scope).removeClass(
                        "sa-el-simple-menu-responsive"
                        );
                $(
                        ".sa-el-simple-menu-horizontal, .sa-el-simple-menu-horizontal ul",
                        $scope
                        ).css("display", "");
            }
        });
    }

    $(".sa-el-simple-menu > li.menu-item-has-children", $scope).each(
            function () {

                var $height = parseInt($("a", this).css("line-height")) / 2;
                $(this).append(
                        '<span class="sa-el-simple-menu-indicator ' +
                        $indicator_class +
                        '" style="top:' +
                        $height +
                        'px"></span>'
                        );

            }
    );

    $(".sa-el-simple-menu > li ul li.menu-item-has-children", $scope).each(
            function (e) {

                var $height = parseInt($("a", this).css("line-height")) / 2;
                $(this).append(
                        '<span class="sa-el-simple-menu-indicator ' +
                        $dropdown_indicator_class +
                        '" style="top:' +
                        $height +
                        'px"></span>'
                        );

            }
    );


    $(
            ".sa-el-simple-menu-dropdown-align-left .sa-el-simple-menu-vertical li.menu-item-has-children"
            ).each(function () {
        var $padding_left = parseInt($("a", $(this)).css("padding-left"));

        $("ul li a", this).css({
            "padding-left": $padding_left + 20 + "px"
        });
    });

    $(
            ".sa-el-simple-menu-dropdown-align-right .sa-el-simple-menu-vertical li.menu-item-has-children"
            ).each(function () {
        var $padding_right = parseInt($("a", $(this)).css("padding-right"));

        $("ul li a", this).css({
            "padding-right": $padding_right + 20 + "px"
        });
    });


    $(".sa-el-simple-menu", $scope).on(
            "click",
            ".sa-el-simple-menu-indicator",
            function (e) {
                e.preventDefault();
                $(this).toggleClass("sa-el-simple-menu-indicator-open");
                $(this).hasClass("sa-el-simple-menu-indicator-open")
                        ? $(this)
                        .siblings("ul")
                        .slideDown(300)
                        : $(this)
                        .siblings("ul")
                        .slideUp(300);
            }
    );
};

jQuery(window).on("elementor/frontend/init", function () {
    elementorFrontend.hooks.addAction(
            "frontend/element_ready/sa-el-simple-menu.default",
            SAAdvancedMenu
            );
    elementorFrontend.hooks.addAction(
            "frontend/element_ready/sa-el-simple-menu.skin-one",
            SAAdvancedMenu
            );
    elementorFrontend.hooks.addAction(
            "frontend/element_ready/sa-el-simple-menu.skin-two",
            SAAdvancedMenu
            );
    elementorFrontend.hooks.addAction(
            "frontend/element_ready/sa-el-simple-menu.skin-three",
            SAAdvancedMenu
            );
    elementorFrontend.hooks.addAction(
            "frontend/element_ready/sa-el-simple-menu.skin-four",
            SAAdvancedMenu
            );
    elementorFrontend.hooks.addAction(
            "frontend/element_ready/sa-el-simple-menu.skin-five",
            SAAdvancedMenu
            );
    elementorFrontend.hooks.addAction(
            "frontend/element_ready/sa-el-simple-menu.skin-six",
            SAAdvancedMenu
            );
    elementorFrontend.hooks.addAction(
            "frontend/element_ready/sa-el-simple-menu.skin-seven",
            SAAdvancedMenu
            );
});
