/*=================================
 Logo Carousel Handler
=================================*/
var SAJustifiedGallery = function($scope, $) {
    var $item = $scope.find('.sa-el-js-justified-gallery'),
            settings = $item.getShortcodeSettings();
        $item.justifiedGallery($.extend({}, {
            rowHeight: 150,
            lastRow: 'justify',
            margins: 10,
        }, settings));
   function initFilterable($scope, filterFn) {
        var $filterable = $scope.find('.sa-el-gallery-filter');
        if ($filterable.length) {
            $filterable.on('click', 'button', function(event) {
                event.stopPropagation();

                var $current = $(this);
                $current
                    .parent()
                    .addClass('sa-el-filter-active')
                    .siblings()
                    .removeClass('sa-el-filter-active');
                filterFn($current.data('filter'));
            });
        }
    }
        initFilterable($scope, function(filter) {
            $item.justifiedGallery({
                lastRow: (filter === '*' ? settings.lastRow : 'nojustify'),
                filter: filter
            });
        });
};

jQuery(window).on("elementor/frontend/init", function() {
    elementorFrontend.hooks.addAction(
        "frontend/element_ready/sa_el_justified_gallery.default",
        SAJustifiedGallery
    );
});