/*=================================
 Image Scroller
=================================*/
var SAImageScroller = function($scope, $) {
	$(".sa-el-image-scroller-hover", $scope).hover(
		function() {
			if ($(this).hasClass("sa-el-image-scroller-vertical")) {
				var $container_height = parseInt($(this).css("height"));
				var $image_height = $("img", $(this)).height();
				var $translate = $container_height - $image_height;

				if ($translate > 0) {
					return;
				}

				$("img", $(this)).css({
					transform: "translateY(" + $translate + "px)"
				});
			} else if ($(this).hasClass("sa-el-image-scroller-horizontal")) {
				var $container_width = parseInt($(this).width());
				var $image_width = $("img", $(this)).width();
				var $translate = $container_width - $image_width;

				if ($translate > 0) {
					return;
				}

				$("img", $(this)).css({
					transform: "translateX(" + $translate + "px)"
				});
			}
		},
		function() {
			$("img", $(this)).css({
				transform: "translate(0)"
			});
		}
	);
};

jQuery(window).on("elementor/frontend/init", function() {
	elementorFrontend.hooks.addAction(
		"frontend/element_ready/sa_el_img_scroller.default",
		SAImageScroller
	);
});
