<?php

namespace Yoast\WP\SEO\AI_Generator\User_Interface;

/**
 * Trait for common permission checks in route classes.
 */
trait Route_Permission_Trait {

	/**
	 * Checks:
	 * - if the user is logged
	 * - if the user can edit posts
	 *
	 * @return bool Whether the user is logged in, can edit posts and the feature is active.
	 */
	public function check_permissions(): bool {
		$user = \wp_get_current_user();
		if ( $user === null || $user->ID < 1 ) {
			return false;
		}

		return \user_can( $user, 'edit_posts' );
	}
}
